/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class BladeFileDumpCommand
extends IPMICommand {
    private void OEM_FILE_DUMP_CMD_________() {
    }

    public BladeFileDumpCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage fileDumpCommand(byte operation) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{46, operation};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-82, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage fileDumpCommand(byte operation, byte selector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{46, operation, selector};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-82, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage fileDumpCommand(byte operation, byte[] outlier) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[outlier.length + 2];
        data[0] = 46;
        data[1] = operation;
        System.arraycopy(outlier, 0, data, 2, outlier.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-82, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage fileDumpCommand(byte operation, byte selector, byte[] outlier) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[outlier.length + 3];
        data[0] = 46;
        data[1] = operation;
        data[2] = selector;
        System.arraycopy(outlier, 0, data, 3, outlier.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-82, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void OEM_FILE_DUMP_API_________() {
    }

    public void openTextFile(byte[] fileName) throws IPMIException {
        IPMIMessage resMessage = this.fileDumpCommand((byte)0, (byte)1, fileName);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call open file failed");
    }

    public void closeFile() throws IPMIException {
        IPMIMessage resMessage = this.fileDumpCommand((byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call close file failed");
    }

    public long getFileLength() throws IPMIException {
        IPMIMessage resMessage = this.fileDumpCommand((byte)2, (byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data.length == 1) {
                    return 0L;
                }
                byte[] lengthArray = new byte[4];
                System.arraycopy(resMessage.data, 0, lengthArray, 0, 4);
                return ByteUtility.fourBytesToLongByLSBFirst(lengthArray);
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call get file status failed");
    }

    public byte[] readFile(int offset, int length) throws IPMIException {
        byte[] data = new byte[8];
        ByteUtility.intTo4Bytes(data, 0, offset);
        ByteUtility.intTo4Bytes(data, 4, length);
        IPMIMessage resMessage = this.fileDumpCommand((byte)3, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call read file failed");
    }
}

