/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class HDDStatusLogical {
    public static byte MR_LD_STATE_OFFLINE = 0;
    public static byte MR_LD_STATE_PARTIALLY_DEGRADED = 1;
    public static byte MR_LD_STATE_DEGRADED = (byte)2;
    public static byte MR_LD_STATE_OPTIMAL = (byte)3;
    public static String[][] stripeSizeDescription = new String[][]{{"04", "8K"}, {"05", "16K"}, {"07", "64K"}, {"08", "128K"}, {"09", "256K"}, {"0A", "512K"}, {"0B", "1MB"}};
    public static String[][] stateDescription = new String[][]{{"0", "OFFLINE"}, {"1", "PARTIALLY_DEGRADED"}, {"2", "DEGRADED"}, {"3", "OPTIMAL"}};
    public long size;
    public byte prl;
    public byte rlq;
    public byte srl;
    public byte stripeSize;
    public byte numDrives;
    public byte spanDepth;
    public byte state;
    byte[] raw;
    int index;
    byte[] sizeBytes = new byte[4];

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean fromRaw(byte[] raw) {
        int index = 0;
        if (raw.length < 12) {
            return false;
        }
        System.arraycopy(raw, index, this.sizeBytes, 0, this.sizeBytes.length);
        this.size = ByteUtility.twoBytesToIntLSB(this.sizeBytes);
        this.prl = raw[index += this.sizeBytes.length];
        this.rlq = raw[++index];
        this.srl = raw[++index];
        this.stripeSize = raw[++index];
        this.numDrives = raw[++index];
        this.spanDepth = raw[++index];
        this.state = raw[++index];
        ++index;
        this.raw = raw;
        return true;
    }

    public String getStripeSizeLabel(byte index) {
        String s = ByteUtility.byteToHex(index);
        for (int i = 0; i < stripeSizeDescription.length; ++i) {
            if (!s.equals(stripeSizeDescription[i][0])) continue;
            return stripeSizeDescription[i][1];
        }
        return "undefined";
    }

    public String getStateShortLabel(int index) {
        String s = "" + index;
        for (int i = 0; i < stateDescription.length; ++i) {
            if (!s.equals(stateDescription[i][0])) continue;
            return stateDescription[i][1];
        }
        return "UNDEFINED";
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-20s | %-20s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Field", "Value"));
        header.append(String.format(formatTemplate, "-----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        String formatTemplate = " %-20s | %-20s\n";
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(formatTemplate, "Size", ByteUtility.readableFileSize(this.size << 30)));
        formatedString.append(String.format(formatTemplate, "Primary RAID Level", this.prl));
        formatedString.append(String.format(formatTemplate, "Secondary RAID Level", this.srl));
        formatedString.append(String.format(formatTemplate, "RAID Level Qualifier", this.rlq));
        formatedString.append(String.format(formatTemplate, "Strip Size", this.getStripeSizeLabel(this.stripeSize)));
        formatedString.append(String.format(formatTemplate, "Number of Drives", this.numDrives));
        formatedString.append(String.format(formatTemplate, "Span Depth", this.spanDepth));
        formatedString.append(String.format(formatTemplate, "State", this.getStateShortLabel(this.state)));
        return formatedString.toString();
    }

    public static String toTableFormatedHeader() {
        String formatTemplate = " %8s | %8s | %3s | %3s | %3s | %10s | %9s | %9s | %-6s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "TargetID", "Size", "PRL", "SRL", "RLQ", "Stripe", "NumDrives", "SpanDepth", "State"));
        header.append(String.format(formatTemplate, "--------", "----", "---", "---", "---", "------", "---------", "---------", "-----"));
        return header.toString();
    }

    public String toTableFormatedString() {
        String formatTemplate = " %8s | %8s | %3s | %3s | %3s | %10s | %9s | %9s | %-6s \n";
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(formatTemplate, "" + this.index, ByteUtility.readableFileSize(this.size << 30), this.prl, this.srl, this.rlq, this.getStripeSizeLabel(this.stripeSize), this.numDrives, this.spanDepth, this.getStateShortLabel(this.state)));
        return formatedString.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toFormatedHeader());
        sb.append(this.toFormatedString());
        return sb.toString();
    }
}

