/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.PolicySuspendPeriods;
import java.util.HashMap;
import java.util.Map;

public class GetNodeManagerPolicySuspendPeriods {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMINM20Command ipmiCommand;

    public GetNodeManagerPolicySuspendPeriods(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
    }

    public PolicySuspendPeriods execute(byte domainId, byte policyId) throws IPMIException {
        IPMIMessage resMessage = this.ipmiCommand.getNodeManagerPolicySuspendPeriodsCommand(domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new PolicySuspendPeriods(resMessage.data);
            }
            throw Common.cCodeToException(completionCodeToString, resMessage);
        }
        throw new IPMIException("Call GetNodeManagerPolicySuspendPeriods failed");
    }

    static {
        completionCodeToString.put("80", "Policy ID Invalid.");
        completionCodeToString.put("81", "Domain ID Invalid.");
        completionCodeToString.put("82", "Unknown or unsupported Policy Trigger Type.");
    }
}

