/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.HDDStatus;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIHDDOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class HDDInfoCommand
extends SuperBladeCommand {
    boolean anyData = false;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            try {
                Integer.parseInt(this.parameters[0]);
                return true;
            }
            catch (Exception e) {
                MOut.G(this).println("Usage: hdd info [device id]");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        try {
            if (this.parameters != null) {
                int devID = Integer.parseInt(this.parameters[0]);
                this.drawAllInfo(devID);
                if (!this.anyData && devID > 0) {
                    MOut.G(this).println("Empty HDD Info");
                }
                this.anyData = false;
            } else {
                for (int devID = 0; devID < 3; ++devID) {
                    this.drawAllInfo(devID);
                }
                this.anyData = false;
            }
            this.statusCode = 0;
        }
        catch (IPMIException e) {
            MOut.G(this).println("This device does not support HDD interface");
            this.statusCode = 153;
        }
    }

    private void drawAllInfo(int devID) throws IPMIException {
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ipmiHDDOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIHDDOEMCommand.HDDMap map = ipmiHDDOEMCommand.getHDDMap(devID);
        if (map == null) {
            throw new IPMIException();
        }
        this.anyData = false;
        for (int i = 0; i < 120; ++i) {
            if (!map.isExist(i)) continue;
            if (!this.anyData) {
                MOut.G(this).println("\n Device ID: " + devID);
                MOut.G(this).print(HDDStatus.toTableFormatedHeader());
            }
            HDDStatus status = ipmiHDDOEMCommand.getHDDInfoStructure((byte)i, (byte)devID);
            status.setIndex(i);
            MOut.G(this).print(status.toTableFormatedString(devID));
            this.anyData = true;
        }
        if (!this.anyData && devID == 0) {
            MOut.G(this).println("Empty HDD Info");
        }
    }
}

