/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMIpv6Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPV6ModeCommand
extends SuperBladeCommand {
    int mode;

    @Override
    public boolean preValidate() {
        this.mode = 99;
        if (this.parameters != null && this.parameters.length == 1) {
            try {
                this.mode = Integer.parseInt(this.parameters[0]);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println("Invalid parameters");
                MOut.G(this).println("Usage: ipmi lan ipv6 mode [stateless:0|stateful:1]");
                return false;
            }
            if (this.mode != 0 && this.mode != 1) {
                MOut.G(this).println("Usage: ipmi lan ipv6 mode [stateless:0|stateful:1]");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIOEMIpv6Command ipmioemipv6Command = new IPMIOEMIpv6Command(null);
        ipmioemipv6Command.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.mode == 0) {
            boolean isAutoConfig = ipmioemipv6Command.isAutoConfig();
            if (ipmioemipv6Command.setIPV6Network(false, isAutoConfig)) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Fail");
            this.statusCode = 149;
            return;
        }
        if (this.mode == 1) {
            boolean isAutoConfig = ipmioemipv6Command.isAutoConfig();
            if (ipmioemipv6Command.setIPV6Network(true, isAutoConfig)) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Fail");
            this.statusCode = 149;
            return;
        }
        if (ipmioemipv6Command.isIPV6ModeStateful()) {
            MOut.G(this).println("Current mode is Stateful");
        } else {
            MOut.G(this).println("Current mode is Stateless");
        }
        this.statusCode = 0;
    }
}

