/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.lic.SWLicenseAdapter;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.swproductkey.ProductKey;
import com.supermicro.swproductkey.ProductKeyActivation;
import java.util.List;

public class NodeProductkeyListCommand
extends BIOSAbstractCommand {
    @Override
    public void runCommand() throws Exception {
        boolean x10Key = false;
        boolean x9Key = false;
        this.closeSessionIfExist();
        try {
            if (SWLicenseAdapter.isSWFRUSupported(this.config)) {
                ProductKeyActivation pkActivation = new ProductKeyActivation(this.config.getIp(), this.config.getUserName(), this.config.getPassword());
                List<ProductKey> keys = SWLicenseAdapter.getSWProductKeyList(this.config);
                for (int i = 0; i < keys.size(); ++i) {
                    ProductKey pk = keys.get(i);
                    if (pkActivation.isProductKeyExpired(pk)) {
                        MOut.G(this).println(this.getKeyDisplayName(pk.getSWID()) + "\t\t Expired");
                    } else {
                        MOut.G(this).println(this.getKeyDisplayName(pk.getSWID()) + "\t\t Activated");
                    }
                    x10Key = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createSession();
        if (this.checkIfSupportBIOSUpdate() && this.checkIfOOBProductKeyActivated()) {
            MOut.G(this).println("SFT-OOB-LIC\t\t Activated");
            x9Key = true;
        }
        if (!x9Key && !x10Key) {
            MOut.G(this).println("No Node product key activated");
        }
        this.statusCode = 0;
    }

    public String getKeyDisplayName(int aID) {
        String mDisplayName;
        switch (aID) {
            case 0: {
                mDisplayName = "Reserved";
                break;
            }
            case 1: {
                mDisplayName = "SFT-SSM-LIC";
                break;
            }
            case 2: {
                mDisplayName = "SFT-SD5-LIC";
                break;
            }
            case 3: {
                mDisplayName = "SFT-SUM-LIC";
                break;
            }
            case 4: {
                mDisplayName = "SFT-SPM-LIC";
                break;
            }
            case 5: {
                mDisplayName = "SFT-SCM-LIC";
                break;
            }
            case 6: {
                mDisplayName = "SFT-DCMS-Single";
                break;
            }
            case 7: {
                mDisplayName = "SFT-SITE-LIC";
                break;
            }
            case 8: {
                mDisplayName = "DCMS-CALL-HOME";
                break;
            }
            default: {
                mDisplayName = "Unsupported SWID:" + aID;
            }
        }
        return mDisplayName;
    }
}

