/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMITwinProCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class TPChassLocationCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMITwinProCommand ipmiTwinProCommand = new IPMITwinProCommand(null);
        ipmiTwinProCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            if (!ipmiTwinProCommand.isSupportTwinProCommand()) {
                this.statusCode = 153;
                MOut.G(this).println("Not supported device");
                return;
            }
        }
        catch (Exception e) {
            this.statusCode = 153;
            MOut.G(this).println("Cannot get MCU Info");
            return;
        }
        if (this.parameters == null) {
            byte[] chassisLocation = ipmiTwinProCommand.getChassisLocation();
            MOut.G(this).println(ByteUtility.bytesToHex(chassisLocation));
        } else if (this.parameters.length == 5) {
            byte[] chassisLocation = new byte[5];
            try {
                for (int i = 0; i < this.parameters.length; ++i) {
                    chassisLocation[i] = (byte)Integer.parseInt(this.parameters[i], 16);
                }
                ipmiTwinProCommand.setChassisLocation(chassisLocation);
                MOut.G(this).println("Done");
            }
            catch (NumberFormatException ex) {
                this.statusCode = 147;
                MOut.G(this).println("Paremeters failed");
                return;
            }
        } else {
            this.statusCode = 147;
            MOut.G(this).println("Paremeters failed");
            return;
        }
        this.statusCode = 0;
    }
}

