/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import nn.pp.rc.ImageButton;
import nn.pp.rc.ImageLoader;
import nn.pp.sara.FramePanelFrame;
import nn.pp.sara.SasForensicPanel;

abstract class FramePanel
extends Panel
implements ActionListener {
    URL codeBase;
    Panel parentPanel;
    ImageButton frameButton;
    boolean inFrame = true;
    Panel mainPanel;
    FramePanelFrame frame;

    public FramePanel(URL codeBase, SasForensicPanel parentPanel) {
        this.codeBase = codeBase;
        this.parentPanel = parentPanel;
        this.frame = new FramePanelFrame(this, this.getFrameName());
        ImageLoader imgloader = new ImageLoader(codeBase);
        Image imageButtons = imgloader.loadImage("nn/pp/sara/windows.gif");
        Dimension btnDim = new Dimension(30, 26);
        this.frameButton = new ImageButton(imageButtons, btnDim, this.inFrame ? 1 : 0);
    }

    @Override
    public void show() {
        super.show();
        if (this.inFrame) {
            this.frame.show();
            this.frame.toFront();
        }
    }

    @Override
    public void hide() {
        super.hide();
        if (this.inFrame) {
            this.frame.hide();
        }
    }

    void switchInFrame() {
        if (this.inFrame) {
            this.frame.hide();
            this.frame.remove(this.mainPanel);
            this.frame.pack();
            this.add(this.mainPanel);
            this.addVisualPanels(false);
            this.pack();
        } else {
            this.remove(this.mainPanel);
            this.pack();
            this.addVisualPanels(true);
            this.frame.add(this.mainPanel);
            this.frame.pack();
            this.frame.show();
        }
        this.inFrame = !this.inFrame;
        this.frameButton.setImageIndex(this.inFrame ? 1 : 0);
    }

    protected void addVisualPanels(boolean inFrame) {
    }

    Frame getFrame() {
        Container f = this.parentPanel.getParent();
        if (f instanceof Frame) {
            return (Frame)f;
        }
        return null;
    }

    public void pack() {
        Frame f = this.getFrame();
        if (f != null) {
            f.pack();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.frameButton) {
            this.switchInFrame();
        }
    }

    protected Panel getFrameButtonPanel() {
        Panel frameButtonPanel = new Panel();
        frameButtonPanel.setLayout(new FlowLayout());
        this.frameButton.addActionListener(this);
        frameButtonPanel.add(this.frameButton);
        return frameButtonPanel;
    }

    protected void showInitial() {
        if (this.inFrame) {
            this.frame.add((Component)this.mainPanel, "Center");
            this.frame.show();
            this.frame.pack();
        } else {
            this.add((Component)this.mainPanel, "Center");
        }
    }

    protected abstract String getFrameName();
}

