/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.IUSBRedirSession;
import com.ami.iusb.SMCVMManager;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.CommandPlugIn;
import com.supermicro.ipmi.text.MOut;

public class SMCVMPlugIn
extends CommandPlugIn {
    public SMCVMPlugIn() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"floppy", "usbkey", "iso", "cd", "stopFloppy", "stopUsbkey", "stopCD", "stopISO", "status"};
    }

    @Override
    public void execute() throws Exception {
        if (!this.isVirutalMediaSupported()) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        if (this.parameters == null || this.parameters.length == 0) {
            this.usage();
            return;
        }
        String subCommand = this.parameters[0];
        if (subCommand.equalsIgnoreCase("floppy")) {
            if (this.parameters.length < 2) {
                this.usage();
                return;
            }
            this.setFloppy(this.parameters[1]);
        } else if (subCommand.equalsIgnoreCase("usbkey")) {
            if (this.parameters.length < 2) {
                this.usage();
                return;
            }
            this.setUSBKey(this.parameters[1]);
        } else if (subCommand.equalsIgnoreCase("iso")) {
            if (this.parameters.length < 2) {
                this.usage();
                return;
            }
            this.setISO(this.parameters[1]);
        } else if (subCommand.equalsIgnoreCase("cd")) {
            if (this.parameters.length < 2) {
                this.usage();
                return;
            }
            this.setCD(this.parameters[1]);
        } else if (subCommand.equalsIgnoreCase("stopFloppy")) {
            this.stopFloppy();
        } else if (subCommand.equalsIgnoreCase("stopUsbkey")) {
            this.stopFloppy();
        } else if (subCommand.equalsIgnoreCase("stopCD")) {
            this.stopCD();
        } else if (subCommand.equalsIgnoreCase("stopISO")) {
            this.stopCD();
        } else if (subCommand.equalsIgnoreCase("status") || subCommand.equalsIgnoreCase("st")) {
            try {
                this.showStatus();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.usage();
            return;
        }
    }

    public boolean isVirutalMediaSupported() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            return false;
        }
        if (IPMIMessagingCommand.isAMIGUID(guid)) {
            return true;
        }
        return IPMIMessagingCommand.isAMISIMBLGUID(guid);
    }

    public void printSlaveCMMUnavailableMessage() {
        MOut.G().println("This function is unavailable for this device");
    }

    public void usage() {
        MOut.G().printf("Available commands:\n", new Object[0]);
        MOut.G().printf("%-25s \t %-20s \n", "vmw floppy <image file>", "Floppy image as virtual media");
        MOut.G().printf("%-25s \t %-20s \n", "vmw usbkey <drive letter>", "USB key as virutal media");
        MOut.G().printf("%-25s \t %-20s \n", "vmw iso    <ISO file>", "ISO file as virtual media");
        MOut.G().printf("%-25s \t %-20s \n", "vmw cd     <drive letter>", "CD/DVD drive as virutal media");
        MOut.G().printf("%-25s \t %-20s \n", "vmw stopFloppy", "Stop connected floppy");
        MOut.G().printf("%-25s \t %-20s \n", "vmw stopUsbkey", "Stop connected USBKey");
        MOut.G().printf("%-25s \t %-20s \n", "vmw stopISO", "Stop connected ISO");
        MOut.G().printf("%-25s \t %-20s \n", "vmw stopCD", "Stop connected CD/DVD");
        MOut.G().printf("%-25s \t %-20s \n", "vmw status(st)", "Virtual Media status");
        MOut.G().println("Note:");
        MOut.G().println("1: These virtual media functions are dediated for SIMSOW series IPMI device");
        MOut.G().println("2: If your path include space, please place double quote");
        MOut.G().println("   at begin and end of <file>");
        MOut.G().println("3: The drive redirection will stop once you quit shell mode");
    }

    private IUSBRedirSession getIUSBRedirSession() {
        String ip = this.config.getIp();
        IUSBRedirSession iUSBRedirSession = SMCVMManager.getInstance().createIUSBRedirSession(ip);
        return iUSBRedirSession;
    }

    private String getToken() throws Exception {
        String ip = this.config.getIp();
        String id = this.config.getUserName();
        String pw = this.config.getPassword();
        String token = SMCVMManager.getInstance().helpGetKVMSessionToken(ip, id, pw);
        return token;
    }

    public void setFloppy(String filename) throws Exception {
        MOut.G().printf("Connecting ...", new Object[0]);
        String token = this.getToken();
        boolean result = this.getIUSBRedirSession().simpleStartFloppyImageRedir(this.config.getIp(), token, filename);
        if (result) {
            MOut.G().println("Done");
        }
    }

    public void setUSBKey(String drive) throws Exception {
        drive = drive.toUpperCase();
        MOut.G().printf("Connecting ...", new Object[0]);
        String token = this.getToken();
        boolean result = this.getIUSBRedirSession().simpleStartFloppyRedir(this.config.getIp(), token, drive);
        if (result) {
            MOut.G().println("Done");
        }
    }

    public void setISO(String filename) throws Exception {
        MOut.G().printf("Connecting ...", new Object[0]);
        String token = this.getToken();
        boolean result = this.getIUSBRedirSession().simpleStartISORedir(this.config.getIp(), token, filename);
        if (result) {
            MOut.G().println("Done");
        }
    }

    public void setCD(String drive) throws Exception {
        drive = drive.toUpperCase();
        MOut.G().printf("Connecting ...", new Object[0]);
        String token = this.getToken();
        boolean result = this.getIUSBRedirSession().simpleStartCDROMRedir(this.config.getIp(), token, drive);
        if (result) {
            MOut.G().println("Done");
        }
    }

    public void stopFloppy() throws Exception {
        MOut.G().printf("Disconnecting ...", new Object[0]);
        this.getIUSBRedirSession().StopFloppyRedir();
        MOut.G().println("Done");
    }

    public void stopCD() throws Exception {
        MOut.G().printf("Disconnecting ...", new Object[0]);
        this.getIUSBRedirSession().StopCDROMRedir();
        MOut.G().println("Done");
    }

    public void showStatus() {
        if (SMCVMManager.getInstance().hosts.size() == 0) {
            MOut.G().println("empty");
        }
        for (String ip : SMCVMManager.getInstance().hosts.keySet()) {
            IUSBRedirSession iUSBRedirSession = SMCVMManager.getInstance().hosts.get(ip);
            this.showStatus(ip, iUSBRedirSession);
        }
    }

    private void showStatus(String ip, IUSBRedirSession iUSBRedirSession) {
        String fdRead = iUSBRedirSession.getFloppyReadBytes() + "KB";
        String fdSource = iUSBRedirSession.getFloppySource();
        String fdStatus = "";
        switch (iUSBRedirSession.getFloppyRedirStatus()) {
            case 0: {
                fdStatus = "Not Connected";
                fdRead = "n/a";
                break;
            }
            case 1: {
                fdStatus = "Connected";
                break;
            }
            case 2: {
                fdStatus = "Transfering";
            }
        }
        String cdRead = iUSBRedirSession.getCDROMReadBytes() + "KB";
        String cdSource = iUSBRedirSession.getCDROMSource();
        String cdStatus = "";
        switch (iUSBRedirSession.getCDROMRedirStatus()) {
            case 0: {
                cdStatus = "Not Connected";
                cdRead = "n/a";
                break;
            }
            case 1: {
                cdStatus = "Connected";
                break;
            }
            case 2: {
                cdStatus = "Transfering";
            }
        }
        MOut.G().println("\nIP           : " + ip);
        MOut.G().println("Target Drive : Virtual Floppy");
        MOut.G().println("Read Bytes   : " + fdRead);
        MOut.G().println("Status       : " + fdStatus);
        MOut.G().println("Connected to : " + fdSource);
        MOut.G().println("");
        MOut.G().println("Target Drive : Virtual CD");
        MOut.G().println("Read Bytes   : " + cdRead);
        MOut.G().println("Status       : " + cdStatus);
        MOut.G().println("Connected to : " + cdSource);
    }

    @Override
    public String getAlternateValue() {
        return null;
    }

    @Override
    public String getComment() {
        return "SIM(W) Virtual Media";
    }

    @Override
    public String getName() {
        return "vmw";
    }

    @Override
    public String getValue() {
        return "vmw";
    }

    @Override
    public boolean isSupportCLIMode() {
        return false;
    }

    @Override
    public boolean isSupportShellMode() {
        return true;
    }

    public static void main(String[] args) {
    }
}

