/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.communication;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.Client;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class NWListener
implements Runnable {
    private Selector m_select = null;
    private boolean m_run = false;
    private Client m_clnt;
    private SelectionKey VideoSelectionKey;
    private SelectionKey HIDSelectionKey;
    static int count = 0;

    public NWListener() {
        try {
            this.m_select = Selector.open();
        }
        catch (IOException e) {
            Debug.out.println(e);
        }
        this.m_run = true;
    }

    public int addChannels(Client clnt) {
        try {
            SocketChannel vidch = clnt.getSockChannel();
            SocketChannel hidch = clnt.getHIDSockChannel();
            this.VideoSelectionKey = vidch.register(this.m_select, 1);
            this.HIDSelectionKey = hidch.register(this.m_select, 1);
            this.m_clnt = clnt;
        }
        catch (ClosedChannelException e) {
            Debug.out.println(e);
            return -1;
        }
        return 0;
    }

    public void removeChannels(Client clnt) {
        this.destroyListener();
        SocketChannel vidch = clnt.getSockChannel();
        SocketChannel hidch = clnt.getHIDSockChannel();
        vidch.keyFor(this.m_select).cancel();
        hidch.keyFor(this.m_select).cancel();
    }

    public void startListener() {
        this.m_run = true;
    }

    public void destroyListener() {
        this.m_run = false;
        this.m_select.wakeup();
        try {
            this.m_select.selectNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.m_run) {
            if (this.m_clnt.IsVideoDataAvailable()) {
                this.m_clnt.onReadEvent();
                continue;
            }
            if (this.m_clnt.IsHIDDataAvailable()) {
                this.m_clnt.onHIDReadEvent();
                continue;
            }
            try {
                this.m_select.select();
            }
            catch (IOException e) {
                Debug.out.println("NW_LISTENER " + e);
            }
            if (!this.m_run) continue;
            if (this.VideoSelectionKey.isReadable()) {
                this.m_clnt.onReadEvent();
            }
            if (!this.HIDSelectionKey.isReadable()) continue;
            this.m_clnt.onHIDReadEvent();
        }
    }
}

