/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractSBEntity;
import com.supermicro.ipmi.microblade.Sensor;

public class SB_B1SA4F
extends AbstractSBEntity {
    public Sensor cpu1Temp;
    public Sensor system1Temp;
    public Sensor system2Temp;
    public Sensor dimmA1Temp;
    public Sensor dimmB1Temp;
    public Sensor v12SB;
    public Sensor v5SB;
    public Sensor v3P3SB;
    public Sensor v3P3;
    public Sensor vDDR;
    public Sensor vCCP;
    public Sensor vBAT;
    public Sensor watchdog;
    public Sensor pwr;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.cpu1Temp = new Sensor();
        this.cpu1Temp.fromRaw(ByteUtility.getBytes(raw, index, 12));
        this.system1Temp = new Sensor();
        this.system1Temp.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.system2Temp = new Sensor();
        this.system2Temp.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.dimmA1Temp = new Sensor();
        this.dimmA1Temp.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.dimmB1Temp = new Sensor();
        this.dimmB1Temp.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.v12SB = new Sensor();
        this.v12SB.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.v5SB = new Sensor();
        this.v5SB.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.v3P3SB = new Sensor();
        this.v3P3SB.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.v3P3 = new Sensor();
        this.v3P3.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.vDDR = new Sensor();
        this.vDDR.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.vCCP = new Sensor();
        this.vCCP.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.vBAT = new Sensor();
        this.vBAT.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.watchdog = new Sensor();
        this.watchdog.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        this.pwr = new Sensor();
        this.pwr.fromRaw(ByteUtility.getBytes(raw, index += 12, 12));
        index += 12;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("cpu1Temp :\n" + this.cpu1Temp);
        sb.append("\nsystem1Temp :\n" + this.system1Temp);
        sb.append("\nsystem2Temp :\n" + this.system2Temp);
        sb.append("\ndimmA1Temp :\n" + this.dimmA1Temp);
        sb.append("\ndimmB1Temp :\n" + this.dimmB1Temp);
        sb.append("\nv12SB :\n" + this.v12SB);
        sb.append("\nv5SB :\n" + this.v5SB);
        sb.append("\nv3P3SB :\n" + this.v3P3SB);
        sb.append("\nv3P3 :\n" + this.v3P3);
        sb.append("\nvDDR :\n" + this.vDDR);
        sb.append("\nvCCP :\n" + this.vCCP);
        sb.append("\nvBAT :\n" + this.vBAT);
        sb.append("\nWatchdog :\n" + this.watchdog);
        sb.append("\nPW Consumption :\n" + this.pwr);
        sb.append("\nRAW :\n" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    @Override
    public String toFormatedString() {
        StringBuffer formatedString = new StringBuffer();
        if (this.cpu1Temp.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "CPU Temp", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.cpu1Temp.getStatusString(true), "CPU Temp", this.cpu1Temp.getHumanReading(this.cpu1Temp.reading) + "\u00b0C", this.cpu1Temp.getHumanReadingWithSign(this.cpu1Temp.min) + "\u00b0C", this.cpu1Temp.getHumanReadingWithSign(this.cpu1Temp.max) + "\u00b0C"));
        }
        if (this.system1Temp.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "System Temp", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.system1Temp.getStatusString(true), "System Temp", this.system1Temp.getHumanReading(this.system1Temp.reading) + "\u00b0C", this.system1Temp.getHumanReadingWithSign(this.system1Temp.min) + "\u00b0C", this.system1Temp.getHumanReadingWithSign(this.system1Temp.max) + "\u00b0C"));
        }
        if (this.system2Temp.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "Peripheral Temp", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.system2Temp.getStatusString(true), "Peripheral Temp", this.system2Temp.getHumanReading(this.system2Temp.reading) + "\u00b0C", this.system2Temp.getHumanReadingWithSign(this.system2Temp.min) + "\u00b0C", this.system2Temp.getHumanReadingWithSign(this.system2Temp.max) + "\u00b0C"));
        }
        if (this.dimmA1Temp.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "DIMM A1 Temp", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.dimmA1Temp.getStatusString(true), "DIMM A1 Temp", this.dimmA1Temp.getHumanReading(this.dimmA1Temp.reading) + "\u00b0C", this.dimmA1Temp.getHumanReadingWithSign(this.dimmA1Temp.min) + "\u00b0C", this.dimmA1Temp.getHumanReadingWithSign(this.dimmA1Temp.max) + "\u00b0C"));
        }
        if (this.dimmB1Temp.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "DIMM B1 Temp", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.dimmB1Temp.getStatusString(true), "DIMM B1 Temp", this.dimmB1Temp.getHumanReading(this.dimmB1Temp.reading) + "\u00b0C", this.dimmB1Temp.getHumanReadingWithSign(this.dimmB1Temp.min) + "\u00b0C", this.dimmB1Temp.getHumanReadingWithSign(this.dimmB1Temp.max) + "\u00b0C"));
        }
        if (this.vCCP.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "VCORE", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.vCCP.getStatusString(false), "VCORE", this.vCCP.getHumanReading(this.vCCP.reading) + " V", this.vCCP.getHumanReading(this.vCCP.min) + " V", this.vCCP.getHumanReading(this.vCCP.max) + " V"));
        }
        if (this.vDDR.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "VDIMM", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.vDDR.getStatusString(false), "VDIMM", this.vDDR.getHumanReading(this.vDDR.reading) + " V", this.vDDR.getHumanReading(this.vDDR.min) + " V", this.vDDR.getHumanReading(this.vDDR.max) + " V"));
        }
        if (this.v12SB.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "12VSB", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.v12SB.getStatusString(false), "12VSB", this.v12SB.getHumanReading(this.v12SB.reading) + " V", this.v12SB.getHumanReading(this.v12SB.min) + " V", this.v12SB.getHumanReading(this.v12SB.max) + " V"));
        }
        if (this.v3P3.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "3.3VCC", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.v3P3.getStatusString(false), "3.3VCC", this.v3P3.getHumanReading(this.v3P3.reading) + " V", this.v3P3.getHumanReading(this.v3P3.min) + " V", this.v3P3.getHumanReading(this.v3P3.max) + " V"));
        }
        if (this.v5SB.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "5VSB", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.v5SB.getStatusString(false), "5VSB", this.v5SB.getHumanReading(this.v5SB.reading) + " V", this.v5SB.getHumanReading(this.v5SB.min) + " V", this.v5SB.getHumanReading(this.v5SB.max) + " V"));
        }
        if (this.v3P3SB.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "3V3SB", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, this.v3P3SB.getStatusString(false), "3V3SB", this.v3P3SB.getHumanReading(this.v3P3SB.reading) + " V", this.v3P3SB.getHumanReading(this.v3P3SB.min) + " V", this.v3P3SB.getHumanReading(this.v3P3SB.max) + " V"));
        }
        if (this.watchdog.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "Watchdog", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, "Normal", "Watchdog", this.getWatchDogStatus(this.watchdog.reading), "N/A", "N/A"));
        }
        if (this.pwr.reading == 0) {
            formatedString.append(String.format(this.formatTemplate, "N/A", "PW Consumption", "N/A", "N/A", "N/A"));
        } else {
            formatedString.append(String.format(this.formatTemplate, "Normal", "PW Consumption", this.pwr.getHumanReading(this.pwr.reading) + " W", "N/A", "N/A"));
        }
        return formatedString.toString();
    }

    @Override
    public int getSensorDisplayNumber() {
        return 14;
    }
}

