/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractSBEntity;
import com.supermicro.ipmi.microblade.Sensor;
import com.supermicro.ipmi.text.MOut;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class SB_B2SS2_MTF
extends AbstractSBEntity {
    public Sensor cpuTemp = new Sensor();
    public Sensor pchTemp = new Sensor();
    public Sensor cpu1vrm1Temp = new Sensor();
    public Sensor cpu1vrm2Temp = new Sensor();
    public Sensor systemTemp = new Sensor();
    public Sensor peripheralTemp = new Sensor();
    public Sensor x710_10GTemp = new Sensor();
    public Sensor dimmA1Temp = new Sensor();
    public Sensor dimmB1Temp = new Sensor();
    public Sensor v12SB = new Sensor();
    public Sensor v5SB = new Sensor();
    public Sensor v3P3 = new Sensor();
    public Sensor vBAT = new Sensor();
    public Sensor vCPU = new Sensor();
    public Sensor vCCSA = new Sensor();
    public Sensor vDIMM = new Sensor();
    public Sensor v3P3SB = new Sensor();
    public Sensor watchdog = new Sensor();
    public Sensor pwr = new Sensor();

    @Override
    public void fromRaw(byte[] raw) {
        Field[] fields;
        super.fromRaw(raw);
        int index = 0;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                ((Sensor)field.get(this)).fromRaw(ByteUtility.getBytes(raw, index, 12));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            index += 12;
        }
    }

    @Override
    public String toFormatedString() {
        StringBuffer formatedString = new StringBuffer();
        LinkedHashMap<Sensor, String[]> map = new LinkedHashMap<Sensor, String[]>();
        map.put(this.cpuTemp, new String[]{"CPU Temp", "T"});
        map.put(this.systemTemp, new String[]{"System Temp", "T"});
        map.put(this.peripheralTemp, new String[]{"Peripheral Temp", "T"});
        map.put(this.x710_10GTemp, new String[]{"X710 10G Temp", "T"});
        map.put(this.pchTemp, new String[]{"PCH Temp", "T"});
        map.put(this.cpu1vrm1Temp, new String[]{"CPU1VRM1 Temp", "T"});
        map.put(this.cpu1vrm2Temp, new String[]{"CPU1VRM2 Temp", "T"});
        map.put(this.dimmA1Temp, new String[]{"P1_DIMMA1 Temp", "T"});
        map.put(this.dimmB1Temp, new String[]{"P1_DIMMB1 Temp", "T"});
        map.put(this.vCCSA, new String[]{"VCCSA", "V"});
        map.put(this.vCPU, new String[]{"Vcpu", "V"});
        map.put(this.vDIMM, new String[]{"VDIMM", "V"});
        map.put(this.v3P3, new String[]{"3.3VCC", "V"});
        map.put(this.v12SB, new String[]{"12VSB", "V"});
        map.put(this.v5SB, new String[]{"5VSB", "V"});
        map.put(this.v3P3SB, new String[]{"3.3VSB", "V"});
        map.put(this.vBAT, new String[]{"VBAT", "B"});
        map.put(this.watchdog, new String[]{"Watchdog", "W"});
        map.put(this.pwr, new String[]{"PW Consumption", "P"});
        for (Map.Entry entry : map.entrySet()) {
            try {
                Sensor sensor = (Sensor)entry.getKey();
                String name = ((String[])entry.getValue())[0];
                String type = ((String[])entry.getValue())[1];
                if (sensor.reading == 0) {
                    formatedString.append(String.format(this.formatTemplate, "N/A", name, "N/A", "N/A", "N/A"));
                    continue;
                }
                if ("T".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(true), name, sensor.getHumanReading(sensor.reading) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.min) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.max) + "\u00b0C"));
                    continue;
                }
                if ("V".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(false), name, sensor.getHumanReading(sensor.reading) + " V", sensor.getHumanReading(sensor.min) + " V", sensor.getHumanReading(sensor.max) + " V"));
                    continue;
                }
                if ("B".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, this.vBAT.getStatusString(false).contains("Lower") ? this.vBAT.getStatusString(false) : "Normal", "VBAT", this.vBAT.getHumanReading(this.vBAT.reading) + " V", this.vBAT.getHumanReading(this.vBAT.min) + " V", "N/A"));
                    continue;
                }
                if ("W".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "Watchdog", this.getWatchDogStatus(this.watchdog.reading), "N/A", "N/A"));
                    continue;
                }
                if ("P".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "PW Consumption", this.pwr.getHumanReading(this.pwr.reading) + " W", "N/A", "N/A"));
                    continue;
                }
                MOut.G().println("Sensor Type Not Found.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return formatedString.toString();
    }

    @Override
    public int getSensorDisplayNumber() {
        return 20;
    }
}

