/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.dcmi;

import com.supermicro.ipmi.IPMIDCMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.nm.Common;
import java.util.HashMap;
import java.util.Map;

public class ActivatePowerLimit {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMIDCMICommand dcmi;
    private int activation;

    public ActivatePowerLimit(IPMIDCMICommand dcmi, int activation) {
        this.dcmi = dcmi;
        this.activation = activation;
    }

    public void execute() throws IPMIException {
        IPMIMessage resMessage = this.dcmi.activatePowerLimitCommand((byte)this.activation);
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                throw Common.cCodeToException(completionCodeToString, resMessage);
            }
        } else {
            throw new IPMIException("Call ActivatePowerLimit failed");
        }
    }

    static {
        completionCodeToString.put("C1", "Returned if DCMI mode is not present.");
    }
}

