/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladePowerCommand
extends SuperBladeCommand {
    public static final int ON = 0;
    public static final int OFF = 1;
    public static final int GRACEFULSHUTDOWN = 2;
    public static final int RESET = 3;
    public static final int NO_COMMAND = 99;
    private int subCommand = -1;
    boolean isMicroBlade = false;

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"up", "down", "softshutdown", "reset"};
    }

    @Override
    public boolean preValidate() {
        boolean passValidate = false;
        int maxBladeSize = this.getBladeMaxSize();
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid)) {
            this.isMicroBlade = true;
            String bladeIndexString = (String)this.preParameters.get(1);
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndexString);
            if (bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                return false;
            }
        } else {
            byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
            if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
                MOut.G(this).println("blade Index out of range");
                return false;
            }
        }
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("up")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("down")) {
                this.subCommand = 1;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("softshutdown")) {
                this.subCommand = 2;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("reset")) {
                this.subCommand = 3;
                passValidate = true;
            }
        } else {
            this.subCommand = 99;
            passValidate = true;
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        MOut.G(this).println("Available commands: up, down, softshutdown, reset");
    }

    @Override
    public void runCommand() throws Exception {
        if (this.isMicroBlade) {
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
            ipmiMicroBladeOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            String bladeIndex = (String)this.preParameters.get(1);
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex);
            NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus(bIndex, (byte)0);
            if (nodeStatusInfo.initialized() && bladeRemoteInfo.isPresent()) {
                switch (this.subCommand) {
                    case 0: {
                        ipmiMicroBladeOEMCommand.setNodeStatus(bIndex, 0, 1);
                        this.statusCode = 0;
                        MOut.G(this).println("Done");
                        break;
                    }
                    case 1: {
                        ipmiMicroBladeOEMCommand.setNodeStatus(bIndex, 0, 0);
                        this.statusCode = 0;
                        MOut.G(this).println("Done");
                        break;
                    }
                    case 2: {
                        ipmiMicroBladeOEMCommand.setNodeStatus(bIndex, 0, 5);
                        this.statusCode = 0;
                        MOut.G(this).println("Done");
                        break;
                    }
                    case 3: {
                        ipmiMicroBladeOEMCommand.setNodeStatus(bIndex, 0, 3);
                        this.statusCode = 0;
                        MOut.G(this).println("Done");
                        break;
                    }
                    case 99: {
                        String power = ipmiMicroBladeOEMCommand.getNodeStatus((int)bIndex, 0) == 1 ? "On" : "Off";
                        MOut.G(this).println("Power: " + power);
                        this.printUsage();
                        this.statusCode = 0;
                    }
                }
            } else {
                MOut.G(this).println("Blade " + bladeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            this.statusCode = 0;
            return;
        }
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.setIsQueryMBSensorEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        switch (this.subCommand) {
            case 0: {
                int result = this.ipmiCMMOEMCommand.enableP12V(bladeIndex, (byte)1);
                if (result == 0) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                if (result == 1) {
                    MOut.G(this).println("No enough power");
                    this.statusCode = 215;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case 1: {
                int result = this.ipmiCMMOEMCommand.enableP12V(bladeIndex, (byte)0);
                if (result == 0) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                if (result == 1) {
                    MOut.G(this).println("No enough power");
                    this.statusCode = 215;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case 2: {
                boolean boolResult = this.ipmiCMMOEMCommand.gracefulPowerDownBlade(bladeIndex);
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case 3: {
                boolean boolResult = this.ipmiCMMOEMCommand.resetBlade(bladeIndex);
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case 99: {
                String power = bladeEntity.isV12vEnable() && bladeEntity.isV3_3v() ? "On" : "Off";
                MOut.G(this).println("Power: " + power);
                this.printUsage();
                this.statusCode = 0;
            }
        }
    }
}

