/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeUIDCommand
extends SuperBladeCommand {
    public static final int ON = 0;
    public static final int OFF = 1;
    private int subCommand = -1;

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"on", "off"};
    }

    @Override
    public boolean preValidate() {
        boolean passValidate = false;
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("on")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("off")) {
                this.subCommand = 1;
                passValidate = true;
            }
        }
        if (!passValidate) {
            MOut.G(this).println("Available command: on,off");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.setIsQueryMBSensorEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        switch (this.subCommand) {
            case 0: {
                boolean boolResult = this.ipmiCMMOEMCommand.setBladeUID(bladeIndex, (byte)1);
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case 1: {
                boolean boolResult = this.ipmiCMMOEMCommand.setBladeUID(bladeIndex, (byte)0);
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        }
    }
}

