/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMNtpCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        this.preParameters.remove(0);
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.G(this).println("CMM Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        boolean isMicroBlade = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid)) {
            isMicroBlade = true;
        }
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!isMicroBlade && !this.isConnectToCMM(cmmIndex - 1)) {
            MOut.G(this).println("This function is only available for the CMM connected");
            this.statusCode = 152;
            return;
        }
        if (this.parameters != null && this.parameters.length >= 2) {
            byte utcOffset = 0;
            String ntp1 = "";
            String ntp2 = "";
            try {
                utcOffset = (byte)Integer.parseInt(this.parameters[0]);
                if (utcOffset < -11 || utcOffset > 12) {
                    MOut.G(this).print("UTC Offset out of range (-11 to +12)");
                    this.statusCode = 147;
                    return;
                }
            }
            catch (NumberFormatException ex) {
                MOut.G(this).print(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            ntp1 = this.parameters[1];
            if (this.parameters.length > 2) {
                ntp2 = this.parameters[2];
            }
            if (isMicroBlade) {
                this.ipmiCMMOEMCommand.clearBusyFlag();
                this.writeNTPServerForMicroBlade(ntp1, ntp2);
                return;
            }
            if (this.processNTPServerIfDHCPMode(utcOffset)) {
                this.statusCode = 0;
                return;
            }
            this.writeNTPServer(utcOffset, ntp1, ntp2);
        } else {
            this.printNTPServerList();
            this.statusCode = 0;
        }
    }

    public boolean processNTPServerIfDHCPMode(byte utcOffset) {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte type = ipmiLanCommand.getLanSettingType();
        if (type != 2) {
            return false;
        }
        MOut.G(this).println("The NTP Server configuration is obtained automatically. For proper");
        MOut.G(this).println("fucntion, please make sure that the BOOTP/DHCP server used by");
        MOut.G(this).println("this device provides correct time server information.");
        MOut.G(this).print("\nSet synchronize with NTP Server...");
        try {
            boolean result = this.ipmiCMMOEMCommand.setNTPMode();
            boolean result2 = this.ipmiCMMOEMCommand.setUTCOffset(utcOffset);
            if (result && result2) {
                MOut.G(this).println("Done");
            } else {
                MOut.G(this).println("Failed");
            }
        }
        catch (IPMIException ex) {
            MOut.G(this).println(ex.toString());
        }
        return true;
    }

    public void writeNTPServer(byte utcOffset, String ntp1, String ntp2) {
        try {
            this.ipmiCMMOEMCommand.setAllNTPServer(utcOffset, ntp1, ntp2);
        }
        catch (IPMIException ex) {
            MOut.G(this).println("Set NTP server failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }

    public void writeNTPServerForMicroBlade(String ntp1, String ntp2) {
        if (ntp1 != null) {
            try {
                this.ipmiCMMOEMCommand.setNTPServerPrimary(ntp1);
            }
            catch (IPMIException ex) {
                MOut.G(this).println("Set Prmiary NTP (NTP1) failed");
                return;
            }
        }
        if (ntp2 != null && ntp2.length() != 0) {
            try {
                this.ipmiCMMOEMCommand.setNTPServerSecondary(ntp2);
            }
            catch (IPMIException ex) {
                MOut.G(this).println("Set Prmiary NTP (NTP2) failed");
                return;
            }
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] ntpData = null;
        try {
            ntpData = ipmiOEMWebSettingCommand.getNTPDateTime((byte)0);
        }
        catch (IPMIException ex) {
            MOut.G(this).println("Get NTP Date and Time failed");
            this.statusCode = 149;
            return;
        }
        String utcOffsetString = this.parameters[0];
        utcOffsetString = utcOffsetString.length() == 2 && (utcOffsetString.contains("+") || utcOffsetString.contains("-")) ? utcOffsetString.substring(0, 1) + "0" + utcOffsetString.substring(1, utcOffsetString.length()) + "00" : (utcOffsetString.length() == 1 ? "+0" + utcOffsetString + "00" : (utcOffsetString.startsWith("10") || utcOffsetString.startsWith("11") || utcOffsetString.startsWith("12") ? "+" + utcOffsetString + "00" : utcOffsetString + "00"));
        System.arraycopy(utcOffsetString.getBytes(), 0, ntpData, 1, 5);
        ntpData[0] = 1;
        try {
            ipmiOEMWebSettingCommand.setNTPDateTime((byte)0, ntpData);
        }
        catch (IPMIException ex2) {
            MOut.G(this).println("Set NTP Date and Time failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }

    public void printNTPServerList() {
        try {
            String ntp1 = this.ipmiCMMOEMCommand.getNTPServerPrimary();
            String ntp2 = this.ipmiCMMOEMCommand.getNTPServerSecondary();
            MOut.G(this).println("Primary NTP Server   :" + ntp1);
            MOut.G(this).println("Secondary NTP Server :" + ntp2);
            String usage = "\nUsage: ntp <UTC Offset> <NTP1> [NTP2]\nUTC Offset: -11 to +12\nNTP1: domain name or IP of Primary NTP server\nNTP2: domain name or IP of Secondary NTP server";
            MOut.G(this).println(usage);
        }
        catch (IPMIException ex) {
            MOut.G(this).println("Command is not available");
        }
    }
}

