/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.text.IPMISensorDisplay;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;
import java.util.HashMap;

public class IPMISensorCommand
extends SuperBladeCommand {
    String formatTemplate = "  %-6s | %-24s | %12s | %9s | %10s |\n";
    String formatTemplateThreshold = "  %-6s | %6s | %8s | %-24s | %12s | %8s | %8s | %9s | %9s |\n";
    HashMap ipToSDRs = new HashMap();
    boolean showThreshold;

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            this.showThreshold = false;
            return true;
        }
        if (this.parameters[0].equals("--full")) {
            this.showThreshold = true;
            return true;
        }
        MOut.G(this).println("Parameter error!");
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMISensorDisplay ipmiDisplay = new IPMISensorDisplay(this.ipmiCMMOEMCommand.getIPMIInterface());
        ArrayList sdrList = null;
        boolean hasSensorData = false;
        MOut.G(this).println("Getting SDR records ...");
        if (this.showThreshold) {
            if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
                this.formatTemplateThreshold = "  %-6s | %6s | %8s | %8s | %-24s | %12s | %8s | %8s | %9s | %9s |\n";
                MOut.G(this).print(String.format(this.formatTemplateThreshold, "Status", "ID", "Num(Hex)", "Duty", "Sensor", "Reading", " Low NR ", " Low CT ", " High CT ", " High NR "));
                MOut.G(this).print(String.format(this.formatTemplateThreshold, "------", "--", "--------", "----", "---------", "-------", "--------", "--------", "---------", "---------"));
            } else {
                MOut.G(this).print(String.format(this.formatTemplateThreshold, "Status", "ID", "Num(Hex)", "Sensor", "Reading", " Low NR ", " Low CT ", " High CT ", " High NR "));
                MOut.G(this).print(String.format(this.formatTemplateThreshold, "------", "--", "--------", "---------", "-------", "--------", "--------", "---------", "---------"));
            }
        } else {
            MOut.G(this).print(String.format(this.formatTemplate, "Status", "(#)Sensor", "Reading", "Low Limit", "High Limit"));
            MOut.G(this).print(String.format(this.formatTemplate, "------", "---------", "-------", "---------", "----------"));
        }
        if (this.ipToSDRs.get(this.config.getIp()) == null) {
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            if (sdrInfo == null) {
                MOut.G(this).println("Get SDR Repository error");
                this.statusCode = 149;
                return;
            }
            try {
                sdrList = ipmiSDRCommand.getSDRbyLine(sdrInfo.getRecordCount(), this.showThreshold);
                hasSensorData = true;
            }
            catch (IPMIException iPMIException) {
            }
            catch (Exception e) {
                MOut.G(this).println("Get SDR failed:" + e.getMessage());
                this.statusCode = 149;
                return;
            }
            this.ipToSDRs.put(this.config.getIp(), sdrList);
        } else {
            sdrList = (ArrayList)this.ipToSDRs.get(this.config.getIp());
            for (SDRRecord item : sdrList) {
                try {
                    hasSensorData = ipmiDisplay.print(item, this.showThreshold);
                }
                catch (IPMIException iPMIException) {}
            }
        }
        if (GlobalDefine.THERMAL_TEAM_SCRIPT && this.showThreshold) {
            byte[] PWMdata = ipmiSDRCommand.getPWMDutyCycle();
            for (int i = 0; i < PWMdata.length; ++i) {
                MOut.G(this).print(String.format(this.formatTemplateThreshold, "", "", "", PWMdata[i], "PWM " + (i + 1), "", "N/A", "N/A", "N/A", "N/A"));
            }
        }
        if (!hasSensorData) {
            MOut.G(this).println("no sensor data");
        }
        this.statusCode = 0;
    }
}

