/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.MDRRegionReadCommand;
import com.supermicro.ipmi.MDRRegionStatusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import java.io.FileWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmbiosDumpToFileCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Filename is needed");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        MDRRegionStatusCommand mdrStatus = new MDRRegionStatusCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte completionCode = (mdrStatus = mdrStatus.getMDRRegionStatus()).getCompletionCode();
        if (completionCode != 0) {
            MOut.G(this).println("Not supported (0x" + ByteUtility.byteToHex(completionCode) + ")");
            this.statusCode = 0;
            return;
        }
        byte valid = mdrStatus.getValid();
        if (valid != 1) {
            MOut.G(this).println("Invalid data (0x" + ByteUtility.byteToHex(valid) + ")");
            this.statusCode = 0;
            return;
        }
        byte[] dataByte = this.getData(mdrStatus);
        String dataHex = ByteUtility.bytesToHex(dataByte);
        Pattern pattern = Pattern.compile("(.{48})", 32);
        Matcher matcher = pattern.matcher(dataHex);
        String newStr = matcher.replaceAll("$1\n");
        if (dataByte != null) {
            try {
                File file = new File(this.parameters[0]);
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(newStr);
                fileWriter.close();
            }
            catch (Exception e) {
                MOut.G(this).println("Dump SMBIOS data failed");
                this.statusCode = 149;
            }
            MOut.G(this).println("Dump SMBIOS data successfully");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Dump SMBIOS data failed");
            this.statusCode = 149;
        }
    }

    byte[] MDRRegionRead(int dataLength, byte[] offset) {
        MDRRegionReadCommand mdrRead = new MDRRegionReadCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        mdrRead = mdrRead.getMDRRegionRead(dataLength, offset);
        return mdrRead.getDataByte();
    }

    byte[] getData(MDRRegionStatusCommand mdrStatus) {
        byte[] fullData = new byte[]{};
        byte[] offset = new byte[2];
        int divide = mdrStatus.getUsedRegionSize() / 255;
        int remainder = Integer.parseInt(Integer.toHexString(mdrStatus.getUsedRegionSize() % 255), 16) & 0xFF;
        int count = 0;
        for (int i = 0; i < mdrStatus.getUsedRegionSize(); i += 255) {
            byte[] destination;
            byte[] postByte;
            if (count == divide) {
                ByteUtility.intTo2Bytes(offset, 0, i);
                postByte = this.MDRRegionRead(remainder, offset);
                destination = new byte[fullData.length + remainder];
                System.arraycopy(fullData, 0, destination, 0, fullData.length);
                System.arraycopy(postByte, 0, destination, fullData.length, postByte.length);
                fullData = destination;
                break;
            }
            ByteUtility.intTo2Bytes(offset, 0, i);
            postByte = this.MDRRegionRead(-1, offset);
            destination = new byte[fullData.length + 255];
            System.arraycopy(fullData, 0, destination, 0, fullData.length);
            System.arraycopy(postByte, 0, destination, fullData.length, postByte.length);
            fullData = destination;
            ++count;
        }
        return fullData;
    }
}

