/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;

public class NMPowerUsage {
    private IPMINM20Command ipmiCommand;

    public NMPowerUsage(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
    }

    public PowerUsage getPowerUsage() throws IPMIException {
        int sys = this.getSystemPower();
        int cpu = this.getCPUPower();
        int mem = this.getMemoryPower();
        return new PowerUsage(sys, cpu, mem);
    }

    private int getSystemPower() throws IPMIException {
        IPMINM20Command.NodeManagerStatistics statistics = this.ipmiCommand.getNodeManagerStatistics((byte)1, (byte)0, (byte)0);
        int power = ByteUtility.twoBytesToInt(statistics.current);
        return power;
    }

    private int getCPUPower() throws IPMIException {
        IPMINM20Command.NodeManagerStatistics statistics = this.ipmiCommand.getNodeManagerStatistics((byte)1, (byte)1, (byte)0);
        return ByteUtility.twoBytesToInt(statistics.current);
    }

    private int getMemoryPower() throws IPMIException {
        IPMINM20Command.NodeManagerStatistics statistics = this.ipmiCommand.getNodeManagerStatistics((byte)1, (byte)2, (byte)0);
        return ByteUtility.twoBytesToInt(statistics.current);
    }

    public class PowerUsage {
        public final int sys;
        public final int cpu;
        public final int mem;

        public PowerUsage(int sys, int cpu, int mem) {
            this.sys = sys;
            this.mem = mem;
            this.cpu = cpu;
        }
    }
}

