/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.lang.ref.Reference;

public class BeanDescriptor
extends FeatureDescriptor {
    private Reference<? extends Class<?>> beanClassRef;
    private Reference<? extends Class<?>> customizerClassRef;

    public BeanDescriptor(Class<?> beanClass) {
        this(beanClass, null);
    }

    public BeanDescriptor(Class<?> beanClass, Class<?> customizerClass) {
        this.beanClassRef = BeanDescriptor.getWeakReference(beanClass);
        this.customizerClassRef = BeanDescriptor.getWeakReference(customizerClass);
        String name = beanClass.getName();
        while (name.indexOf(46) >= 0) {
            name = name.substring(name.indexOf(46) + 1);
        }
        this.setName(name);
    }

    public Class<?> getBeanClass() {
        return this.beanClassRef != null ? this.beanClassRef.get() : null;
    }

    public Class<?> getCustomizerClass() {
        return this.customizerClassRef != null ? this.customizerClassRef.get() : null;
    }

    BeanDescriptor(BeanDescriptor old) {
        super(old);
        this.beanClassRef = old.beanClassRef;
        this.customizerClassRef = old.customizerClassRef;
    }

    @Override
    void appendTo(StringBuilder sb) {
        BeanDescriptor.appendTo(sb, "beanClass", this.beanClassRef);
        BeanDescriptor.appendTo(sb, "customizerClass", this.customizerClassRef);
    }
}

