/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml.impl;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import jdk.internal.util.xml.XMLStreamException;
import jdk.internal.util.xml.XMLStreamWriter;
import jdk.internal.util.xml.impl.XMLWriter;

public class XMLStreamWriterImpl
implements XMLStreamWriter {
    static final int STATE_XML_DECL = 1;
    static final int STATE_PROLOG = 2;
    static final int STATE_DTD_DECL = 3;
    static final int STATE_ELEMENT = 4;
    static final int ELEMENT_STARTTAG_OPEN = 10;
    static final int ELEMENT_STARTTAG_CLOSE = 11;
    static final int ELEMENT_ENDTAG_OPEN = 12;
    static final int ELEMENT_ENDTAG_CLOSE = 13;
    public static final char CLOSE_START_TAG = '>';
    public static final char OPEN_START_TAG = '<';
    public static final String OPEN_END_TAG = "</";
    public static final char CLOSE_END_TAG = '>';
    public static final String START_CDATA = "<![CDATA[";
    public static final String END_CDATA = "]]>";
    public static final String CLOSE_EMPTY_ELEMENT = "/>";
    public static final String ENCODING_PREFIX = "&#x";
    public static final char SPACE = ' ';
    public static final char AMPERSAND = '&';
    public static final char DOUBLEQUOT = '\"';
    public static final char SEMICOLON = ';';
    private int _state = 0;
    private Element _currentEle;
    private XMLWriter _writer;
    private String _encoding;
    boolean _escapeCharacters = true;
    private boolean _doIndent = true;
    private char[] _lineSep = System.getProperty("line.separator").toCharArray();

    public XMLStreamWriterImpl(OutputStream os) throws XMLStreamException {
        this(os, "UTF-8");
    }

    public XMLStreamWriterImpl(OutputStream os, String encoding) throws XMLStreamException {
        Charset cs = null;
        if (encoding == null) {
            this._encoding = "UTF-8";
        } else {
            try {
                cs = this.getCharset(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new XMLStreamException(e);
            }
            this._encoding = encoding;
        }
        this._writer = new XMLWriter(os, encoding, cs);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(this._encoding, "1.0");
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(this._encoding, version, null);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writeStartDocument(encoding, version, null);
    }

    public void writeStartDocument(String encoding, String version, String standalone) throws XMLStreamException {
        if (this._state > 0) {
            throw new XMLStreamException("XML declaration must be as the first line in the XML document.");
        }
        this._state = 1;
        String enc = encoding;
        if (enc == null) {
            enc = this._encoding;
        } else {
            try {
                this.getCharset(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new XMLStreamException(e);
            }
        }
        if (version == null) {
            version = "1.0";
        }
        this._writer.write("<?xml version=\"");
        this._writer.write(version);
        this._writer.write(34);
        if (enc != null) {
            this._writer.write(" encoding=\"");
            this._writer.write(enc);
            this._writer.write(34);
        }
        if (standalone != null) {
            this._writer.write(" standalone=\"");
            this._writer.write(standalone);
            this._writer.write(34);
        }
        this._writer.write("?>");
        this.writeLineSeparator();
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this._writer.write(dtd);
        this.writeLineSeparator();
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        if (localName == null || localName.length() == 0) {
            throw new XMLStreamException("Local Name cannot be null or empty");
        }
        this._state = 4;
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this._currentEle = new Element(this._currentEle, localName, false);
        this.openStartTag();
        this._writer.write(localName);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this._currentEle = new Element(this._currentEle, localName, true);
        this.openStartTag();
        this._writer.write(localName);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (this._currentEle.getState() != 10) {
            throw new XMLStreamException("Attribute not associated with any element");
        }
        this._writer.write(32);
        this._writer.write(localName);
        this._writer.write("=\"");
        this.writeXMLContent(value, true, true);
        this._writer.write(34);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        while (this._currentEle != null) {
            if (!this._currentEle.isEmpty()) {
                this._writer.write(OPEN_END_TAG);
                this._writer.write(this._currentEle.getLocalName());
                this._writer.write(62);
            }
            this._currentEle = this._currentEle.getParent();
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        if (this._currentEle == null) {
            throw new XMLStreamException("No element was found to write");
        }
        if (this._currentEle.isEmpty()) {
            return;
        }
        this._writer.write(OPEN_END_TAG);
        this._writer.write(this._currentEle.getLocalName());
        this._writer.write(62);
        this.writeLineSeparator();
        this._currentEle = this._currentEle.getParent();
    }

    @Override
    public void writeCData(String cdata) throws XMLStreamException {
        if (cdata == null) {
            throw new XMLStreamException("cdata cannot be null");
        }
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this._writer.write(START_CDATA);
        this._writer.write(cdata);
        this._writer.write(END_CDATA);
    }

    @Override
    public void writeCharacters(String data) throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this.writeXMLContent(data);
    }

    @Override
    public void writeCharacters(char[] data, int start, int len) throws XMLStreamException {
        if (this._currentEle != null && this._currentEle.getState() == 10) {
            this.closeStartTag();
        }
        this.writeXMLContent(data, start, len, this._escapeCharacters);
    }

    @Override
    public void close() throws XMLStreamException {
        if (this._writer != null) {
            this._writer.close();
        }
        this._writer = null;
        this._currentEle = null;
        this._state = 0;
    }

    @Override
    public void flush() throws XMLStreamException {
        if (this._writer != null) {
            this._writer.flush();
        }
    }

    public void setDoIndent(boolean doIndent) {
        this._doIndent = doIndent;
    }

    private void writeXMLContent(char[] content, int start, int length, boolean escapeChars) throws XMLStreamException {
        if (!escapeChars) {
            this._writer.write(content, start, length);
            return;
        }
        int startWritePos = start;
        int end = start + length;
        block5: for (int index = start; index < end; ++index) {
            char ch = content[index];
            if (!this._writer.canEncode(ch)) {
                this._writer.write(content, startWritePos, index - startWritePos);
                this._writer.write(ENCODING_PREFIX);
                this._writer.write(Integer.toHexString(ch));
                this._writer.write(59);
                startWritePos = index + 1;
                continue;
            }
            switch (ch) {
                case '<': {
                    this._writer.write(content, startWritePos, index - startWritePos);
                    this._writer.write("&lt;");
                    startWritePos = index + 1;
                    continue block5;
                }
                case '&': {
                    this._writer.write(content, startWritePos, index - startWritePos);
                    this._writer.write("&amp;");
                    startWritePos = index + 1;
                    continue block5;
                }
                case '>': {
                    this._writer.write(content, startWritePos, index - startWritePos);
                    this._writer.write("&gt;");
                    startWritePos = index + 1;
                }
            }
        }
        this._writer.write(content, startWritePos, end - startWritePos);
    }

    private void writeXMLContent(String content) throws XMLStreamException {
        if (content != null && content.length() > 0) {
            this.writeXMLContent(content, this._escapeCharacters, false);
        }
    }

    private void writeXMLContent(String content, boolean escapeChars, boolean escapeDoubleQuotes) throws XMLStreamException {
        if (!escapeChars) {
            this._writer.write(content);
            return;
        }
        int startWritePos = 0;
        int end = content.length();
        block6: for (int index = 0; index < end; ++index) {
            char ch = content.charAt(index);
            if (!this._writer.canEncode(ch)) {
                this._writer.write(content, startWritePos, index - startWritePos);
                this._writer.write(ENCODING_PREFIX);
                this._writer.write(Integer.toHexString(ch));
                this._writer.write(59);
                startWritePos = index + 1;
                continue;
            }
            switch (ch) {
                case '<': {
                    this._writer.write(content, startWritePos, index - startWritePos);
                    this._writer.write("&lt;");
                    startWritePos = index + 1;
                    continue block6;
                }
                case '&': {
                    this._writer.write(content, startWritePos, index - startWritePos);
                    this._writer.write("&amp;");
                    startWritePos = index + 1;
                    continue block6;
                }
                case '>': {
                    this._writer.write(content, startWritePos, index - startWritePos);
                    this._writer.write("&gt;");
                    startWritePos = index + 1;
                    continue block6;
                }
                case '\"': {
                    this._writer.write(content, startWritePos, index - startWritePos);
                    if (escapeDoubleQuotes) {
                        this._writer.write("&quot;");
                    } else {
                        this._writer.write(34);
                    }
                    startWritePos = index + 1;
                }
            }
        }
        this._writer.write(content, startWritePos, end - startWritePos);
    }

    private void openStartTag() throws XMLStreamException {
        this._currentEle.setState(10);
        this._writer.write(60);
    }

    private void closeStartTag() throws XMLStreamException {
        if (this._currentEle.isEmpty()) {
            this._writer.write(CLOSE_EMPTY_ELEMENT);
        } else {
            this._writer.write(62);
        }
        if (this._currentEle.getParent() == null) {
            this.writeLineSeparator();
        }
        this._currentEle.setState(11);
    }

    private void writeLineSeparator() throws XMLStreamException {
        if (this._doIndent) {
            this._writer.write(this._lineSep, 0, this._lineSep.length);
        }
    }

    private Charset getCharset(String encoding) throws UnsupportedEncodingException {
        Charset cs;
        if (encoding.equalsIgnoreCase("UTF-32")) {
            throw new UnsupportedEncodingException("The basic XMLWriter does not support " + encoding);
        }
        try {
            cs = Charset.forName(encoding);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
            throw new UnsupportedEncodingException(encoding);
        }
        return cs;
    }

    protected class Element {
        protected Element _parent;
        protected short _Depth;
        boolean _isEmptyElement = false;
        String _localpart;
        int _state;

        public Element() {
        }

        public Element(Element parent, String localpart, boolean isEmpty) {
            this._parent = parent;
            this._localpart = localpart;
            this._isEmptyElement = isEmpty;
        }

        public Element getParent() {
            return this._parent;
        }

        public String getLocalName() {
            return this._localpart;
        }

        public int getState() {
            return this._state;
        }

        public void setState(int state) {
            this._state = state;
        }

        public boolean isEmpty() {
            return this._isEmptyElement;
        }
    }
}

