/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import jdk.net.NetworkPermission;
import jdk.net.SocketFlow;
import sun.net.ExtendedOptionsImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.OptionKey;
import sun.nio.ch.SocketOptionRegistry;

public class Net {
    static final ProtocolFamily UNSPEC;
    private static final boolean exclusiveBind;
    private static final boolean fastLoopback;
    private static volatile boolean checkedIPv6;
    private static volatile boolean isIPv6Available;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;
    public static final short POLLIN;
    public static final short POLLOUT;
    public static final short POLLERR;
    public static final short POLLHUP;
    public static final short POLLNVAL;
    public static final short POLLCONN;

    private Net() {
    }

    static boolean isIPv6Available() {
        if (!checkedIPv6) {
            isIPv6Available = Net.isIPv6Available0();
            checkedIPv6 = true;
        }
        return isIPv6Available;
    }

    static boolean useExclusiveBind() {
        return exclusiveBind;
    }

    static boolean canIPv6SocketJoinIPv4Group() {
        return Net.canIPv6SocketJoinIPv4Group0();
    }

    static boolean canJoin6WithIPv4Group() {
        return Net.canJoin6WithIPv4Group0();
    }

    public static InetSocketAddress checkAddress(SocketAddress sa) {
        if (sa == null) {
            throw new NullPointerException();
        }
        if (!(sa instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress isa = (InetSocketAddress)sa;
        if (isa.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        InetAddress addr = isa.getAddress();
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException("Invalid address type");
        }
        return isa;
    }

    static InetSocketAddress asInetSocketAddress(SocketAddress sa) {
        if (!(sa instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        return (InetSocketAddress)sa;
    }

    static void translateToSocketException(Exception x) throws SocketException {
        if (x instanceof SocketException) {
            throw (SocketException)x;
        }
        Exception nx = x;
        if (x instanceof ClosedChannelException) {
            nx = new SocketException("Socket is closed");
        } else if (x instanceof NotYetConnectedException) {
            nx = new SocketException("Socket is not connected");
        } else if (x instanceof AlreadyBoundException) {
            nx = new SocketException("Already bound");
        } else if (x instanceof NotYetBoundException) {
            nx = new SocketException("Socket is not bound yet");
        } else if (x instanceof UnsupportedAddressTypeException) {
            nx = new SocketException("Unsupported address type");
        } else if (x instanceof UnresolvedAddressException) {
            nx = new SocketException("Unresolved address");
        }
        if (nx != x) {
            nx.initCause(x);
        }
        if (nx instanceof SocketException) {
            throw (SocketException)nx;
        }
        if (nx instanceof RuntimeException) {
            throw (RuntimeException)nx;
        }
        throw new Error("Untranslated exception", nx);
    }

    static void translateException(Exception x, boolean unknownHostForUnresolved) throws IOException {
        if (x instanceof IOException) {
            throw (IOException)x;
        }
        if (unknownHostForUnresolved && x instanceof UnresolvedAddressException) {
            throw new UnknownHostException();
        }
        Net.translateToSocketException(x);
    }

    static void translateException(Exception x) throws IOException {
        Net.translateException(x, false);
    }

    static InetSocketAddress getRevealedLocalAddress(InetSocketAddress addr) {
        SecurityManager sm = System.getSecurityManager();
        if (addr == null || sm == null) {
            return addr;
        }
        try {
            sm.checkConnect(addr.getAddress().getHostAddress(), -1);
        }
        catch (SecurityException e) {
            addr = Net.getLoopbackAddress(addr.getPort());
        }
        return addr;
    }

    static String getRevealedLocalAddressAsString(InetSocketAddress addr) {
        return System.getSecurityManager() == null ? addr.toString() : Net.getLoopbackAddress(addr.getPort()).toString();
    }

    private static InetSocketAddress getLoopbackAddress(int port) {
        return new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
    }

    static Inet4Address anyInet4Address(final NetworkInterface interf) {
        return AccessController.doPrivileged(new PrivilegedAction<Inet4Address>(){

            @Override
            public Inet4Address run() {
                Enumeration<InetAddress> addrs = interf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!(addr instanceof Inet4Address)) continue;
                    return (Inet4Address)addr;
                }
                return null;
            }
        });
    }

    static int inet4AsInt(InetAddress ia) {
        if (ia instanceof Inet4Address) {
            byte[] addr = ia.getAddress();
            int address = addr[3] & 0xFF;
            address |= addr[2] << 8 & 0xFF00;
            address |= addr[1] << 16 & 0xFF0000;
            return address |= addr[0] << 24 & 0xFF000000;
        }
        throw new AssertionError((Object)"Should not reach here");
    }

    static InetAddress inet4FromInt(int address) {
        byte[] addr = new byte[]{(byte)(address >>> 24 & 0xFF), (byte)(address >>> 16 & 0xFF), (byte)(address >>> 8 & 0xFF), (byte)(address & 0xFF)};
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException uhe) {
            throw new AssertionError((Object)"Should not reach here");
        }
    }

    static byte[] inet6AsByteArray(InetAddress ia) {
        if (ia instanceof Inet6Address) {
            return ia.getAddress();
        }
        if (ia instanceof Inet4Address) {
            byte[] ip4address = ia.getAddress();
            byte[] address = new byte[16];
            address[10] = -1;
            address[11] = -1;
            address[12] = ip4address[0];
            address[13] = ip4address[1];
            address[14] = ip4address[2];
            address[15] = ip4address[3];
            return address;
        }
        throw new AssertionError((Object)"Should not reach here");
    }

    static void setSocketOption(FileDescriptor fd, ProtocolFamily family, SocketOption<?> name, Object value) throws IOException {
        boolean b;
        int i;
        if (value == null) {
            throw new IllegalArgumentException("Invalid option value");
        }
        Class<?> type = name.type();
        if (type == SocketFlow.class) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new NetworkPermission("setOption.SO_FLOW_SLA"));
            }
            ExtendedOptionsImpl.setFlowOption(fd, (SocketFlow)value);
            return;
        }
        if (type != Integer.class && type != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        if ((name == StandardSocketOptions.SO_RCVBUF || name == StandardSocketOptions.SO_SNDBUF) && (i = ((Integer)value).intValue()) < 0) {
            throw new IllegalArgumentException("Invalid send/receive buffer size");
        }
        if (name == StandardSocketOptions.SO_LINGER) {
            i = (Integer)value;
            if (i < 0) {
                value = -1;
            }
            if (i > 65535) {
                value = 65535;
            }
        }
        if (name == StandardSocketOptions.IP_TOS && ((i = ((Integer)value).intValue()) < 0 || i > 255)) {
            throw new IllegalArgumentException("Invalid IP_TOS value");
        }
        if (name == StandardSocketOptions.IP_MULTICAST_TTL && ((i = ((Integer)value).intValue()) < 0 || i > 255)) {
            throw new IllegalArgumentException("Invalid TTL/hop value");
        }
        OptionKey key = SocketOptionRegistry.findOption(name, family);
        if (key == null) {
            throw new AssertionError((Object)"Option not found");
        }
        int arg = type == Integer.class ? (Integer)value : ((b = ((Boolean)value).booleanValue()) ? 1 : 0);
        boolean mayNeedConversion = family == UNSPEC;
        boolean isIPv6 = family == StandardProtocolFamily.INET6;
        Net.setIntOption0(fd, mayNeedConversion, key.level(), key.name(), arg, isIPv6);
    }

    static Object getSocketOption(FileDescriptor fd, ProtocolFamily family, SocketOption<?> name) throws IOException {
        Class<?> type = name.type();
        if (type == SocketFlow.class) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new NetworkPermission("getOption.SO_FLOW_SLA"));
            }
            SocketFlow flow = SocketFlow.create();
            ExtendedOptionsImpl.getFlowOption(fd, flow);
            return flow;
        }
        if (type != Integer.class && type != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        OptionKey key = SocketOptionRegistry.findOption(name, family);
        if (key == null) {
            throw new AssertionError((Object)"Option not found");
        }
        boolean mayNeedConversion = family == UNSPEC;
        int value = Net.getIntOption0(fd, mayNeedConversion, key.level(), key.name());
        if (type == Integer.class) {
            return value;
        }
        return value == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isFastTcpLoopbackRequested() {
        String loopbackProp = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("jdk.net.useFastTcpLoopback");
            }
        });
        boolean enable = "".equals(loopbackProp) ? true : Boolean.parseBoolean(loopbackProp);
        return enable;
    }

    private static native boolean isIPv6Available0();

    private static native int isExclusiveBindAvailable();

    private static native boolean canIPv6SocketJoinIPv4Group0();

    private static native boolean canJoin6WithIPv4Group0();

    static FileDescriptor socket(boolean stream) throws IOException {
        return Net.socket(UNSPEC, stream);
    }

    static FileDescriptor socket(ProtocolFamily family, boolean stream) throws IOException {
        boolean preferIPv6 = Net.isIPv6Available() && family != StandardProtocolFamily.INET;
        return IOUtil.newFD(Net.socket0(preferIPv6, stream, false, fastLoopback));
    }

    static FileDescriptor serverSocket(boolean stream) {
        return IOUtil.newFD(Net.socket0(Net.isIPv6Available(), stream, true, fastLoopback));
    }

    private static native int socket0(boolean var0, boolean var1, boolean var2, boolean var3);

    public static void bind(FileDescriptor fd, InetAddress addr, int port) throws IOException {
        Net.bind(UNSPEC, fd, addr, port);
    }

    static void bind(ProtocolFamily family, FileDescriptor fd, InetAddress addr, int port) throws IOException {
        boolean preferIPv6 = Net.isIPv6Available() && family != StandardProtocolFamily.INET;
        Net.bind0(fd, preferIPv6, exclusiveBind, addr, port);
    }

    private static native void bind0(FileDescriptor var0, boolean var1, boolean var2, InetAddress var3, int var4) throws IOException;

    static native void listen(FileDescriptor var0, int var1) throws IOException;

    static int connect(FileDescriptor fd, InetAddress remote, int remotePort) throws IOException {
        return Net.connect(UNSPEC, fd, remote, remotePort);
    }

    static int connect(ProtocolFamily family, FileDescriptor fd, InetAddress remote, int remotePort) throws IOException {
        boolean preferIPv6 = Net.isIPv6Available() && family != StandardProtocolFamily.INET;
        return Net.connect0(preferIPv6, fd, remote, remotePort);
    }

    private static native int connect0(boolean var0, FileDescriptor var1, InetAddress var2, int var3) throws IOException;

    static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    private static native int localPort(FileDescriptor var0) throws IOException;

    private static native InetAddress localInetAddress(FileDescriptor var0) throws IOException;

    public static InetSocketAddress localAddress(FileDescriptor fd) throws IOException {
        return new InetSocketAddress(Net.localInetAddress(fd), Net.localPort(fd));
    }

    private static native int remotePort(FileDescriptor var0) throws IOException;

    private static native InetAddress remoteInetAddress(FileDescriptor var0) throws IOException;

    static InetSocketAddress remoteAddress(FileDescriptor fd) throws IOException {
        return new InetSocketAddress(Net.remoteInetAddress(fd), Net.remotePort(fd));
    }

    private static native int getIntOption0(FileDescriptor var0, boolean var1, int var2, int var3) throws IOException;

    private static native void setIntOption0(FileDescriptor var0, boolean var1, int var2, int var3, int var4, boolean var5) throws IOException;

    static native int poll(FileDescriptor var0, int var1, long var2) throws IOException;

    static int join4(FileDescriptor fd, int group, int interf, int source) throws IOException {
        return Net.joinOrDrop4(true, fd, group, interf, source);
    }

    static void drop4(FileDescriptor fd, int group, int interf, int source) throws IOException {
        Net.joinOrDrop4(false, fd, group, interf, source);
    }

    private static native int joinOrDrop4(boolean var0, FileDescriptor var1, int var2, int var3, int var4) throws IOException;

    static int block4(FileDescriptor fd, int group, int interf, int source) throws IOException {
        return Net.blockOrUnblock4(true, fd, group, interf, source);
    }

    static void unblock4(FileDescriptor fd, int group, int interf, int source) throws IOException {
        Net.blockOrUnblock4(false, fd, group, interf, source);
    }

    private static native int blockOrUnblock4(boolean var0, FileDescriptor var1, int var2, int var3, int var4) throws IOException;

    static int join6(FileDescriptor fd, byte[] group, int index, byte[] source) throws IOException {
        return Net.joinOrDrop6(true, fd, group, index, source);
    }

    static void drop6(FileDescriptor fd, byte[] group, int index, byte[] source) throws IOException {
        Net.joinOrDrop6(false, fd, group, index, source);
    }

    private static native int joinOrDrop6(boolean var0, FileDescriptor var1, byte[] var2, int var3, byte[] var4) throws IOException;

    static int block6(FileDescriptor fd, byte[] group, int index, byte[] source) throws IOException {
        return Net.blockOrUnblock6(true, fd, group, index, source);
    }

    static void unblock6(FileDescriptor fd, byte[] group, int index, byte[] source) throws IOException {
        Net.blockOrUnblock6(false, fd, group, index, source);
    }

    static native int blockOrUnblock6(boolean var0, FileDescriptor var1, byte[] var2, int var3, byte[] var4) throws IOException;

    static native void setInterface4(FileDescriptor var0, int var1) throws IOException;

    static native int getInterface4(FileDescriptor var0) throws IOException;

    static native void setInterface6(FileDescriptor var0, int var1) throws IOException;

    static native int getInterface6(FileDescriptor var0) throws IOException;

    private static native void initIDs();

    static native short pollinValue();

    static native short polloutValue();

    static native short pollerrValue();

    static native short pollhupValue();

    static native short pollnvalValue();

    static native short pollconnValue();

    static {
        String exclBindProp;
        UNSPEC = new ProtocolFamily(){

            @Override
            public String name() {
                return "UNSPEC";
            }
        };
        checkedIPv6 = false;
        IOUtil.load();
        Net.initIDs();
        POLLIN = Net.pollinValue();
        POLLOUT = Net.polloutValue();
        POLLERR = Net.pollerrValue();
        POLLHUP = Net.pollhupValue();
        POLLNVAL = Net.pollnvalValue();
        POLLCONN = Net.pollconnValue();
        int availLevel = Net.isExclusiveBindAvailable();
        exclusiveBind = availLevel >= 0 ? ((exclBindProp = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.net.useExclusiveBind");
            }
        })) != null ? (exclBindProp.length() == 0 ? true : Boolean.parseBoolean(exclBindProp)) : availLevel == 1) : false;
        fastLoopback = Net.isFastTcpLoopbackRequested();
    }
}

