/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;

class WindowsSecurity {
    static final long processTokenWithDuplicateAccess = WindowsSecurity.openProcessToken(2);
    static final long processTokenWithQueryAccess = WindowsSecurity.openProcessToken(8);

    private WindowsSecurity() {
    }

    private static long openProcessToken(int access) {
        try {
            return WindowsNativeDispatcher.OpenProcessToken(WindowsNativeDispatcher.GetCurrentProcess(), access);
        }
        catch (WindowsException x) {
            return 0L;
        }
    }

    static Privilege enablePrivilege(String priv) {
        long pLuid;
        try {
            pLuid = WindowsNativeDispatcher.LookupPrivilegeValue(priv);
        }
        catch (WindowsException x) {
            throw new AssertionError((Object)x);
        }
        long hToken = 0L;
        boolean impersontating = false;
        boolean elevated = false;
        try {
            hToken = WindowsNativeDispatcher.OpenThreadToken(WindowsNativeDispatcher.GetCurrentThread(), 32, false);
            if (hToken == 0L && processTokenWithDuplicateAccess != 0L) {
                hToken = WindowsNativeDispatcher.DuplicateTokenEx(processTokenWithDuplicateAccess, 36);
                WindowsNativeDispatcher.SetThreadToken(0L, hToken);
                impersontating = true;
            }
            if (hToken != 0L) {
                WindowsNativeDispatcher.AdjustTokenPrivileges(hToken, pLuid, 2);
                elevated = true;
            }
        }
        catch (WindowsException windowsException) {
            // empty catch block
        }
        final long token = hToken;
        final boolean stopImpersontating = impersontating;
        final boolean needToRevert = elevated;
        return new Privilege(){

            @Override
            public void drop() {
                if (token != 0L) {
                    try {
                        if (stopImpersontating) {
                            WindowsNativeDispatcher.SetThreadToken(0L, 0L);
                        } else if (needToRevert) {
                            WindowsNativeDispatcher.AdjustTokenPrivileges(token, pLuid, 0);
                        }
                    }
                    catch (WindowsException x) {
                        throw new AssertionError((Object)x);
                    }
                    finally {
                        WindowsNativeDispatcher.CloseHandle(token);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkAccessMask(long securityInfo, int accessMask, int genericRead, int genericWrite, int genericExecute, int genericAll) throws WindowsException {
        int privilegies = 8;
        long hToken = WindowsNativeDispatcher.OpenThreadToken(WindowsNativeDispatcher.GetCurrentThread(), privilegies, false);
        if (hToken == 0L && processTokenWithDuplicateAccess != 0L) {
            hToken = WindowsNativeDispatcher.DuplicateTokenEx(processTokenWithDuplicateAccess, privilegies);
        }
        boolean hasRight = false;
        if (hToken != 0L) {
            try {
                hasRight = WindowsNativeDispatcher.AccessCheck(hToken, securityInfo, accessMask, genericRead, genericWrite, genericExecute, genericAll);
            }
            finally {
                WindowsNativeDispatcher.CloseHandle(hToken);
            }
        }
        return hasRight;
    }

    static interface Privilege {
        public void drop();
    }
}

