/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class DeviceInfo {
    public byte deviceID;
    public byte deviceRevision;
    public byte firmwareRevision1;
    public byte firmwareRevision2;
    public byte IPMIVersion;
    public byte additionalDeviceSupport;
    public byte[] manufacturerID;
    public byte[] productID;
    public byte[] auxiliaryFirmwareRevisionInfo;
    public byte[] raw;

    public static DeviceInfo fromRaw(byte[] raw) {
        if (raw.length < 11) {
            return null;
        }
        DeviceInfo deviceInfo = new DeviceInfo();
        int index = 0;
        deviceInfo.deviceID = raw[index];
        deviceInfo.deviceRevision = raw[++index];
        deviceInfo.firmwareRevision1 = raw[++index];
        deviceInfo.firmwareRevision2 = raw[++index];
        deviceInfo.IPMIVersion = raw[++index];
        deviceInfo.additionalDeviceSupport = raw[++index];
        deviceInfo.manufacturerID = new byte[3];
        deviceInfo.productID = new byte[3];
        deviceInfo.auxiliaryFirmwareRevisionInfo = new byte[4];
        System.arraycopy(raw, ++index, deviceInfo.manufacturerID, 0, 3);
        System.arraycopy(raw, index += 3, deviceInfo.productID, 0, 2);
        index += 2;
        if (raw.length == 15) {
            System.arraycopy(raw, index, deviceInfo.auxiliaryFirmwareRevisionInfo, 0, 4);
        }
        deviceInfo.raw = raw;
        return deviceInfo;
    }

    public String toReadableString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Firmware Revision  = " + this.firmwareRevision1 + "." + ByteUtility.byteToHex(this.firmwareRevision2) + "\n");
        sb.append("IPMI Version       = " + (this.IPMIVersion == 2 ? "2.0" : "Unknown") + "\n");
        sb.append("Manufacturer ID    = " + ByteUtility.bytesToHex(this.manufacturerID) + "\n");
        sb.append("product ID         = " + ByteUtility.bytesToHex(this.productID));
        return sb.toString();
    }

    public String toReadableStringWith3rdVersionNumber() {
        StringBuffer sb = new StringBuffer();
        sb.append("Firmware Revision  = " + this.firmwareRevision1 + "." + ByteUtility.byteToHex(this.firmwareRevision2) + "." + this.auxiliaryFirmwareRevisionInfo[0] + "\n");
        sb.append("IPMI Version       = " + (this.IPMIVersion == 2 ? "2.0" : "Unknown") + "\n");
        sb.append("Manufacturer ID    = " + ByteUtility.bytesToHex(this.manufacturerID) + "\n");
        sb.append("product ID         = " + ByteUtility.bytesToHex(this.productID));
        return sb.toString();
    }

    public String to3rdVersionNumber() {
        return this.firmwareRevision1 + "." + ByteUtility.bcdToInt(this.firmwareRevision2) + "." + this.auxiliaryFirmwareRevisionInfo[0];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Device ID = " + ByteUtility.byteToHex(this.deviceID) + "h \n");
        sb.append("Device Revision = " + ByteUtility.byteToHex(this.deviceRevision) + "h \n");
        sb.append("Firmware Revision 1 = " + ByteUtility.byteToHex(this.firmwareRevision1) + "h \n");
        sb.append("Firmware Revision 2 = " + ByteUtility.byteToHex(this.firmwareRevision2) + "h \n");
        sb.append("IPMI Version = " + ByteUtility.byteToHex(this.IPMIVersion) + "h \n");
        sb.append("Additional Device Support = " + ByteUtility.byteToHex(this.additionalDeviceSupport) + "h \n");
        sb.append("Device Revision = " + ByteUtility.byteToHex(this.deviceRevision) + "h \n");
        sb.append("Manufacturer ID = " + ByteUtility.bytesToHex(this.manufacturerID) + "h \n");
        sb.append("product ID = " + ByteUtility.bytesToHex(this.productID) + "h \n");
        sb.append("Auxiliary Firmware Revision Info = " + ByteUtility.bytesToHex(this.auxiliaryFirmwareRevisionInfo) + "h \n");
        return sb.toString();
    }

    public String toNM20ReadableString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Device ID         = " + ByteUtility.byteToHex(this.raw[0]) + "h " + (this.raw[0] == 80 ? "(Intel Management Engine)" : "") + " \n");
        sb.append("Firmware Version  = " + (byte)(this.raw[2] & 0x7F) + "." + (byte)((this.raw[3] & 0xF0) >> 4) + "." + (byte)(this.raw[3] & 0xF) + "." + ((byte)((this.raw[12] & 0xFF) >> 4) == 0 ? "" : Byte.valueOf((byte)((this.raw[12] & 0xFF) >> 4))) + (byte)(this.raw[12] & 0xF) + (byte)((this.raw[13] & 0xFF) >> 4) + "\n");
        sb.append("IPMI Version      = " + (this.raw[4] == 2 ? "2.0" : "Unknown") + "\n");
        sb.append("Manufacturer ID   = " + ByteUtility.bytesToHex(this.manufacturerID) + "\n");
        switch (this.raw[9]) {
            case 0: {
                sb.append("product ID Minor Ver = Tylersburg platform \n");
                break;
            }
            case 1: {
                sb.append("product ID Minor Ver = Bromolow platform \n");
                break;
            }
            case 2: {
                sb.append("product ID Minor Ver = Romley platform \n");
                break;
            }
            case 3: {
                sb.append("product ID Minor Ver = Denlow platform \n");
                break;
            }
            case 4: {
                sb.append("product ID Minor Ver = Brickland platform \n");
                break;
            }
            case 5: {
                sb.append("product ID Minor Ver = Grantley platform \n");
                break;
            }
            case 6: {
                sb.append("product ID Minor Ver = Grangeville platform \n");
                break;
            }
            case 7: {
                sb.append("product ID Minor Ver = Groveport Self Boot platform \n");
                break;
            }
            case 8: {
                sb.append("product ID Minor Ver = Groveport Leverage Boot platform \n");
                break;
            }
            case 9: {
                sb.append("product ID Minor Ver = Greenlow platform \n");
                break;
            }
            case 10: {
                sb.append("product ID Minor Ver = Purley platform \n");
                break;
            }
            case 11: {
                sb.append("product ID Minor Ver = Harrisonville platform \n");
                break;
            }
            case 12: {
                sb.append("product ID Minor Ver = Purley-EPO platform \n");
                break;
            }
            case 13: {
                sb.append("product ID Minor Ver = Monte Vista platform \n");
                break;
            }
            case 14: {
                sb.append("product ID Minor Ver = Bakerville platform \n");
                break;
            }
            case 15: {
                sb.append("product ID Minor Ver = Whitley platform \n");
                break;
            }
            case 16: {
                sb.append("product ID Minor Ver = Mehlow platform \n");
                break;
            }
            default: {
                sb.append("product ID Minor Ver = unknown platform \n");
            }
        }
        if (this.raw[11] != 19) {
            sb.append("Implemented DCMI version = ");
            if ((byte)(this.raw[11] & 0xF0) == 0) {
                sb.append(" DCMI not implemented/enabled");
            }
            if ((byte)(this.raw[11] & 0xF0) == 16) {
                sb.append(" DCMI Revision 1.0");
            }
            if ((byte)(this.raw[11] & 0xF0) == 32) {
                sb.append(" DCMI Revision 1.1");
            }
            if ((byte)(this.raw[11] & 0xF0) == 48) {
                sb.append(" DCMI Revision 1.5");
            }
            sb.append("\n");
            sb.append("Implemented Intel NM IPMI interface version = ");
            if ((byte)(this.raw[11] & 0xF) == 0) {
                sb.append(" Intel NM not implemented/enabled");
            }
            if ((byte)(this.raw[11] & 0xF) == 1) {
                sb.append(" NM Revision v1.5");
            }
            if ((byte)(this.raw[11] & 0xF) == 2) {
                sb.append(" NM Revision v2.0");
            }
            if ((byte)(this.raw[11] & 0xF) == 3) {
                sb.append(" NM Revision v3.0");
            }
            if ((byte)(this.raw[11] & 0xF) == 4) {
                sb.append(" NM Revision v4.0");
            }
            sb.append("\n");
        }
        switch (this.raw[14] & 3) {
            case 0: {
                sb.append("Image Flag = recovery image \n");
                break;
            }
            case 1: {
                sb.append("Image Flag = operational image 1 \n");
                break;
            }
            case 2: {
                sb.append("Image Flag = operational image 2 \n");
                break;
            }
            default: {
                sb.append("Image Flag = unspecified \n");
            }
        }
        sb.append("raw  = " + ByteUtility.bytesToHex(this.raw) + "\n");
        if ((byte)(this.firmwareRevision1 & 0x80) == -128) {
            sb.append("\n");
            sb.append("!!! Firmware is in following status !!!\n");
            sb.append("1. Device firmware update or self-initialization in progress \n");
            sb.append("2. Firmware in the recovery boot-loader mode \n");
        }
        return sb.toString();
    }

    public void setDeviceID(byte deviceID) {
        this.deviceID = deviceID;
    }

    public void setDeviceRevision(byte deviceRevision) {
        this.deviceRevision = deviceRevision;
    }

    public void setFirmwareRevision1(byte firmwareRevision1) {
        this.firmwareRevision1 = firmwareRevision1;
    }

    public void setFirmwareRevision2(byte firmwareRevision2) {
        this.firmwareRevision2 = firmwareRevision2;
    }

    public void setAdditionalDeviceSupport(byte additionalDeviceSupport) {
        this.additionalDeviceSupport = additionalDeviceSupport;
    }

    public void setManufacturerID(byte[] manufacturerID) {
        this.manufacturerID = manufacturerID;
    }

    public void setProductID(byte[] productID) {
        this.productID = productID;
    }

    public void setAuxiliaryFirmwareRevisionInfo(byte[] auxiliaryFirmwareRevisionInfo) {
        this.auxiliaryFirmwareRevisionInfo = auxiliaryFirmwareRevisionInfo;
    }

    public void setIPMIVersion(byte IPMIVersion2) {
        this.IPMIVersion = IPMIVersion2;
    }

    public byte getDeviceID() {
        return this.deviceID;
    }

    public byte getDeviceRevision() {
        return this.deviceRevision;
    }

    public byte getFirmwareRevision1() {
        return this.firmwareRevision1;
    }

    public byte getFirmwareRevision2() {
        return this.firmwareRevision2;
    }

    public byte getAdditionalDeviceSupport() {
        return this.additionalDeviceSupport;
    }

    public byte[] getManufacturerID() {
        return this.manufacturerID;
    }

    public byte[] getProductID() {
        return this.productID;
    }

    public byte[] getAuxiliaryFirmwareRevisionInfo() {
        return this.auxiliaryFirmwareRevisionInfo;
    }

    public byte getIPMIVersion() {
        return this.IPMIVersion;
    }

    public static void main(String[] args) {
        byte[] raw = new byte[]{80, 1, 3, 4, 2, 33, 87, 1, 0, 3, 11, 2, 41, 16, 1};
        StringBuffer sb = new StringBuffer();
        sb.append("Firmware Version  = " + (byte)(raw[2] & 0x7F) + "." + (byte)((raw[3] & 0xF0) >> 4) + "." + (byte)(raw[3] & 0xF) + "." + ((byte)((raw[12] & 0xFF) >> 4) == 0 ? "" : Byte.valueOf((byte)((raw[12] & 0xFF) >> 4))) + (byte)(raw[12] & 0xF) + (byte)((raw[13] & 0xFF) >> 4) + "\n");
        System.out.println(sb.toString());
    }
}

