/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IIPMIMessage;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SelfTestResultInfo;
import com.supermicro.ipmi.SessionControllerFactory;

public class IPMB
implements IPMIInterface {
    public static final int IPMB_TYPE_STANDARD = 0;
    public static final int IPMB_TYPE_CMM_OEM = 1;
    int ipmbType = 0;
    IPMIMessagingCommand ipmiMessagingCommand;
    IPMICMMOEMCommand ipmiCMMOEMCommand;
    IPMIInterface ipmiInterface;
    private byte channel;
    private byte address = (byte)34;

    public IPMB(IPMIInterface ipmiInterface) {
        this.ipmiMessagingCommand = new IPMIMessagingCommand(ipmiInterface);
        this.ipmiCMMOEMCommand = new IPMICMMOEMCommand(ipmiInterface);
    }

    @Override
    public void drop(IIPMIMessage ipmiMessage) {
    }

    @Override
    public void initialize(IPMIInterfaceConfig config) {
    }

    @Override
    public IPMIMessage send(IIPMIMessage ipmiMessage) {
        if (GlobalDefine.isDisplayRaw()) {
            this.rawToBMC(ipmiMessage);
        }
        IPMIMessage resMessage = null;
        switch (this.ipmbType) {
            case 0: {
                resMessage = this.send_Type0(ipmiMessage);
                break;
            }
            case 1: {
                resMessage = this.send_Type1(ipmiMessage);
                break;
            }
            default: {
                resMessage = this.send_Type0(ipmiMessage);
            }
        }
        if (GlobalDefine.isDisplayRaw()) {
            this.rawFromBMC(resMessage);
        }
        return resMessage;
    }

    private void rawFromBMC(IPMIMessage resMessage) {
        String raw = "";
        switch (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL) {
            case 1: {
                raw = ByteUtility.bytesToHex(resMessage.humanReadRaw());
                System.out.println("[ YOU <-IPMB : " + raw + "]");
                break;
            }
            case 2: {
                raw = ByteUtility.bytesToHex(resMessage.raw());
                System.out.println("[ YOU <-IPMB : " + raw + "]");
                break;
            }
            case 3: {
                raw = resMessage.toString();
                System.out.println(raw);
            }
        }
    }

    private void rawToBMC(IIPMIMessage ipmiMessage) {
        String raw = "";
        switch (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL) {
            case 1: {
                raw = ByteUtility.bytesToHex(ipmiMessage.humanReadRaw());
                System.out.println("[ YOU ->IPMB : " + raw + "]");
                break;
            }
            case 2: {
                raw = ByteUtility.bytesToHex(ipmiMessage.raw());
                System.out.println("[ YOU ->IPMB : " + raw + "]");
                break;
            }
            case 3: {
                raw = ipmiMessage.toString();
                System.out.println(raw);
            }
        }
    }

    private IPMIMessage send_Type0(IIPMIMessage ipmiMessage) {
        IPMIMessage resMessage = null;
        int count = 0;
        do {
            ((IPMIMessage)ipmiMessage).rsSA = this.getAddress();
            ((IPMIMessage)ipmiMessage).checkSum1 = ((IPMIMessage)ipmiMessage).calcCheckSum1();
            byte[] message = ipmiMessage.raw();
            resMessage = this.ipmiMessagingCommand.sendMessageCommand(this.channel, message);
            if (resMessage != null) {
                return resMessage;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (++count < 5);
        return resMessage;
    }

    private IPMIMessage send_Type1(IIPMIMessage ipmiMessage) {
        IPMIMessage resMessage = null;
        int count = 0;
        do {
            ((IPMIMessage)ipmiMessage).rsSA = this.getAddress();
            ((IPMIMessage)ipmiMessage).checkSum1 = ((IPMIMessage)ipmiMessage).calcCheckSum1();
            byte[] message = ipmiMessage.raw();
            resMessage = this.ipmiCMMOEMCommand.sendMessageOEMCommand(this.channel, message);
            if (resMessage != null) {
                if (resMessage.completionCode == -63) {
                    resMessage = this.send_Type0(ipmiMessage);
                }
                return resMessage;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (++count < 5);
        return resMessage;
    }

    @Override
    public IPMIMessage receive() {
        return null;
    }

    public IPMIMessage sendOrg(IIPMIMessage ipmiMessage) {
        ((IPMIMessage)ipmiMessage).rqSA = (byte)32;
        ((IPMIMessage)ipmiMessage).rqSeqLun = (byte)(((IPMIMessage)ipmiMessage).rqSeqLun | 2);
        byte[] message = ipmiMessage.raw();
        message[0] = 34;
        IPMIMessage resMessage = this.ipmiMessagingCommand.sendMessageCommand(this.channel, message);
        System.out.println("Send return code:" + ByteUtility.byteToHex(resMessage.completionCode) + " Size:" + resMessage.data.length);
        if (resMessage.completionCode != 0) {
            return null;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean done = false;
        int count = 0;
        do {
            IPMIMessage retMessage = this.ipmiMessagingCommand.getMessageCommand();
            System.out.println("Get return code:" + ByteUtility.byteToHex(retMessage.completionCode) + " Size:" + retMessage.data.length);
            if (retMessage != null && retMessage.completionCode == 0) {
                System.out.println(ByteUtility.bytesToHex(retMessage.data));
                boolean b = this.ipmiMessagingCommand.clearReceiveMessageQueue();
                System.out.println("clear receive message queue = " + b);
                return retMessage;
            }
            try {
                Thread.sleep(100L);
                ++count;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (count <= 10 && !done);
        return null;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public void setAddress(byte address) {
        this.address = address;
    }

    public void setIpmbType(int ipmbType) {
        this.ipmbType = ipmbType;
    }

    public byte getChannel() {
        return this.channel;
    }

    public byte getAddress() {
        return this.address;
    }

    public int getIpmbType() {
        return this.ipmbType;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("172.31.8.224");
        config.setUserName("ADMIN");
        config.setPassword("password");
        config.setTimeout(20);
        config.setPrivilege((byte)4);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        IPMIDCMOEMCommand ipmiDCMOEMCommand = new IPMIDCMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiLanCommand);
        if (sessionController == null) {
            return;
        }
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmiOEMCommand.setIPMIInterface(ipmb);
        ipmiGlobalCommand.setIPMIInterface(ipmb);
        ipmiDCMOEMCommand.setIPMIInterface(ipmb);
        ipmb.setAddress((byte)-120);
        IPMIMessage resMessage = ipmiGlobalCommand.getDeviceIDCommand();
        System.out.println("comp = " + resMessage.completionCode);
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        System.out.println("deviceInfo = " + deviceInfo.toString());
        SelfTestResultInfo testResult = ipmiGlobalCommand.getSelfTestResult();
        System.out.println("testResult = " + testResult.toString());
        boolean b = sessionController.closeSession();
    }

    public static void main_(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.121");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setTimeout(20);
        config.setPrivilege((byte)4);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        IPMIDCMOEMCommand ipmiDCMOEMCommand = new IPMIDCMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiLanCommand);
        if (sessionController == null) {
            return;
        }
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmiOEMCommand.setIPMIInterface(ipmb);
        ipmiGlobalCommand.setIPMIInterface(ipmb);
        ipmiDCMOEMCommand.setIPMIInterface(ipmb);
        ipmb.setIpmbType(1);
        ipmb.setAddress((byte)34);
        ipmb.setChannel((byte)9);
        String ip = ipmiLanCommand.getIP();
        System.out.println("ip =" + ip);
        boolean b = sessionController.closeSession();
    }
}

