/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.KIRAConfiguration;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.algo.AES_CBC_128;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class IPMIOEMCommand
extends IPMICommand {
    static AES_CBC_128 aes = new AES_CBC_128();
    static byte[] iv = new byte[16];
    static byte[] key = new byte[16];
    public static final byte SIM_LAN_TYPE_DEDICATED = 0;
    public static final byte SIM_LAN_TYPE_SHARED = 1;
    public static final byte SIM_LAN_ETH0 = 1;
    public static final byte SIM_LAN_ETH1 = 2;
    public static final byte SIM_LAN_TCO_FML = 3;
    public static final byte SIM_LAN_MCP55 = 4;
    public static final byte SIM_LAN_ECO_I2C = 5;
    public static String[][] idToBoard = new String[][]{{"X11DPFF-SNR ", "1B", "53"}, {"X11QPL", "1B", "52"}, {"AOC-S100GC-i2C", "1B", "51"}, {"X11DPD-L/M25", "1B", "4F"}, {"AOC-SLG3-4E4T", "1B", "4E"}, {"X11SWN", "1B", "4D"}, {"X11SRi-IF", "1B", "4C"}, {"X12DPU", "1B", "4B"}, {"X12SPi-TF ", "1B", "4A"}, {"A3SSV", "1B", "49"}, {"B2SD2 ", "1B", "48"}, {"X12DPi ", "1B", "47"}, {"X11DPT-BR", "1B", "46"}, {"H12SST-PS", "1B", "45"}, {"X11DPU-R", "1B", "44"}, {"AOC-AG-i4S", "1B", "43"}, {"X11DPU-S", "1B", "42"}, {"X11SRL-F", "1B", "41"}, {"X11SPD-F", "1B", "3F"}, {"AOC-S100G-b2C", "1B", "3E"}, {"B11SCG-CTF", "1B", "3D"}, {"AOM-SDW-B16X2", "1B", "3C"}, {"X11SDS-8C", "1B", "3B"}, {"H12DST-B", "1B", "3A"}, {"B11SCG-ZTF", "1B", "39"}, {"X11DPT-BV", "1B", "38"}, {"X11DPU-V", "1B", "37"}, {"X11SCD-F", "1B", "36"}, {"X11SDW", "1B", "35"}, {"X11SPA-T", "1B", "34"}, {"B11SRE", "1B", "33"}, {"B11SRE-CPU ", "1B", "32"}, {"AOC-M25G-m2S", "1B", "31"}, {"AOM-SMF-TP4F", "1B", "2F"}, {"AOC-MG-b2", "1B", "2E"}, {"M11SDV", "1B", "2D"}, {"H12SSW-NT", "1B", "2C"}, {"H12SSW-iN", "1B", "2B"}, {"AOC-2MG-i8", "1B", "2A"}, {"B2SC1", "1B", "29"}, {"X11SPA-TF", "1B", "28"}, {"AOC-S100G-b1C", "1B", "27"}, {"AOC-2UR68-b2TS", "1B", "26"}, {"X11DPU-ZE+", "1B", "25"}, {"BPN-6S3008S6", "1B", "24"}, {"RSC-UM2R-8+-NI22", "1B", "23"}, {"AOC-SMG2-2TM2", "1B", "22"}, {"AOC-SLG2-4TM2", "1B", "21"}, {"AOC-SLG2-2TM2", "1B", "20"}, {"X11DPG-HGX2", "1B", "1F"}, {"AOC-URN4-B2ts", "1B", "1E"}, {"X11DPT-L", "1B", "1D"}, {"X11SDD", "1B", "1C"}, {"AOC-CTG-i2S", "1B", "1B"}, {"C9Z390-CG(W)", "1B", "1A"}, {"H11SSW-NT/iN", "1B", "19"}, {"C7B360-CB-ML", "1B", "18"}, {"X11DPFF-SN", "1B", "17"}, {"AOM-PICO-3L", "1B", "16"}, {"X11SCL-LN4F", "1B", "15"}, {"C9X299-PG300F", "1B", "14"}, {"AOC-4UR66-i4XTF", "1B", "13"}, {"AOC-SGP-i4", "1B", "12"}, {"X11SCH-LN4F", "1B", "11"}, {"A2SDV-LN8F/LN10PF", "1B", "10"}, {"X11SCM", "1B", "0F"}, {"X11SCL-IF", "1B", "0E"}, {"X11SCV-Q/L", "1B", "0D"}, {"AOC-B25G-6X4D", "1B", "0C"}, {"AOC-STG-b2T", "1B", "0B"}, {"B10DRT-IBF2", "1B", "0A"}, {"X11SCZ-F", "1B", "09"}, {"C9X299-PG300", "1B", "08"}, {"X11SCW-F", "1B", "07"}, {"X11SCQ-L", "1B", "06"}, {"X11SCQ", "1B", "05"}, {"X11DPT-LC019", "1B", "04"}, {"AOC-2UR688-i4XTF", "1B", "03"}, {"X11DGO-T", "1B", "02"}, {"X11DSN-TS", "1B", "01"}, {"X11SCL-F", "1A", "1F"}, {"X11DAC", "1A", "1E"}, {"X11SCA-F/W", "1A", "1D"}, {"X11DSF", "1A", "1C"}, {"X11SCE-F", "1A", "1B"}, {"A2SD1-3750F/3955F", "1A", "1A"}, {"AOC-URN4-b2XT", "1A", "09"}, {"AOC-STG-b2T", "1A", "08"}, {"B11SPE-CPU-TF/25G", "1A", "07"}, {"X11DPG-OT-CPU", "1A", "06"}, {"AOM-M25G-i2S", "1A", "05"}, {"B10KNM", "1A", "04"}, {"H11SSL-i/c/nc", "1A", "03"}, {"C7C242-CB-M", "1A", "02"}, {"C7B360-CB-M", "1A", "01"}, {"C7Z390-CG-IW", "09", "9F"}, {"C7Z390-PGW", "09", "9E"}, {"X11DSC+", "09", "9D"}, {"SAS 3616", "09", "9C"}, {"AOC-OPH-WFR", "09", "9B"}, {"X11DPS-R", "09", "9A"}, {"AOC-MHIBE-m1CG", "09", "99"}, {"C7Z370-CG-iW", "09", "98"}, {"B11DPE", "09", "97"}, {"AOC-MTG-b2T", "09", "96"}, {"X11DPG-SN", "09", "95"}, {"AOC-B25G-M2S", "09", "94"}, {"AOC-URN4-i2TS", "09", "93"}, {"B11SPi-CPU-TF", "09", "92"}, {"C7Z370-CG-L", "09", "91"}, {"B11QPi", "09", "8F"}, {"X11SRA-R/F", "09", "8E"}, {"A2SAP-H/E/L", "09", "8D"}, {"X11DPX-T", "09", "8C"}, {"X11SSN", "09", "8B"}, {"H11DST-B", "09", "8A"}, {"B10DRE", "09", "89"}, {"X11DGQ", "09", "88"}, {"X11SDV-TLN2F", "09", "87"}, {"X11SDV", "09", "86"}, {"P9DSU-C", "09", "85"}, {"X11SRM-(V)F", "09", "84"}, {"AOC-M25G-m4S", "09", "83"}, {"A2SDV-TLN5F", "09", "82"}, {"X11DPH-i", "09", "81"}, {"X11OPi", "09", "80"}, {"X11QPH+", "09", "7F"}, {"X11SPG-F", "09", "7E"}, {"C7B250-CB-i", "09", "7D"}, {"AOC-IBH-X4ES", "09", "7C"}, {"C7X299", "09", "7B"}, {"X11DAI-N", "09", "7A"}, {"BMB-IBD-E3616", "09", "79"}, {"AOC-S25G-i2S", "09", "78"}, {"X11DPFR-SN", "09", "77"}, {"SAS3324", "09", "76"}, {"SAS3316", "09", "75"}, {"SAS3516", "09", "74"}, {"SAS3508", "09", "73"}, {"SAS3216", "09", "72"}, {"X11SRE-EXP-SI030", "09", "71"}, {"C7Z270-CG-M", "09", "70"}, {"AOC-IBH-X4ED", "09", "6F"}, {"X11SPL-F", "09", "6E"}, {"X11DPG-Qt", "09", "6D"}, {"X11DPU-Z+", "09", "6C"}, {"X11DPT-P-SG007", "09", "6B"}, {"C7C232-CB-ML", "09", "6A"}, {"A2SDi-HLN4F", "09", "69"}, {"X11DPL-i", "09", "68"}, {"X11DDW", "09", "67"}, {"B11DPT", "09", "66"}, {"C7B250-CB-ML", "09", "65"}, {"H11DSi-NT", "09", "64"}, {"H11DSU-i", "09", "63"}, {"X11DPT-B+", "09", "62"}, {"P9DSC", "09", "61"}, {"X11SAN", "09", "60"}, {"X11SAA", "09", "5F"}, {"X11SPH-NCTPF", "09", "5E"}, {"X11SPM-T(P)F", "09", "5D"}, {"X11DPU-X", "09", "5C"}, {"X11DPU-XLL", "09", "5B"}, {"X10DGO", "09", "5A"}, {"R10SR2", "09", "59"}, {"X11SSH", "09", "58"}, {"AOC-MHIBF-m2Q2G", "09", "57"}, {"AOC-MHIBF-m1Q2G", "09", "56"}, {"X11SSW", "09", "55"}, {"AOC-C25G-m1S", "09", "54"}, {"X11SPW-(c)TF", "09", "53"}, {"X11SPX-TF", "09", "52"}, {"B2SS1(2)-MTF", "09", "51"}, {"X10DRW-SE", "09", "50"}, {"P8DNU", "09", "4F"}, {"AOC-MH25G-b2S2G", "09", "4E"}, {"AOC-MHIBF", "09", "4D"}, {"AOC-S25G-m2S", "09", "4C"}, {"AOC-S100G-m2C", "09", "4B"}, {"AOC-2UR68-m2TS", "09", "4A"}, {"AOC-MH25G-m2S2T", "09", "49"}, {"AOC-C25G-m2S", "09", "48"}, {"A2SAN", "09", "47"}, {"X10SDV", "09", "46"}, {"C7Q270-CB-ML", "09", "45"}, {"C7H270-CG-ML", "09", "44"}, {"C7Z270-PG", "09", "43"}, {"K1SPE", "09", "42"}, {"X11SPi-TF", "09", "41"}, {"C7Z270-CG", "09", "40"}, {"C7Z270-CG-L", "09", "3F"}, {"X10DRT-B+", "09", "3E"}, {"AOC-S3216L-L16iT", "09", "3D"}, {"A2SAV", "09", "3C"}, {"AOC-STGF-i2S", "09", "3B"}, {"X11SSV-M4F", "09", "3A"}, {"X11SSV-M4", "09", "39"}, {"X11DPT", "09", "38"}, {"X11DPT", "09", "37"}, {"AOC-UR-i4XTF", "09", "36"}, {"AOC-STG-i4T", "09", "35"}, {"AOC-MHFI-i1C", "09", "34"}, {"P8DTU", "09", "33"}, {"X10DRL-LN4", "09", "32"}, {"B2SS1-CF", "09", "31"}, {"X11SSQ-L", "09", "30"}, {"AOC-S40G-i1Q", "09", "2F"}, {"AOC-2UR68-B2TS", "09", "2E"}, {"X10SDE-DF", "09", "2D"}, {"AOC-S8069L-16xR", "09", "2C"}, {"X10DSN-TS", "09", "2B"}, {"AOC-M25G-b2S", "09", "2A"}, {"AOC-2UR66-i4XTF", "09", "29"}, {"AOC-S25G-b2S", "09", "28"}, {"X11DPT-PS", "09", "27"}, {"AOC-MHIBF-1QG", "09", "26"}, {"AOC-MHIBF-2QG", "09", "25"}, {"X10SRM-(T)F", "09", "24"}, {"AOM-X10OBI-PCH", "09", "23"}, {"X10SRW-LN4F", "09", "22"}, {"X10SDV-7TP8F", "09", "21"}, {"AOC-MTG-i2T", "09", "20"}, {"AOC-MTG-i4T", "09", "1F"}, {"X10SD7-AC107", "09", "1E"}, {"X11SSW-LN4F", "09", "1D"}, {"X11DPU", "09", "1C"}, {"AOC-UR-i4XT+", "09", "1B"}, {"AOC-2UR6-i4xT+", "09", "1A"}, {"X10SDD-F", "09", "19"}, {"AOC-UR-i4GXS", "09", "18"}, {"X11DPi-N(T)", "09", "17"}, {"X10DSC-TP4S", "09", "16"}, {"AOC-STGS-i2T", "09", "15"}, {"AOC-STGS-i1T", "09", "14"}, {"AOC-MG-i4", "09", "13"}, {"AOC-MG-i2", "09", "12"}, {"X10DRT-PS", "09", "11"}, {"A2SDi-H", "09", "10"}, {"A2SDi", "09", "0F"}, {"K1SPE(-T)", "09", "0E"}, {"X11SRE-DS018", "09", "0D"}, {"AOC-MTG-I2s", "09", "0C"}, {"AOC-MTG-i4S", "09", "0B"}, {"AOC-SLG3-4E4", "09", "0A"}, {"X11SSD-F", "09", "09"}, {"B2SS2", "09", "08"}, {"X11SAT(-F)", "09", "07"}, {"K1SPi-KB-SG007", "09", "06"}, {"K1SPI-KA-SG007", "09", "05"}, {"AOC-2UR6N4-i4XT", "09", "04"}, {"AOC-CTGS-i2T", "09", "03"}, {"C7Z170-OCE", "09", "02"}, {"X11SSM", "09", "01"}, {"X11SAE-M", "08", "9F"}, {"AOC-URN2-i4GXS", "08", "9E"}, {"X10DSC+", "08", "9D"}, {"X11SSH-CTF", "08", "9C"}, {"X11SSW-F", "08", "9B"}, {"X11SLL", "08", "9A"}, {"X10DRH", "08", "99"}, {"X11SSE", "08", "98"}, {"B1SD1-TF", "08", "97"}, {"X11SSL/M-F", "08", "96"}, {"X11SAE", "08", "95"}, {"X11SSV-Q", "08", "94"}, {"X10DGQ", "08", "93"}, {"X10DRG-O+-CPU", "08", "92"}, {"X11SBA", "08", "91"}, {"X11SSQ", "08", "90"}, {"AOM-PIO-i2XT", "08", "8F"}, {"AOC-PIO-i2G", "08", "8E"}, {"AOC-S100G-i2C", "08", "8D"}, {"AOM-S3108-H8S-SB", "08", "8C"}, {"C7Z170-SQ", "08", "8B"}, {"AOC-URN6-i2XT", "08", "8A"}, {"B10DRG", "08", "89"}, {"X11SSZ", "08", "88"}, {"AOC-S8076L-L16e", "08", "87"}, {"X11SSA(-F)/X11SSi-LN4(F)", "08", "86"}, {"X11SSL-CF/-NF", "08", "85"}, {"X11SSH-F/-LN4F", "08", "84"}, {"K1SPI", "08", "83"}, {"X10DRX", "08", "82"}, {"X10DRT-XB-SG007", "08", "81"}, {"X10DRT-XA-SG007", "08", "80"}, {"X10DRFF-iG", "08", "7F"}, {"AOC-STG-i4S", "08", "7E"}, {"X10SRD-F", "08", "7D"}, {"AOC-XEH-i4M", "08", "7C"}, {"AOC-XEH-i2M", "08", "7B"}, {"B1SD2-TF", "08", "7A"}, {"X10DRD-I/L/NT", "08", "79"}, {"RSC-S2-88", "08", "78"}, {"X10DRT-HB-SG007", "08", "77"}, {"A2SCL-IN001", "08", "76"}, {"AOC-2UR66-i4G", "08", "75"}, {"AOC-2UR8N4-i2XT", "08", "74"}, {"AOC-2URN4-i4XT", "08", "73"}, {"X10QRH+", "08", "72"}, {"AOC-2UR68-i2XS", "08", "71"}, {"AOC-URN2-ii2SX", "08", "70"}, {"X10DRT-L", "08", "6F"}, {"X10DDW-iN", "08", "6E"}, {"X10SDV-TLN4F", "08", "6D"}, {"X10DAL-i", "08", "6C"}, {"X10DRS", "08", "6B"}, {"AOC-URN2-i2XT", "08", "6A"}, {"AOC-2UR68-i2XT", "08", "5F"}, {"AOC-2UR6-i4XT", "08", "5E"}, {"AOC-UR-i2XT", "08", "5D"}, {"X10DRU-XLL", "08", "5C"}, {"X10DRT-HA/HB-SG007", "08", "5B"}, {"A1SRM-LN7F", "08", "5A"}, {"AOC-STGN-i2SF", "08", "4F"}, {"AOC-STGN-i1SF", "08", "4D"}, {"C7Z97-MF", "08", "4C"}, {"X10SRG", "08", "4B"}, {"AOC-S40G-i2Q", "08", "4A"}, {"AOC-URN2-i4XT", "08", "69"}, {"AOC-SLG3-2E4", "08", "68"}, {"AOC-SLG3-4E4R", "08", "67"}, {"AOC-SLG3-2E4R", "08", "66"}, {"X10DRD-i/LTP", "08", "65"}, {"X10DRW-E/NT", "08", "64"}, {"RSC-W2-66", "08", "63"}, {"B1SL1-F", "08", "62"}, {"B10DRT", "08", "61"}, {"X10DRL-C/CT", "08", "60"}, {"X10DRH-C", "08", "59"}, {"X10DRT-H", "08", "58"}, {"X10SRA", "08", "57"}, {"C7X99", "08", "56"}, {"H9SKV-420", "08", "55"}, {"X10DRU-X", "08", "54"}, {"X10QBL", "08", "53"}, {"X10DRG-Q", "08", "52"}, {"PMC PM8076", "08", "51"}, {"AOC-PG-i4M", "08", "50"}, {"AOC-UR-i4G", "08", "49"}, {"AOC-2UR68-i4G", "08", "48"}, {"AOC-UR-i4XT", "08", "47"}, {"B1DRi", "08", "46"}, {"X10DDW-iN", "08", "45"}, {"X10DRU-i+", "08", "44"}, {"X10DRG-H(T)", "08", "43"}, {"X10SLH-N6-ST031", "08", "42"}, {"X9DRD-iT+", "08", "41"}, {"B9DRG-3M", "08", "40"}, {"B9QR7", "08", "3F"}, {"B10DRi", "08", "3E"}, {"LSI 2116", "08", "3D"}, {"A1SA7-2750F", "08", "3C"}, {"X10DDW-iT", "08", "3B"}, {"X10DBT-T", "08", "3A"}, {"AOC-SLG3-2E4", "08", "39"}, {"X10SRH-F", "08", "38"}, {"X10DRT-D-SG007", "08", "37"}, {"X10DAi", "08", "36"}, {"X10DRC/i-LN4+/T4+", "08", "35"}, {"X10SRI", "08", "34"}, {"X10SRW-F", "08", "33"}, {"X10SRL", "08", "32"}, {"X10DRL-i", "08", "31"}, {"X10DRFR", "08", "30"}, {"C7Z97-OCE", "08", "29"}, {"A1SA2-2750F", "08", "28"}, {"X9QRH-TF", "08", "27"}, {"X10SRE-EXP-SI030", "08", "26"}, {"X10SRE-DS018", "08", "25"}, {"X10DRT-P", "08", "24"}, {"AOC-CTG-I1S", "08", "23"}, {"X10DRFF(-C)", "08", "22"}, {"X10DRW-i(T)", "08", "21"}, {"AOC-STG-I2T", "07", "34"}, {"X9DB3-CPU-AI026", "07", "33"}, {"X9DRG-OF", "07", "32"}, {"X9DRT-P", "07", "31"}, {"A1SAM", "08", "20"}, {"X10SLV-Q", "08", "19"}, {"B1SA4-F", "06", "61"}, {"X9DAX-HFT", "07", "30"}, {"X10SAT", "08", "18"}, {"X9SKV", "08", "20"}, {"X10SLE-DF", "08", "17"}, {"X10SBA", "08", "16"}, {"B9DRG-E", "07", "29"}, {"X10SLV", "08", "15"}, {"X10SLX-TF", "08", "14"}, {"X10DRI/T", "07", "28"}, {"X9DRW-CF31/CTF31", "07", "27"}, {"X10SEAA-LN4F", "08", "13"}, {"X10QBi", "07", "26"}, {"X9DRG+HF+II", "07", "25"}, {"AOC-STGN-I1S", "06", "59"}, {"X10SLL+-F", "08", "12"}, {"X10SLM-F", "08", "11"}, {"X9DRH-if-NV", "07", "24"}, {"AOC-STG-B4S", "06", "58"}, {"C7Z87-OCE", "06", "57"}, {"X10SLD", "08", "10"}, {"AOC-SGP-i2", "06", "56"}, {"LSI3108", "08", "09"}, {"LSI3008", "08", "08"}, {"X10SLE", "08", "07"}, {"X10SLM-LN4F", "08", "06"}, {"AOC-XEH-IN2", "06", "55"}, {"C7Q87", "06", "54"}, {"C7Z87", "06", "53"}, {"X10SAE", "08", "05"}, {"H8SME-F", "D1", "11"}, {"X10SL7-f", "08", "04"}, {"X9DRL-7F/EF", "07", "23"}, {"AOC-CGP-i2", "06", "52"}, {"H8QG7", "D0", "11"}, {"X9DB3-TPF", "07", "22"}, {"X9DBS-F", "07", "21"}, {"X9SBAA", "06", "51"}, {"X9SPV-M4", "06", "50"}, {"X9DRW-7TPF+", "07", "20"}, {"X10SLH", "08", "03"}, {"X10SLA", "08", "02"}, {"X10SLL", "08", "01"}, {"X9SCE-F", "06", "47"}, {"H8SML-7/i(F)", "CF", "11"}, {"B9DRP", "07", "19"}, {"X9DRFF-7G+", "07", "18"}, {"X9DRFF-7+/i+", "07", "17"}, {"C7B75", "06", "48"}, {"X9SCAA", "06", "47"}, {"X9DBU-3F-AI034", "07", "16"}, {"X9SCFF", "06", "46"}, {"X9DRW-7TPF", "07", "15"}, {"X9SRH-7F", "07", "14"}, {"X9DRFF-7", "07", "13"}, {"B9DRG-X", "07", "12"}, {"C7H61", "06", "45"}, {"X9DRG-HTF+", "07", "11", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRG-HTF.cfm"}, {"X9SRE", "07", "10", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRE-F.cfm"}, {"X9QR7-TF", "07", "0F"}, {"X9DAX-7", "07", "0E"}, {"B9DR7", "07", "0D"}, {"x9SAE", "06", "44"}, {"X9SRD-CD", "07", "0C"}, {"X9SRL-CF", "07", "0B"}, {"X9DRF-F", "07", "0A"}, {"X9DA7/E", "07", "09"}, {"X9DRT-F", "07", "08"}, {"X9QR7-TF+", "07", "07"}, {"X9SPU", "07", "43"}, {"X9DRT-HF+", "07", "06"}, {"X9DR7/E-LN4F", "07", "05"}, {"X9DR7/E-TF+", "07", "04"}, {"X9DBL-6F", "07", "03"}, {"X9DRD-7LN4F", "07", "02"}, {"X9DRT-HIBQF-AI034", "07", "01", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRT-HIBQF.cfm"}, {"X9DRT-HF-AI034", "07", "00"}, {"X9DRW-LN4F+-AI034", "06", "6f"}, {"X9DR6-LN4F+-AI034", "06", "6e"}, {"X9DR6+-F-AI034", "06", "6d"}, {"B9DRG", "06", "6C"}, {"X9SRL-F", "06", "6b"}, {"C7Q67-H", "06", "42"}, {"B9DRT", "06", "6A"}, {"X9DRX+-F", "06", "69", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRX_-F.cfm"}, {"X9SRD", "06", "68"}, {"X9DRL-3/iF", "06", "67", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRL-3F.cfm"}, {"X9DRT-D-SG007", "06", "66"}, {"X9DRG-QF", "06", "65", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRG-QF.cfm"}, {"X9SCV-LN4F+", "06", "41"}, {"X9SCL/SCM-II", "06", "40", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCL-F.cfm"}, {"X9DRH-7F", "06", "64", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRH-7F.cfm"}, {"X9SRW", "06", "63", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRW-F.cfm"}, {"X9DRG-QF+", "06", "62"}, {"X9SRG", "06", "61", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRG-F.cfm"}, {"2308", "06", "91"}, {"2208", "06", "90"}, {"X9DRD-3/iF", "06", "60", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRD-iF.cfm"}, {"X8QB6-LF", "06", "38", "http://www.supermicro.com/products/motherboard/Xeon7000/7500/X8QB6-LF.cfm"}, {"X9DBU-3F", "06", "37"}, {"X9DRW-3F", "06", "36", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRW-3F.cfm"}, {"X9DAL-6/i", "06", "35"}, {"H8DCT-HLN4F", "CE", "11"}, {"X9SCD", "06", "34", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCD-F.cfm"}, {"X9SCV-Q", "06", "33"}, {"X8DTG-QF+", "06", "32", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTG-QF_.cfm"}, {"X9SCA/X9SCI", "06", "31", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCA-F.cfm"}, {"X9DRW-3TF+", "06", "30", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRW-3TF_.cfm"}, {"X9DRT-HF", "06", "2F", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRT-HF.cfm"}, {"H8DCL-6F", "CD", "11"}, {"X8STE-DS018", "06", "2E"}, {"X8SIL-SIOM-FI005", "06", "2D"}, {"H8DGT-CM", "CB", "11"}, {"X9DAi", "06", "2C", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DAi.cfm"}, {"X9SRi", "06", "2B", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRi-F.cfm"}, {"X9SRA", "06", "2A", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRA.cfm"}, {"X9SRT-F", "06", "29"}, {"X9DR3/i-F", "06", "28", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DR3-F.cfm"}, {"H8QGL", "CA", "11"}, {"X7SPT-DF-D525", "06", "27"}, {"X9DR3-LN4F+", "06", "26", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DR3-LN4F_.cfm"}, {"B9DRi", "06", "25"}, {"X9SCM", "06", "24", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCM-F.cfm"}, {"H8DME-EX-LS006", "BF", "11"}, {"C7Q67", "06", "23"}, {"C7P67", "06", "22"}, {"X8OBN", "06", "21", "http://www.supermicro.com/products/motherboard/Xeon7000/7500/X8OBN-F.cfm"}, {"H8DCT", "BE", "11"}, {"H8DGT-C", "BD", "11"}, {"BHQG6/E", "BC", "11"}, {"B8DTG", "06", "20"}, {"B8DTP", "06", "1F"}, {"X9SCL", "06", "1E"}, {"H8DCT-IBQF", "BD", "11"}, {"H8DG6/i-F", "BC", "11"}, {"C7SIA", "06", "1D"}, {"BHDGT", "BB", "11"}, {"H8SCM-F", "BA", "11"}, {"B8DTT-AI034", "06", "1E"}, {"B8DT6-AI034", "06", "1C"}, {"H8DGU-LN4F+-AI034", "AF", "11"}, {"H8QGI-F-AI034", "AE", "11"}, {"H8DGT-HIBQF-AI034", "AD", "11"}, {"H8DGU-LN4", "AC", "11"}, {"H8QG6", "AB", "11"}, {"X8DTT-HA", "06", "1B"}, {"X8SIU", "06", "1A", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIU.cfm?IPMI=Y"}, {"X8DTU-6TF+", "06", "0D", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU_.cfm?TYP=SAS&LAN=10"}, {"X8DTU-LN4F+", "06", "0C", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU_.cfm"}, {"H8DGT", "AA", "11"}, {"H8DGG-QF", "A9", "11"}, {"H8DGU", "A8", "11"}, {"X8DTU-F-AI034", "06", "14", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU-F.cfm"}, {"X8DTT-C-SG007", "06", "13"}, {"B8DTT", "06", "12"}, {"AOC-STGN-I2S", "06", "11"}, {"X8QB6/E", "06", "10", "http://www.supermicro.com/products/motherboard/Xeon7000/7500/X8QB6.cfm?SAS=Y"}, {"X8DTN+-F", "06", "0F"}, {"X8SIT", "06", "0E", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIT.cfm?IPMI=Y"}, {"X8DTU+", "06", "0C"}, {"X8SIA", "06", "0B", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIA.cfm?IPMI=Y"}, {"H8DGU", "A8", "11"}, {"X7SPA", "06", "0A"}, {"H8SGL", "A7", "11"}, {"BHQIE", "A6", "11"}, {"X8SII/X8SI6", "04", "0D", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIE.cfm?IPMI=Y&TYP=SAS"}, {"X8DT6/E", "04", "04", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DT6-F.cfm?IPMI=N&SAS=Y"}, {"B8DTL", "01", "01"}, {"X8DTS", "06", "09"}, {"X8DTG-DF", "06", "08", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTG-DF.cfm"}, {"X8DTW-6+/i+", "04", "0B"}, {"X8DTL-6/L", "04", "10", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTL-6.cfm"}, {"X8DA6/i-X", "04", "03"}, {"H8QI6/E(+)(-F)", "04", "09"}, {"C2G41", "06", "07"}, {"X8DTG-4", "06", "06"}, {"X8SIL", "06", "05", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIL.cfm?IPMI=Y"}, {"winbond IPMI (Aten)", "06", "04"}, {"C2SEM-Q", "06", "03"}, {"X7SLA", "06", "02"}, {"X8DTH-6/i", "04", "00", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTH-6F.cfm"}, {"x8DAL-3/i", "06", "01"}, {"X8DTU", "06", "00", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU.cfm"}, {"B8DT3", "00", "0A"}, {"X8DTH-RC014", "04", "01"}, {"X8STi-3/-LN4", "00", "09", "http://www.supermicro.com/products/motherboard/Xeon3000/X58/X8STi-3F.cfm"}, {"H8DI3+", "A5", "11"}, {"X7SLM-L", "ba", "80"}, {"X8DAH+", "01", "00", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DAH_.cfm"}, {"H8DME-2-LS006", "25", "11"}, {"X8DTT-B-SG", "00", "08"}, {"X8DTT-IBX", "00", "07", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTT-IBXF.cfm"}, {"X8DTL-3/i", "00", "06", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTL-3F.cfm"}, {"X8DTW-3/i/-LN4", "00", "03"}, {"C2SLM-OC012", "00", "02"}, {"X8ST3", "F5", "80", "http://www.supermicro.com/products/motherboard/Xeon3000/X58/X8ST3-F.cfm"}, {"X8SAX", "F3", "80"}, {"X8DT3/i/-LN4", "00", "01", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DT3-F.cfm"}, {"Winbond IPMI (AMI)", "B9", "80"}, {"H8QM3-EX", "A3", "11"}, {"H8DMT-IBX", "24", "11"}, {"X7DCX", "F4", "80"}, {"X7SB3", "A9", "80"}, {"BHDME", "23", "11"}, {"X8DA3/i", "A8", "80"}, {"X8DTN+", "F2", "80", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTN_.cfm?IPMI=O"}, {"X7DWT-CD-SG007", "B7", "80"}, {"AOC-USASLP-H8iR", "C3", "80"}, {"C2SEA", "B8", "80"}, {"X7SBU", "F1", "80"}, {"X7SBT", "F0", "80"}, {"B7DC3", "A7", "80"}, {"H8DMT", "22", "11"}, {"B7DCE", "BB", "80"}, {"X7DWE", "DF", "80"}, {"X7DWT-C-SG007", "AA", "80"}, {"X7DCT-10G", "DE", "80"}, {"X7DCA-3/i", "A6", "80"}, {"X7SBX", "DD", "80"}, {"X7DCA-L", "DC", "80"}, {"X7DCU", "DB", "80"}, {"C2SBM-Q", "DA", "80"}, {"X7DWP", "D0", "80"}, {"X7DWU", "AC", "80"}, {"B7DW3", "C2", "80"}, {"PDSMP-JN001", "AE", "80"}, {"AOC-UTG-I2", "AF", "80"}, {"X7SBF", "D5", "80"}, {"BHQME", "AD", "11"}, {"X7SBi-LN4", "D4", "80"}, {"C2SBM-Q", "AB", "80"}, {"C2SBi", "BF", "80"}, {"C2SBC", "BE", "80"}, {"X7SBL-LN1/LN2", "AA", "80"}, {"AOC-USAS-H8i", "C1", "80"}, {"AOC-USAS-H4i", "C0", "80"}, {"C2SBC", "BE", "80"}, {"C2SBM", "BD", "80"}, {"X7DWT/-INF", "BC", "80"}, {"X7SBA", "D3", "80"}, {"M8QME", "21", "11"}, {"X7SB4/E", "D2", "80"}, {"C2SBX", "BA", "80"}, {"X7DCA-3/i", "D6", "80"}, {"X7DCL-3", "A4", "80"}, {"H8QM3-2", "A2", "11"}, {"X7QC3", "A3", "80"}, {"X7SBi", "D1", "80"}, {"C2SBA", "B7", "80"}, {"AOC-USAS-L8I", "A5", "80"}, {"X7DGT-ATOKAP", "B6", "80"}, {"PDSBM-LN2", "B5", "80"}, {"X7DW3+", "A2", "80"}, {"AOC-UG-i4", "B4", "80"}, {"X7DWN", "B3", "80"}, {"X7DVL-L", "B2", "80"}, {"H8SMU", "20", "11"}, {"H8DA3-2", "A1", "11"}, {"H8DMU", "19", "11"}, {"X7DBI+", "B1", "80"}, {"H8DM3-2", "A0", "11"}, {"H8SSL-I2", "18", "11"}, {"B7DBE", "B0", "80"}, {"X7DBT", "99", "80"}, {"PDSMU+", "98", "80"}, {"X7DVL-3", "A0", "80"}, {"X7DBU", "97", "80"}, {"X7DBN", "96", "80"}, {"X6QT8", "95", "80"}, {"H8SMI-2", "17", "11"}, {"H8DM8-2", "16", "11"}, {"H8DMR-82", "15", "11"}, {"H8DA8-2", "14", "11"}, {"H8QM8-2", "13", "11"}, {"X7DAL-E", "94", "80"}, {"PDSLM", "93", "80"}, {"X7DBR-3", "92", "80"}, {"PDSME+", "91", "80"}, {"X7DB8-X", "90", "80"}, {"X7DBP-8", "89", "80"}, {"X7DBX", "88", "80"}, {"PDSBA", "87", "80"}, {"X7DVL", "86", "80"}, {"H8DC8", "12", "11"}, {"PDSML", "85", "80"}, {"H8DCR-3", "11", "11"}, {"X7DBR-8+", "84", "80"}, {"X7DBP-X", "83", "80"}, {"PDSMI-LN4", "82", "80"}, {"X7DA8", "81", "80"}, {"X7DB8", "80", "80"}};

    public IPMIOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void CMD____________() {
    }

    public IPMIMessage clearChassisIntrusionCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)3, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage gracefulPowerControlCommand(byte param) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isUIDPresentCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)16, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableUIDLEDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)13, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage disableUIDLEDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)14, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSensorsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)17, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getProductIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)33, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setProductIDCommand(byte[] productID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, 0, 2, 0, 0, 0, 0, 0};
        data[0] = productID[1];
        data[1] = productID[0];
        ipmiMessage.setCommandAndData((byte)-64, (byte)32, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getProductID_P8_Command() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)33, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSIMxxLanDriverCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)20, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage checkNoVMandWebCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)39, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isOEMCommandSupported(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)41, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isOfficeBladeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)65, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isBackupAndRestoreFuncExistCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)40, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFanSpeedModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setFanSpeedModeCommand(byte value) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, value};
        ipmiMessage.setCommandAndData((byte)-64, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFanSpeedModeCapabilityCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2};
        ipmiMessage.setCommandAndData((byte)-64, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFirmwareBuildCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-8, (byte)9, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBIOSVerCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-84, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBIOSDateCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-84, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBIOSDateCommand2() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-84, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLAN2MACCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-97, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage calculateMCUUpdateStatus() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{107};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCPLDUpdatePercentage() {
        byte[] data = new byte[]{-127, 1};
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setMERecoveryRetryFlagCommand(boolean isRetry) {
        byte[] data = new byte[]{-57, 1, isRetry ? (byte)0 : 1};
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearSyslogCommand() {
        byte[] data = new byte[]{-4, 0, 0, 0, 2};
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMultiNodeStatusCommand() {
        byte[] data = new byte[]{50, 0};
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setMultiNodeStatusCommand(byte enable) {
        byte[] data = new byte[]{50, 1};
        data[2] = enable;
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCPUIDCommand() {
        byte[] data = new byte[]{106, 0, 5, 5, -95, 0, 0, 0, 0};
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void API____________() {
    }

    public boolean gracefulPowerCycle() {
        byte command = 3;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerCycle");
        return false;
    }

    public boolean gracefulPowerReset() {
        byte command = 2;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerReset");
        return false;
    }

    public boolean gracefulPowerShutDown() {
        byte command = 1;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerShutDown");
        return false;
    }

    public boolean clearChassisIntrusion() {
        IPMIMessage resMessage = this.clearChassisIntrusionCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute clear chassis intrusion command");
        return false;
    }

    public boolean enableUIDLED() {
        IPMIMessage resMessage = this.enableUIDLEDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute enable UID LED");
        return false;
    }

    public boolean disableUIDLED() {
        IPMIMessage resMessage = this.disableUIDLEDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute disable UID LED");
        return false;
    }

    public boolean isUIDPresent() {
        IPMIMessage resMessage = this.isUIDPresentCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isUIDPresent");
        return false;
    }

    public byte[] getProductID() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        IPMIMessage resMessage = IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) ? this.getProductID_P8_Command() : this.getProductIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[]{resMessage.data[0], resMessage.data[1]};
                return bytes;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Product ID");
        return null;
    }

    public byte getNumberOfMacBy3021() {
        IPMIMessage resMessage = this.getProductIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte number = (byte)(resMessage.data[3] & 7);
                return number;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Product ID");
        return 0;
    }

    public byte[] getSystemMACAddress() {
        IPMIMessage resMessage = this.getProductIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[]{resMessage.data[4], resMessage.data[5], resMessage.data[6], resMessage.data[7], resMessage.data[8], resMessage.data[9]};
                return bytes;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get System MAC address");
        return null;
    }

    public byte getOtherSystemMacNumber() throws Exception {
        IPMIMessage resMessage = null;
        try {
            resMessage = this.getLAN2MACCommand();
        }
        catch (Exception e) {
            return 0;
        }
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get System MAC2 address");
        return 0;
    }

    public byte[] getOtherSystemMacAddress() throws Exception {
        IPMIMessage resMessage = null;
        try {
            resMessage = this.getLAN2MACCommand();
        }
        catch (Exception e) {
            return null;
        }
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                int length = resMessage.data[0] * 6;
                byte[] address = new byte[length];
                System.arraycopy(resMessage.data, 1, address, 0, length);
                return address;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get System MAC2 address");
        return null;
    }

    public byte[] getOtherSystemMacAddressByIndex(int index) throws Exception {
        byte number;
        IPMIMessage resMessage = null;
        try {
            resMessage = this.getLAN2MACCommand();
            number = this.getOtherSystemMacNumber();
        }
        catch (Exception e) {
            return null;
        }
        if (index > number - 1) {
            return null;
        }
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] address = new byte[6];
                System.arraycopy(resMessage.data, 1 + index * 6, address, 0, 6);
                return address;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get System MAC2 address");
        return null;
    }

    public boolean setProductID(byte[] productID) {
        IPMIMessage resMessage = this.setProductIDCommand(productID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set Product ID");
        return false;
    }

    public byte[] getBoardModelByte() {
        byte[] productID = this.getProductID();
        return productID;
    }

    public static String getBoardModel(byte[] productID) {
        int i;
        boolean flag = false;
        if (productID != null) {
            for (i = 0; i < idToBoard.length; ++i) {
                if (ByteUtility.hexToBytes(idToBoard[i][1])[0] != productID[1] || ByteUtility.hexToBytes(idToBoard[i][2])[0] != productID[0]) continue;
                flag = true;
                return idToBoard[i][0];
            }
        } else {
            return null;
        }
        if (!flag) {
            for (i = 0; i < idToBoard.length; ++i) {
                if (ByteUtility.hexToBytes(idToBoard[i][1])[0] != productID[0] || ByteUtility.hexToBytes(idToBoard[i][2])[0] != productID[1]) continue;
                flag = true;
                return idToBoard[i][0];
            }
        }
        return null;
    }

    public String getBoardModel() {
        byte[] productID = this.getProductID();
        if (productID == null) {
            return "";
        }
        if (productID[0] == -68 && productID[1] == 17) {
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.getIPMIInterface());
            byte[] guid = ipmiMessagingCommand.getSystemGUID();
            if (IPMIMessagingCommand.isATENGUID(guid)) {
                return "H8DG6/i-F";
            }
            return "BHQG6/E";
        }
        return IPMIOEMCommand.getBoardModel(productID);
    }

    public String getBoardModelWebLink() {
        byte[] productID = this.getProductID();
        return this.getBoardModelLink(productID);
    }

    public String getBoardModelLink(byte[] productID) {
        int i;
        boolean flag = false;
        if (productID != null) {
            for (i = 0; i < idToBoard.length; ++i) {
                if (ByteUtility.hexToBytes(idToBoard[i][1])[0] != productID[0] || ByteUtility.hexToBytes(idToBoard[i][2])[0] != productID[1]) continue;
                flag = true;
                if (idToBoard[i].length == 4) {
                    return idToBoard[i][3];
                }
                return null;
            }
        } else {
            return null;
        }
        if (!flag) {
            for (i = 0; i < idToBoard.length; ++i) {
                if (ByteUtility.hexToBytes(idToBoard[i][1])[0] != productID[1] || ByteUtility.hexToBytes(idToBoard[i][2])[0] != productID[0]) continue;
                flag = true;
                if (idToBoard[i].length == 4) {
                    return idToBoard[i][3];
                }
                return null;
            }
        }
        return null;
    }

    public byte[] getSensors() {
        IPMIMessage resMessage = this.getSensorsCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Sensors");
        return null;
    }

    public byte[] getSIMxxLanDriver() {
        IPMIMessage resMessage = this.getSIMxxLanDriverCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get getSIMxxLanDriver");
        return null;
    }

    public boolean checkNoVMAndWeb() {
        IPMIMessage resMessage = this.checkNoVMandWebCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute checkNoVMandWebCommand");
        return false;
    }

    public boolean isOfficeBlade() {
        IPMIMessage resMessage = this.isOfficeBladeCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isOfficeBlade");
        return false;
    }

    public boolean isBackupAndRestoreFuncExist() {
        IPMIMessage resMessage = this.isBackupAndRestoreFuncExistCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isBackupAndRestoreFuncExist");
        return false;
    }

    public boolean backupConfiguration(File selFile, boolean isEncrypt) throws IPMIException, IOException {
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        byte[] configData = config.backupConfiguration();
        byte[] configCRC = config.getconfigCRC();
        AbstractInterruptibleChannel wChannel = null;
        FileOutputStream fos = null;
        try {
            byte[] data = new byte[configData.length + configCRC.length];
            System.arraycopy(configData, 0, data, 0, configData.length);
            System.arraycopy(configCRC, 0, data, configData.length, configCRC.length);
            if (isEncrypt) {
                data = config.encrypt(data);
            }
            fos = new FileOutputStream(selFile, false);
            wChannel = fos.getChannel();
            ((FileChannel)wChannel).write(ByteBuffer.wrap(data));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                fos.close();
                wChannel.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public boolean restoreConfiguration(File selFile, boolean isDecrypt, byte restoreOption) throws IPMIException, IOException {
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        if (selFile.length() > Integer.MAX_VALUE) {
            throw new IOException("File size is more than Integer.MAX_VALUE" + selFile.length());
        }
        byte[] inputs = new byte[(int)selFile.length()];
        byte[] configCRC = null;
        byte[] configData = null;
        InputStream is = null;
        try {
            int offset;
            int numRead = 0;
            is = new FileInputStream(selFile);
            for (offset = 0; offset < inputs.length && (numRead = is.read(inputs, offset, inputs.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < inputs.length) {
                throw new IOException("Could not completely read file " + selFile.getName());
            }
            if (isDecrypt) {
                inputs = config.decrypt(inputs);
            }
            configCRC = new byte[4];
            configData = new byte[inputs.length - 4];
            System.arraycopy(inputs, 0, configData, 0, configData.length);
            System.arraycopy(inputs, inputs.length - 4, configCRC, 0, 4);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return config.restoreConfiguration(configData, configCRC, true, restoreOption);
    }

    public void listDecryptedConfigurationFile(File selFile) throws IPMIException, IOException {
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        if (selFile.length() > Integer.MAX_VALUE) {
            throw new IOException("File size is more than Integer.MAX_VALUE" + selFile.length());
        }
        byte[] inputs = new byte[(int)selFile.length()];
        byte[] configCRC = null;
        byte[] configData = null;
        InputStream is = null;
        try {
            int offset;
            int numRead = 0;
            is = new FileInputStream(selFile);
            for (offset = 0; offset < inputs.length && (numRead = is.read(inputs, offset, inputs.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < inputs.length) {
                throw new IOException("Could not completely read file " + selFile.getName());
            }
            inputs = config.decrypt(inputs);
            configCRC = new byte[4];
            configData = new byte[inputs.length - 4];
            System.arraycopy(inputs, 0, configData, 0, configData.length);
            System.arraycopy(inputs, inputs.length - 4, configCRC, 0, 4);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        System.out.println(new String(configData));
        System.out.println("CRC= " + ByteUtility.bytesToHex(configCRC));
    }

    public boolean syncCMMCoinfiguration() throws IPMIException {
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        return config.syncCMMConfiguration();
    }

    public boolean isVLANCommandSupported() {
        IPMIMessage resMessage = this.isOEMCommandSupported((byte)1);
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[0] == 1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isOEMCommandSupported");
        return false;
    }

    public NetworkInfo createNetworkInfo() {
        return new NetworkInfo();
    }

    public byte getFANSpeedMode() throws IPMIException {
        IPMIMessage resMessage = this.getFanSpeedModeCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getFanSpeedModeCommand failed");
    }

    public void setFANSpeedMode(byte value) throws IPMIException {
        IPMIMessage resMessage = this.setFanSpeedModeCommand(value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setFanSpeedModeCommand failed");
    }

    public byte getFANSpeedModeCapability() throws IPMIException {
        IPMIMessage resMessage = this.getFanSpeedModeCapabilityCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data != null && resMessage.data.length == 1) {
                    return resMessage.data[0];
                }
                throw new IPMIException("Call getFanSpeedModeCommand failed (Not supported Command)");
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getFanSpeedModeCommand failed");
    }

    public byte[] getFirmwareBuild() throws IPMIException {
        IPMIMessage resMessage = null;
        try {
            resMessage = this.getFirmwareBuildCommand();
        }
        catch (Exception e) {
            return null;
        }
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] date = new byte[10];
                System.arraycopy(resMessage.data, 20, date, 0, date.length);
                return date;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getFirmwareBuildCommand failed");
    }

    public byte[] getBiosVer() throws IPMIException {
        IPMIMessage resMessage = null;
        try {
            resMessage = this.getBIOSVerCommand();
        }
        catch (Exception e) {
            return null;
        }
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data.length != 0) {
                    byte[] ver = new byte[resMessage.data.length];
                    System.arraycopy(resMessage.data, 0, ver, 0, ver.length);
                    return ver;
                }
                return null;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getBIOSVerCommand failed");
    }

    public byte[] getBiosDate() throws IPMIException {
        IPMIMessage resMessage = null;
        IPMIMessage resMessage2 = null;
        try {
            resMessage = this.getBIOSDateCommand2();
        }
        catch (Exception e) {
            return null;
        }
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] date = new byte[10];
                System.arraycopy(resMessage.data, 0, date, 0, 10);
                return date;
            }
            if (resMessage.completionCode == -57) {
                try {
                    resMessage2 = this.getBIOSDateCommand();
                }
                catch (Exception e) {
                    return null;
                }
                if (resMessage2 != null) {
                    if (resMessage2.completionCode == 0) {
                        byte[] date = new byte[10];
                        System.arraycopy(resMessage2.data, 0, date, 0, 10);
                        return date;
                    }
                    throw this.ccode2Exception(resMessage2);
                }
            } else {
                throw this.ccode2Exception(resMessage);
            }
        }
        throw new IPMIException("Call getBIOSDateCommand failed");
    }

    public IPMIMessage getAllNetworkInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)43, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAllNetworkInfoCommand(byte[] networkRawData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + networkRawData.length];
        data[0] = 1;
        System.arraycopy(networkRawData, 0, data, 1, networkRawData.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)43, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public NetworkInfo getAllNetworkInfo() throws IPMIException {
        IPMIMessage resMessage = this.getAllNetworkInfoCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            NetworkInfo networkInfo = new NetworkInfo();
            networkInfo.fromRaw(resMessage.data);
            return networkInfo;
        }
        throw new IPMIException("Call getAllNetworkInfoCommand failed");
    }

    public void setAllNetworkInfo(NetworkInfo networkInfo) throws IPMIException {
        IPMIMessage resMessage = this.setAllNetworkInfoCommand(networkInfo.toRaw());
        if (resMessage != null && resMessage.completionCode == 0) {
            return;
        }
        throw new IPMIException("Call setAllNetworkInfoCommand failed");
    }

    public boolean clearSyslog() {
        IPMIMessage resMessage = this.clearSyslogCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute clear system event log command");
        return false;
    }

    public void setMERecoveryRetry(boolean isRetry) throws IPMIException {
        IPMIMessage resMessage = this.setMERecoveryRetryFlagCommand(isRetry);
        if (resMessage != null && resMessage.completionCode == 0) {
            return;
        }
        throw new IPMIException("Call setMERecoveryRetryFlagCommand failed");
    }

    public byte getMultinodeStatus() throws IPMIException {
        IPMIMessage resMessage = this.getMultiNodeStatusCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("Call getMultiNodeStatusCommand failed");
    }

    public void setMultinodeStatus(byte isEnabled) throws IPMIException {
        IPMIMessage resMessage = this.setMultiNodeStatusCommand(isEnabled);
        if (resMessage != null && resMessage.completionCode == 0) {
            return;
        }
        throw new IPMIException("Call getMultiNodeStatusCommand failed");
    }

    public byte[] getCPUID() throws IPMIException {
        IPMIMessage resMessage = this.getCPUIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            System.out.println("ccode =" + ByteUtility.byteToHex(resMessage.completionCode));
        }
        throw new IPMIException("Call getMultiNodeStatusCommand failed");
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.16");
        config.setUserName("ADMIN");
        config.setPassword("23456");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiOEMCommand.setIPMIInterface(rmcp);
        byte[] boardModelByte = ipmiOEMCommand.getBoardModelByte();
        String boardModel = ipmiOEMCommand.getBoardModel();
        System.out.println("board model is " + ByteUtility.bytesToHex(boardModelByte) + "[" + boardModel + "]");
        System.out.println("is UID present ? " + ipmiOEMCommand.isUIDPresent());
        System.out.println("is vlan command support ? " + ipmiOEMCommand.isVLANCommandSupported());
        try {
            NetworkInfo networkInfo = ipmiOEMCommand.getAllNetworkInfo();
            System.out.println(networkInfo.toString());
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
    }

    public static void main_(String[] args) {
        byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        KIRAConfiguration k = new KIRAConfiguration(null);
        byte[] encData = k.encrypt(data);
        System.out.println("encdata =" + ByteUtility.bytesToHex(encData));
        byte[] decData = k.decrypt(encData);
        System.out.println("decdata =" + ByteUtility.bytesToHex(decData));
    }

    public class NetworkInfo {
        public byte ipSource;
        public String ip;
        public String subnet;
        public String gateway;
        public boolean isVLANEnabled;
        public int vLanID;
        byte[] raw;

        public void fromRaw(byte[] data) {
            this.ipSource = data[0];
            this.ip = (data[1] & 0xFF) + "." + (data[2] & 0xFF) + "." + (data[3] & 0xFF) + "." + (data[4] & 0xFF);
            this.subnet = (data[5] & 0xFF) + "." + (data[6] & 0xFF) + "." + (data[7] & 0xFF) + "." + (data[8] & 0xFF);
            this.gateway = (data[9] & 0xFF) + "." + (data[10] & 0xFF) + "." + (data[11] & 0xFF) + "." + (data[12] & 0xFF);
            this.vLanID = (data[13] & 0xFF) + ((data[14] & 0xF) << 8);
            if ((byte)(data[14] & 0x80) == -128) {
                this.isVLANEnabled = true;
            }
            this.raw = data;
        }

        public byte[] toRaw() {
            int index = 0;
            byte[] raw = new byte[15];
            raw[index] = this.ipSource;
            System.arraycopy(ByteUtility.ipToBytes(this.ip), 0, raw, ++index, 4);
            System.arraycopy(ByteUtility.ipToBytes(this.subnet), 0, raw, index += 4, 4);
            System.arraycopy(ByteUtility.ipToBytes(this.gateway), 0, raw, index += 4, 4);
            raw[index += 4] = (byte)this.vLanID;
            raw[++index] = (byte)(this.vLanID >> 8);
            if (this.isVLANEnabled) {
                raw[index] = (byte)(raw[index] | 0x80);
            }
            return raw;
        }

        public String toString() {
            String result = "";
            result = result + "\n IP Source = 0X" + ByteUtility.byteToHex(this.ipSource);
            result = result + "\n IP = " + this.ip;
            result = result + "\n Subnet = " + this.subnet;
            result = result + "\n gateway  = " + this.gateway;
            result = result + "\n vLanID  = " + this.vLanID;
            result = result + "\n isVlanEnable  = " + this.isVLANEnabled;
            result = result + "\n raw  = " + ByteUtility.bytesToHex(this.raw);
            return result;
        }
    }
}

