/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ASFMessage;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCP;

public class RMCPSessionController
implements ISessionController {
    IPMIMessagingCommand ipmiMessagingCommand;
    RMCP rmcp;

    @Override
    public IPMINetworkInterface startup(IPMIInterfaceConfig config) {
        this.rmcp = new RMCP();
        this.rmcp.initialize(config);
        this.ipmiMessagingCommand = new IPMIMessagingCommand(this.rmcp);
        MessageCenter.getInstance().put(this, (Object)"ASF Ping");
        ASFMessage asfPongMessage = this.ipmiMessagingCommand.asfPing();
        if (asfPongMessage != null) {
            if (asfPongMessage.supportedEntities != -127) {
                MessageCenter.getInstance().put(this, (Object)"ASF Pong message error");
                return null;
            }
        } else {
            MessageCenter.getInstance().put(this, (Object)"Connect failed");
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"ASF Pong");
        MessageCenter.getInstance().put(this, (Object)"Get Channel Authentication Capabilities");
        IPMIMessage resMessage = this.ipmiMessagingCommand.GetChannelAuthenticationCapabilitiesCommand();
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                return null;
            }
        } else {
            MessageCenter.getInstance().put(this, (Object)"Get Channel Authentication Capabilities error");
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Get Channel Authentication Capabilities finished");
        byte[] challengeString = new byte[16];
        MessageCenter.getInstance().put(this, (Object)"Get Session Challenge");
        resMessage = this.ipmiMessagingCommand.GetSessionChallengeCommand(config.getUserName());
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                switch (resMessage.completionCode) {
                    case -127: {
                        MessageCenter.getInstance().put(this, (Object)"invalid user name");
                        break;
                    }
                    case -126: {
                        MessageCenter.getInstance().put(this, (Object)"null user name (User 1) not enabled");
                        break;
                    }
                    default: {
                        MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                    }
                }
                return null;
            }
        } else {
            MessageCenter.getInstance().put(this, (Object)"Get Session Challenge Error");
            return null;
        }
        System.arraycopy(resMessage.data, 4, challengeString, 0, 16);
        MessageCenter.getInstance().put(this, (Object)"Get Session Challenge finished");
        MessageCenter.getInstance().put(this, (Object)"Activate Session");
        resMessage = this.ipmiMessagingCommand.activateSessionCommand((byte)2, config.getPrivilege(), challengeString);
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                switch (resMessage.completionCode) {
                    case -127: {
                        MessageCenter.getInstance().put(this, (Object)"No session slot available (BMC cannot accept any more sessions)");
                        break;
                    }
                    case -126: {
                        MessageCenter.getInstance().put(this, (Object)"No slot available for given user. (Limit of user sessions allowed under that name has been reached)");
                        break;
                    }
                    case -125: {
                        MessageCenter.getInstance().put(this, (Object)"No slot available to support user due to maximum privilege capability");
                        break;
                    }
                    case -124: {
                        MessageCenter.getInstance().put(this, (Object)"session sequence number out-of-range");
                        break;
                    }
                    case -123: {
                        MessageCenter.getInstance().put(this, (Object)"invalid Session ID in request");
                        break;
                    }
                    case -122: {
                        MessageCenter.getInstance().put(this, (Object)"requested maximum privilege level exceeds user and/or channel privilege limit");
                        break;
                    }
                    default: {
                        MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                    }
                }
                return null;
            }
        } else {
            MessageCenter.getInstance().put(this, (Object)"activate Session Error");
            return null;
        }
        byte[] sessionID = new byte[4];
        byte[] inboundSeq = new byte[4];
        byte authType = resMessage.data[0];
        System.arraycopy(resMessage.data, 1, sessionID, 0, 4);
        System.arraycopy(resMessage.data, 5, inboundSeq, 0, 4);
        byte maxPrivilegeLevel = resMessage.data[9];
        System.arraycopy(sessionID, 0, this.rmcp.rmcpSession.sessionID, 0, 4);
        System.arraycopy(inboundSeq, 0, this.rmcp.rmcpSession.inboundSessionSeq, 0, 4);
        MessageCenter.getInstance().put(this, (Object)"Activate Session Successfully");
        MessageCenter.getInstance().put(this, (Object)"Set Session Privilege Level");
        resMessage = this.ipmiMessagingCommand.setSessionPrivilegeLevelCommand(config.getPrivilege());
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                switch (resMessage.completionCode) {
                    case -128: {
                        MessageCenter.getInstance().put(this, (Object)"Requested level not available for this user");
                        break;
                    }
                    case -127: {
                        MessageCenter.getInstance().put(this, (Object)"Requested level exceeds Channel and/or User Privilege Limit");
                        break;
                    }
                    case -126: {
                        MessageCenter.getInstance().put(this, (Object)"Cannot disable User Level authentication");
                        break;
                    }
                    default: {
                        MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                    }
                }
                return null;
            }
        } else {
            MessageCenter.getInstance().put(this, (Object)"set Session Privilege Level Error");
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)("Set Session Privilege Level finished. Level = " + resMessage.data[0]));
        this.rmcp.rmcpSession.authType = (byte)2;
        return this.rmcp;
    }

    @Override
    public boolean closeSession() {
        if (this.ipmiMessagingCommand != null) {
            IPMIMessage resMessage = this.ipmiMessagingCommand.closeSessionCommand();
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    MessageCenter.getInstance().put(this, (Object)"Close session successfully");
                    this.rmcp.stopProxy();
                    this.closeSocket();
                    return true;
                }
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                return false;
            }
            MessageCenter.getInstance().put(this, (Object)"Close session Error");
            return false;
        }
        MessageCenter.getInstance().put("messageingCommand is null");
        return false;
    }

    public void closeSocket() {
        this.rmcp.closeSocket();
    }

    public static void main(String[] args) {
        RMCPSessionController rmcpSessionStartup = new RMCPSessionController();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.245");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        RMCP rmcp = (RMCP)rmcpSessionStartup.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        IPMIMessage resMessage = rmcpSessionStartup.ipmiMessagingCommand.getUserAccessCommand((byte)1, (byte)2);
        if (resMessage != null) {
            MessageCenter.getInstance().put("Get User Access = " + ByteUtility.bytesToHex(resMessage.data));
        }
        if ((resMessage = rmcpSessionStartup.ipmiMessagingCommand.setUserNameCommand((byte)3, "Jim")) != null) {
            MessageCenter.getInstance().put("Set userID = 0x03 , user name to \"Jim\" ");
        }
        if ((resMessage = rmcpSessionStartup.ipmiMessagingCommand.getUserNameCommand((byte)3)) != null) {
            MessageCenter.getInstance().put("Get user name 0x03 =" + new String(resMessage.data).trim());
        }
        rmcpSessionStartup.closeSession();
    }
}

