/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.smbios.TypeStruct;
import java.util.BitSet;

public class BiosInfo
extends TypeStruct {
    byte[] vendor;
    byte[] biosVersion;
    byte[] startAddress;
    byte[] releaseDate;
    byte[] romSize;
    byte[] characteristics;
    byte[] characterExtension;
    byte[] majorRelease;
    byte[] minorRelease;
    byte[] firmwareMajorRelease;
    byte[] firmwareMinorRelease;

    public BiosInfo(byte[] dataByte) {
        super(dataByte);
        this.vendor = this.getTypeLength(this.BYTE);
        this.biosVersion = this.getTypeLength(this.BYTE);
        this.startAddress = this.getTypeLength(this.WORD);
        this.releaseDate = this.getTypeLength(this.BYTE);
        this.romSize = this.getTypeLength(this.BYTE);
        this.characteristics = this.getTypeLength(this.QWORD);
        this.characterExtension = this.getTypeLength(this.length - 18 - 4);
        this.majorRelease = this.getTypeLength(this.BYTE);
        this.minorRelease = this.getTypeLength(this.BYTE);
        this.firmwareMajorRelease = this.getTypeLength(this.BYTE);
        this.firmwareMinorRelease = this.getTypeLength(this.BYTE);
        this.strFieldCount = 5;
    }

    int getVendor() {
        return this.vendor[0];
    }

    int getVersion() {
        return this.biosVersion[0];
    }

    String getStartAddress() {
        return ByteUtility.bytesToHexNoSpace(this.startAddress);
    }

    int getReleaseDate() {
        return this.releaseDate[0];
    }

    int getROMSize() {
        return 64 * ((this.romSize[0] & 0xFF) + 1);
    }

    String getCharacteristics() {
        BitSet bitSet = BitSet.valueOf(this.characteristics);
        StringBuffer sb = new StringBuffer();
        if (bitSet.get(3)) {
            return "Supported: None";
        }
        if (bitSet.get(4)) {
            sb.append(" ISA is supported \n");
        }
        if (bitSet.get(5)) {
            sb.append(" MCA is supported \n");
        }
        if (bitSet.get(6)) {
            sb.append(" EISA is supported \n");
        }
        if (bitSet.get(7)) {
            sb.append(" PCI is supported \n");
        }
        if (bitSet.get(8)) {
            sb.append(" PCMCIA is supported \n");
        }
        if (bitSet.get(9)) {
            sb.append(" PnP is supported \n");
        }
        if (bitSet.get(10)) {
            sb.append(" APM is supported \n");
        }
        if (bitSet.get(11)) {
            sb.append(" BIOS is Upgradeable \n");
        }
        if (bitSet.get(12)) {
            sb.append(" BIOS Shadowing is allowed \n");
        }
        if (bitSet.get(13)) {
            sb.append(" VL-VESA is supported \n");
        }
        if (bitSet.get(14)) {
            sb.append(" ESCD support is available \n");
        }
        if (bitSet.get(15)) {
            sb.append(" Boot from CD is supported \n");
        }
        if (bitSet.get(16)) {
            sb.append(" Selectable boot is supported \n");
        }
        if (bitSet.get(17)) {
            sb.append(" BIOS ROM is socketed \n");
        }
        if (bitSet.get(18)) {
            sb.append(" Boot from PCMCIA is supported \n");
        }
        if (bitSet.get(19)) {
            sb.append(" EDD specification is supported \n");
        }
        if (bitSet.get(20)) {
            sb.append(" (Int 13h) NEC 9800 1.2 MB is supported \n");
        }
        if (bitSet.get(21)) {
            sb.append(" (Int 13h) Toshiba 1.2 MB is supported \n");
        }
        if (bitSet.get(22)) {
            sb.append(" (Int 13h) 360 KB floppy is supported \n");
        }
        if (bitSet.get(23)) {
            sb.append(" (Int 13h) 1.2 MB floppy is supported \n");
        }
        if (bitSet.get(24)) {
            sb.append(" (Int 13h) 720 KB floppy is supported \n");
        }
        if (bitSet.get(25)) {
            sb.append(" (Int 13h) 2.88 MB floppy is supported \n");
        }
        if (bitSet.get(26)) {
            sb.append(" (Int 5h) Print screen Service is supported \n");
        }
        if (bitSet.get(27)) {
            sb.append(" (Int 9h) 8042 keyboard services are supported \n");
        }
        if (bitSet.get(28)) {
            sb.append(" (Int 14h) Serial services are supported \n");
        }
        if (bitSet.get(29)) {
            sb.append(" (Int 17h) Printer services are supported \n");
        }
        if (bitSet.get(30)) {
            sb.append(" (Int 10h) CGA/Mono Video Services are supported \n");
        }
        if (bitSet.get(31)) {
            sb.append(" NECPC-98 \n");
        }
        return sb.toString();
    }

    String getCharacterExtension() {
        StringBuffer sb = new StringBuffer();
        if (this.characterExtension.length > 0) {
            BitSet Byte1 = BitSet.valueOf(new byte[]{this.characterExtension[0]});
            if (Byte1.get(0)) {
                sb.append(" ACPI is supported \n");
            }
            if (Byte1.get(1)) {
                sb.append(" USB Legacy is supported \n");
            }
            if (Byte1.get(2)) {
                sb.append(" AGP is supported \n");
            }
            if (Byte1.get(3)) {
                sb.append(" I2O boot is supported \n");
            }
            if (Byte1.get(4)) {
                sb.append(" LS-120 SuperDisk boot is supported \n");
            }
            if (Byte1.get(5)) {
                sb.append(" ATAPI ZIP drive boot is supported \n");
            }
            if (Byte1.get(6)) {
                sb.append(" 1394 boot is supported \n");
            }
            if (Byte1.get(7)) {
                sb.append(" Smart battery is supported \n");
            }
        }
        if (this.characterExtension.length > 1) {
            BitSet Byte2 = BitSet.valueOf(new byte[]{this.characterExtension[1]});
            if (Byte2.get(0)) {
                sb.append(" BIOS Boot Specification is supported \n");
            }
            if (Byte2.get(1)) {
                sb.append(" Function key network service boot is supported \n");
            }
            if (Byte2.get(2)) {
                sb.append(" Targeted content distribution Enabled \n");
            }
            if (Byte2.get(3)) {
                sb.append(" UEFI Specification is supported \n");
            }
            if (Byte2.get(4)) {
                sb.append(" SMBIOS table describes a virtual machine \n");
            }
        }
        return sb.toString();
    }

    String getBIOSRevision() {
        String majorStr = ByteUtility.byteToHex(this.majorRelease[0]);
        String minorStr = ByteUtility.byteToHex(this.minorRelease[0]);
        if ("FF".equalsIgnoreCase(majorStr) || "FF".equalsIgnoreCase(minorStr)) {
            return "Not Support (0x" + majorStr + minorStr + ")";
        }
        return this.majorRelease[0] + "." + this.minorRelease[0];
    }

    String getFirmwareRevision() {
        if ((this.firmwareMajorRelease[0] & 0xFF) == 255 || (this.firmwareMinorRelease[0] & 0xFF) == 255) {
            return "Not Support";
        }
        return this.firmwareMajorRelease[0] + "." + this.firmwareMinorRelease[0];
    }

    public String[] getBIOSVersion() {
        return new String[]{"Version", this.strField[this.getVersion()] != null ? this.strField[this.getVersion()] : "N/A"};
    }

    public String[] getBiosReleaseDate() {
        return new String[]{"Release Date", this.strField[this.getReleaseDate()] != null ? this.strField[this.getReleaseDate()] : "N/A"};
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Type", (this.type & 0xFF) + " (0x" + this.getType() + ")"));
        fStr.append(String.format(format, "Structure", "BIOS Information"));
        if (this.debug) {
            fStr.append(String.format(format, "Length", (this.length & 0xFF) + " (0x" + this.getLength() + ")"));
            fStr.append(String.format(format, "Handle", "0x" + this.getHandle()));
        }
        fStr.append(String.format(format, "Vendor", this.strField[this.getVendor()] != null ? this.strField[this.getVendor()] : "N/A"));
        fStr.append(String.format(format, "BIOS Version", this.strField[this.getVersion()] != null ? this.strField[this.getVersion()] : "N/A"));
        if (this.debug) {
            fStr.append(String.format(format, "Start Address", "0x" + this.getStartAddress()));
        }
        fStr.append(String.format(format, "Release Date", this.strField[this.getReleaseDate()] != null ? this.strField[this.getReleaseDate()] : "N/A"));
        fStr.append(String.format(format, "ROM Size", this.getROMSize() + " KB"));
        if (this.debug) {
            fStr.append(String.format(format, "BIOS Revision", this.getBIOSRevision()));
            fStr.append(String.format(format, "Firmware Revision", this.getFirmwareRevision()));
            fStr.append(String.format("---------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(" Characteristics: \n", new Object[0]));
            fStr.append(String.format("---------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(this.getCharacteristics(), new Object[0]));
            fStr.append(String.format("---------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(" Characteristics Extension: \n", new Object[0]));
            fStr.append(String.format("---------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(this.getCharacterExtension(), new Object[0]));
            fStr.append(String.format("\n", new Object[0]));
        }
        return fStr.toString();
    }
}

