/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class DeployCheckCommand
extends SuperBladeCommand {
    String isoFilename = "";

    @Override
    public boolean preValidate() {
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        MOut.G(this).println("Collecting information for all blades ...");
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        for (int i = 0; i < bladeSystem.getBlades().length; ++i) {
            String ip = null;
            BladeEntity bladeEntity = bladeSystem.getBlades()[i];
            if (bladeEntity.getPresent() == 0) continue;
            if (bladeEntity.isSimCardDetectPin()) {
                this.ipmiCMMOEMCommand.setEnabledNormalFunction(false);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ip = this.getSIMBLIP(i);
                this.ipmiCMMOEMCommand.setEnabledNormalFunction(true);
                if (ip == null) {
                    MOut.G(this).println("Blade " + (i + 1) + ", IP = NONE");
                } else {
                    MOut.G(this).print("Blade " + (i + 1) + ", IP =" + ip);
                }
            }
            if (ip == null) continue;
            String username = this.config.getUserName();
            String password = this.config.getPassword();
            IPMIInterfaceConfig lanConfig = new IPMIInterfaceConfig();
            lanConfig.setUserName(username);
            lanConfig.setPassword(password);
            lanConfig.setIp(ip);
            boolean result = this.checkLogin(lanConfig);
            if (result) {
                MOut.G(this).println(", Test login OK");
                continue;
            }
            MOut.G(this).println(", Test login failed");
        }
        this.ipmiCMMOEMCommand.setEnabledNormalFunction(true);
    }

    public String getSIMBLIP(int i) {
        String ip;
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel((byte)(i + 1));
        if (this.sessionController != null && (ip = ipmiLanCommand.getIP()) != null) {
            return ip;
        }
        return null;
    }

    public boolean checkLogin(IPMIInterfaceConfig lanConfig) throws IPMIException {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(lanConfig, ipmiMessagingCommand);
        if (sessionController != null && ipmiMessagingCommand.getIPMIInterface() != null) {
            sessionController.closeSession();
            return true;
        }
        return false;
    }
}

