/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ATENFlash;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;

public class IPMIFlashATENCommand
extends SuperBladeCommand {
    String options;

    @Override
    public boolean preValidate() {
        this.options = null;
        if (this.parameters == null) {
            MOut.G(this).println("firmware filename is needed");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        if (this.parameters.length > 1) {
            for (int i = 1; i < this.parameters.length; ++i) {
                this.options = this.options + this.parameters[i] + " ";
            }
        }
        return true;
    }

    public boolean checkIfSupportedDevice() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        return IPMIMessagingCommand.isATENGUID(guid);
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.checkIfSupportedDevice()) {
            MOut.G(this).println("Not a supported device");
            MOut.G(this).println("This command is used for updating X8 and X9 BMC firmware (*.bin)");
            this.statusCode = 153;
            return;
        }
        if (this.options != null && this.options.toLowerCase().indexOf("-ver") != -1) {
            this.showFirmwareVer(this.parameters[0]);
            return;
        }
        boolean result = false;
        ATENFlash atenFlash = new ATENFlash();
        atenFlash.setMOut(MOut.G(this));
        MOut.G(this).println("**************************************************************");
        MOut.G(this).println("WARNING!");
        MOut.G(this).println("Firmware upgrade must not be interrupted once it is started.");
        MOut.G(this).println("Once you get error after Upgrading, please use local KCS tool");
        MOut.G(this).println("for recovery.(DOS:dupdate.exe, Linux:lupdate or ");
        MOut.G(this).println("Windows:wupdate.exe ) ");
        MOut.G(this).println("**************************************************************");
        result = atenFlash.flash(this.config.getIp(), this.config.getUserName(), this.config.getPassword(), this.parameters[0]);
        this.statusCode = result ? 0 : 149;
    }

    public void showFirmwareVer(String name) {
        ATENFlash atenFlash = new ATENFlash();
        try {
            String ver = atenFlash.checkFirmwareVersion(name);
            MOut.G(this).println(ver);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
        }
        this.statusCode = 0;
    }
}

