/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class IPMIOEMRadiusCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte authentication;
    private byte[] port;
    private byte[] ip;
    private byte[] secret;
    private String usage = "Usage: ipmi oem x10cfg radius [<authentication> <port> <ip address> <secret>]\nFor authentication:\nOn  : 1\nOff : 0\n* The port number should be 1-65535";

    @Override
    public boolean preValidate() {
        int tempPort;
        if (this.parameters == null) {
            return true;
        }
        if (this.parameters.length != 4) {
            MOut.G(this).println(this.usage);
            return false;
        }
        try {
            this.authentication = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("authentication should be number");
            MOut.G(this).println(this.usage);
            return false;
        }
        if (this.authentication < 0 || this.authentication > 1) {
            MOut.G(this).println("authentication should be 0 or 1");
            MOut.G(this).println(this.usage);
            return false;
        }
        try {
            tempPort = Integer.parseInt(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("port should be number");
            MOut.G(this).println(this.usage);
            return false;
        }
        if (tempPort < 1 || tempPort > 65535) {
            MOut.G(this).println("port should be 1-65535");
            MOut.G(this).println(this.usage);
            return false;
        }
        this.port = new byte[2];
        ByteUtility.intTo2Bytes(this.port, 0, tempPort);
        try {
            String IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
            if (!Pattern.compile(IPV4_REGEX).matcher(this.parameters[2]).matches()) {
                throw new NumberFormatException();
            }
            this.ip = ByteUtility.ipToBytes(this.parameters[2]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("ip address should be ###.###.###.###");
            MOut.G(this).println(this.usage);
            return false;
        }
        this.secret = this.parameters[3].getBytes();
        if (this.secret.length > 255) {
            MOut.G(this).println("Secret should less then 255 characters");
            MOut.G(this).println(this.usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            byte[] params = ipmiOEMWebSettingCommand.getRadius((byte)0);
            byte[] secret = ipmiOEMWebSettingCommand.getLdap((byte)1);
            String formatServer = " %-50s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatServer, "Item", "Value"));
            header.append(String.format(formatServer, "----", "-----"));
            MOut.G(this).printf(formatServer, "RADIUS Authentication", params[0] == 1 ? "On" : "Off");
            MOut.G(this).printf(formatServer, "Port", ByteUtility.twoBytesToIntLSB(ByteUtility.getBytes(params, 1, 2)));
            MOut.G(this).printf(formatServer, "IP Address", (params[3] & 0xFF) + "." + (params[4] & 0xFF) + "." + (params[5] & 0xFF) + "." + (params[6] & 0xFF));
            MOut.G(this).printf(formatServer, "Secret", secret == null ? "" : new String(secret).trim());
            this.statusCode = 0;
            MOut.G(this).println("\n" + this.usage);
            return;
        }
        ByteBuffer target = ByteBuffer.allocate(7);
        target.put(this.authentication);
        target.put(this.port);
        target.put(this.ip);
        if (!ipmiOEMWebSettingCommand.setRadius((byte)0, target.array())) {
            MOut.G(this).println("Set RADIUS parameters failed");
            this.statusCode = 149;
            return;
        }
        target = ByteBuffer.allocate(this.secret.length + 1);
        target.put(this.secret);
        target.put((byte)0);
        if (!ipmiOEMWebSettingCommand.setRadius((byte)1, target.array())) {
            MOut.G(this).println("Set secret failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

