/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMDelPolicyCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        byte id;
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        if (this.parameters == null || this.parameters.length < 1) {
            MOut.G(this).println("delPolicy <id>");
            this.statusCode = 0;
            return;
        }
        try {
            id = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMIDCMOEMCommand.NodeManagerPolicy policy = null;
        try {
            policy = ipmiDCMOEMCommand.getNodeManagerPolicy((byte)0, id);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = ex.getMessage().contains("Invalid") ? 0 : 148;
            return;
        }
        IPMIDCMOEMCommand.NodeManagerPolicySetting policySetting = ipmiDCMOEMCommand.createNodeManagerPolicySetting();
        policySetting.domainID = 0;
        policySetting.policyID = id;
        policySetting.policyConfig = 0;
        policySetting.PolicyException = policy.policyException;
        policySetting.powerLimit = policy.powerLimit;
        policySetting.correctionTimeLimit = policy.correctionTimeLimit;
        policySetting.policyTriggerLimit = policy.policyTriggerLimit;
        policySetting.statisticsReportingPeriod = policy.statisticsReportingPeriod;
        try {
            ipmiDCMOEMCommand.setNodeManagerPolicy(policySetting);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

