/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.BladeFileDumpCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NodeSysLogCommand
extends SuperBladeCommand {
    String path = "/nv/system_elog";
    int readableSize = 512;

    @Override
    public void runCommand() throws Exception {
        BladeFileDumpCommand bladeFileDumpCommand = new BladeFileDumpCommand(null);
        bladeFileDumpCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] filePath = this.path.getBytes();
        bladeFileDumpCommand.openTextFile(filePath);
        long totalLength = 0L;
        int count = 0;
        while (totalLength == 0L) {
            totalLength = bladeFileDumpCommand.getFileLength();
            if (totalLength == 0L) {
                ++count;
                Thread.sleep(3000L);
            }
            if (count <= 2) continue;
            bladeFileDumpCommand.closeFile();
            MOut.G(this).print("File is busy by generating.");
            this.statusCode = 0;
        }
        int offset = 0;
        for (long remainLength = totalLength; remainLength > 0L; remainLength -= (long)this.readableSize) {
            byte[] data = null;
            data = remainLength > (long)this.readableSize ? bladeFileDumpCommand.readFile(offset, this.readableSize) : bladeFileDumpCommand.readFile(offset, (int)remainLength);
            String eventLog = new String(data);
            if (offset == 0) {
                eventLog = eventLog.substring(eventLog.indexOf(10) + 1);
            }
            MOut.G(this).print(eventLog);
            offset += this.readableSize;
        }
        bladeFileDumpCommand.closeFile();
        this.statusCode = 0;
    }
}

