/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import nn.pp.rc.CustomCursor;
import nn.pp.rc.GenericTimer;
import nn.pp.rc.MouseHandler;
import nn.pp.rc.T;

public class MouseHandlerRelative
extends MouseHandler {
    private static Robot robot = null;
    private Object mousemtx = new Object();
    private int dx;
    private int dy;
    private int oldPointerMask = 0;
    private boolean handleMouse = false;
    private CustomCursor cursors;
    private PrintStream logger;
    private String synckey;
    private boolean toldUser = false;

    public MouseHandlerRelative(Component comp, CustomCursor cursors, PrintStream logger, String synckey) throws AWTException, SecurityException {
        super(comp);
        this.cursors = cursors;
        this.logger = logger;
        this.synckey = synckey;
        if (robot == null) {
            robot = new Robot();
        }
        new GenericTimer(50, this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMouseEvent(MouseEvent me) {
        int eID = me.getID();
        if (!this.handleMouse) {
            if (eID == 502) {
                this.handleMouse = true;
                this.comp.setCursor(this.cursors.getCursor((String)"Transparent").cursor);
                this.logger.println(MessageFormat.format(T._("Single mouse mode entered, press {0} to leave"), this.synckey));
            } else if (!this.toldUser) {
                this.logger.println(T._("Single mouse mode (click into screen to start)"));
                this.toldUser = true;
            }
            return;
        }
        switch (eID) {
            case 501: {
                this.comp.requestFocus();
            }
            case 502: {
                this.writeMouseRelative();
                this.oldPointerMask = this.getPointerMask(me);
                try {
                    this.proto.writePointerEvent(true, 0, 0, 0, this.oldPointerMask);
                }
                catch (IOException e) {
                    System.out.println("Could not write relative MouseEvent: " + e.getMessage());
                }
                break;
            }
            case 505: {
                this.handleMouseSyncKey();
                break;
            }
            case 504: {
                this.clearPointerMask();
                break;
            }
            case 503: 
            case 506: {
                Dimension dim = this.comp.getSize();
                int compZeroX = dim.width / 2;
                int compZeroY = dim.height / 2;
                Point pos = this.comp.getLocationOnScreen();
                int scrZeroX = pos.x + compZeroX;
                int scrZeroY = pos.y + compZeroY;
                if (me.getX() != compZeroX || me.getY() != compZeroY) {
                    Object object = this.mousemtx;
                    synchronized (object) {
                        this.dx += me.getX() - this.oldPos.x;
                        this.dy += me.getY() - this.oldPos.y;
                    }
                    robot.mouseMove(scrZeroX, scrZeroY);
                }
                this.oldPos.x = me.getX();
                this.oldPos.y = me.getY();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.writeMouseRelative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMouseRelative() {
        if (this.dx == 0 && this.dy == 0 || this.proto == null) {
            return;
        }
        Object object = this.mousemtx;
        synchronized (object) {
            try {
                this.proto.writePointerEvent(true, this.dx, this.dy, 0, this.oldPointerMask);
            }
            catch (IOException e) {
                System.out.println("Could not write relative MouseEvent: " + e.getMessage());
            }
            this.dy = 0;
            this.dx = 0;
        }
    }

    @Override
    public boolean needMouseHandling() {
        return false;
    }

    @Override
    public void handleMouseSyncKey() {
        this.handleMouse = false;
        this.comp.setCursor(this.cursors.getCurrentCursor().cursor);
        this.logger.println(T._("Single mouse mode left, click to control mouse again"));
    }

    @Override
    public int getPointerMask() {
        return this.oldPointerMask;
    }
}

