/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import nn.pp.rc.ErlaConnector;
import nn.pp.rc.MonitoringDataInputStream;
import nn.pp.rc.MonitoringOutputStream;
import nn.pp.rc.RCProto;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.T;
import nn.pp.rc.VideoSettings;

public abstract class RFBproto
extends ErlaConnector
implements RCProto {
    private static final boolean debug = false;
    final String versionMsgPrefix = "e-RIC RFB ";
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int Quit = 3;
    static final int UTFString = 7;
    static final int KbdLayout = 9;
    static final int OsdState = 16;
    static final int CapabilityTable = 18;
    static final int AuthCaps = 32;
    static final int SessionChallenge = 33;
    static final int AuthAck = 34;
    static final int ServerCutText = 3;
    static final int ServerFbFormat = 128;
    static final int SystemInfo = 129;
    static final int PasswordChangeReply = 130;
    static final int ConsoleMessage = 131;
    static final int ServerCommand = 132;
    static final int SasEventMsg = 133;
    static final int SasErrorMsg = 134;
    static final int SpTimestamp = 136;
    static final int SetPixelFormat = 0;
    static final int FixColourMapEntries = 1;
    static final int SetEncodings = 2;
    static final int FramebufferUpdateRequest = 3;
    static final int KeyboardEvent = 4;
    static final int PointerEvent = 5;
    static final int ScancodeEvent = 6;
    static final int AckPixelFormat = 19;
    static final int Login = 32;
    static final int ChallengeResponse = 33;
    static final int SystemInfoRequest = 128;
    static final int TriggerHostReset = 129;
    static final int TriggerHostPower = 130;
    static final int SetKeyboardMapping = 131;
    static final int PasswordChangeRequest = 132;
    static final int MouseStateEvent = 133;
    static final int MouseSyncEvent = 134;
    static final int UserPropChangeEvent = 135;
    static final int CursorChangeEvent = 136;
    static final int PointerEventRelative = 147;
    static final int PingRequest = 148;
    static final int PingReply = 149;
    static final int BandwidthRequest = 150;
    static final int BandwidthTick = 151;
    static final int VideoSettingsEventS2C = 8;
    static final int VideoQualityEventS2C = 17;
    static final int KvmSwitchEvent = 137;
    static final int VideoSettingsEventC2S = 144;
    static final int VideoSettingsRequest = 145;
    static final int VideoRefresh = 146;
    static final int VideoQualityEventC2S = 152;
    static final int VideoQualityRequest = 153;
    static final byte VSRequestNow = 1;
    static final byte VSRequestRefuse = 2;
    static final int RCModeRequest = 160;
    static final int RCModeReply = 161;
    static final int SpSetCimId = 161;
    static final int SpSetSession = 162;
    static final int SpCommand = 163;
    static final int SpSetSessionTimes = 164;
    static final byte RDPEnter = 0;
    public static final byte RDPLeave = 1;
    static final byte RDPEntered = 0;
    static final byte RDPLeft = 1;
    static final byte RDPNotAvailable = 2;
    static final int QuitNoPerm = 1;
    static final int QuitExclAccess = 2;
    static final int QuitRejected = 3;
    static final int QuitNoSrvPasswd = 4;
    static final int QuitLoopback = 5;
    static final int QuitAuthFailed = 6;
    static final int QuitKVMPortDenied = 7;
    static final int QuitTooManyClients = 8;
    static final int QuitUnexpected = 16;
    static final int QuitBadProtoVer = 17;
    static final int QuitProtoError = 18;
    static final int QuitInternalError = 19;
    static final int QuitWrongReplayParameter = 20;
    static final int AuthHttpSessId = 1;
    static final int AuthPlain = 2;
    static final int AuthMD5 = 4;
    static final int ConnectionFlagSasHw = 1;
    static final int ConnectionFlagSasSw = 2;
    static final int ConnectionFlagSp = 4;
    static final int ConnectionFlagSasLocalOnly = 8;
    static final int ConnectionFlagSasKbdShift = 4;
    static final int ConnectionFlagSasKbdMask = 3;
    static final int ConnectionFlagSasKbdNormal = 0;
    static final int ConnectionFlagSasKbdNoKbd = 1;
    static final int ConnectionFlagSasKbdFilter = 2;
    static final int ConnectionFlagSasKbdAllFilterPb = 3;
    static final int FbUpdateFlagTimestamp = 1;
    static final int EncodingAuto = 0;
    static final int EncodingFix = 1;
    static final int EncodingAdvanced = 2;
    static final String DefaultSelectedEncoding = "auto";
    static final String DefaultFixEncoding = "videohi";
    static final String DefaultEncodingAdvCR = "video";
    static final String DefaultEncodingAdvCD = "color_16bpp";
    static final int EncodingMask = 255;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingUseTightCache = 9;
    static final int EncodingRawVSC = 10;
    static final int EncodingLRLESoft = 11;
    static final int EncodingJpeg = 12;
    static final int EncodingLRLEHard = 128;
    static final int EncodingDCT = 129;
    static final int EncodingIsHW = 128;
    static final int EncodingAutomaticSW = 127;
    static final int EncodingAutomaticHW = 255;
    static final int EncodingParamZLIBShift = 8;
    static final int EncodingParamZLIBMask = 3840;
    static final int EncodingParamSubencShift = 12;
    static final int EncodingParamSubencMask = 61440;
    static final int EncodingParamVideoOptShift = 16;
    static final int EncodingParamVideoOptMask = 65536;
    static final int EncodingParamCompressShift = 17;
    static final int EncodingParamCompressMask = 131072;
    static final int RawVscIsVsc = 1;
    static final int RawVscUseServersPixelFormat = 2;
    static final int RawVscBigEndian = 4;
    static final int HextileRaw = 1;
    static final int HextileBackgroundSpecified = 2;
    static final int HextileForegroundSpecified = 4;
    static final int HextileAnySubrects = 8;
    static final int HextileSubrectsColoured = 16;
    static final int TightStreamId = 3;
    static final int TightExplicitFilter = 7;
    static final int TightFill = 8;
    static final int TightCheckForXBitFullColor = 8;
    static final int Tight1BitFullColorBlackWhite = 10;
    static final int Tight2BitFullColorGrayscale = 11;
    static final int Tight4BitFullColorGrayscale = 12;
    static final int Tight4BitFullColor16Colors = 13;
    static final int TightFillXBit = 15;
    static final int TightMaxSubencoding = 15;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    static final int TightMinToCompress = 12;
    static final int TightMaxRectSize = 65536;
    static final int Tight1BitBlackWhite = 1;
    static final int Tight2BitGrayscale = 2;
    static final int Tight4BitGrayscale = 3;
    static final int Tight4Bit16Colors = 4;
    static final int Tight8Bit256Colors = 8;
    static final int TightCacheBufferDepth = 8;
    static final int TightTileDimension = 16;
    static final int TightCacheTag = 12;
    static final int TightCacheClientIndex = 127;
    static final int TightTileCached = 128;
    static final int TightTileNot_Cached = 0;
    static final int TightCacheAll = 0;
    static final int TightCacheNone = 4;
    static final int TightCacheMix = 8;
    static final int LRLESubenc15bitDirectLossy = 0;
    static final int LRLESubenc15bitDirectLossless = 1;
    static final int LRLESubenc7bitDirectLossy = 2;
    static final int LRLESubenc7bitDirectLossless = 3;
    static final int LRLESubenc4bitPaletteLossy = 4;
    static final int LRLESubenc4bitPaletteLossless = 5;
    static final int LRLESubenc4bitGreyLossy = 6;
    static final int LRLESubenc4bitGreyLossless = 7;
    static final int LRLESubenc3bitGreyLossy = 8;
    static final int LRLESubenc3bitGreyLossless = 9;
    static final int LRLESubenc2bitGreyLossy = 10;
    static final int LRLESubenc2bitGreyLossless = 11;
    static final int LRLESubenc1bitGreyLossy = 12;
    static final int LRLESubenc1bitGreyLossless = 13;
    static final int PointerMoveAbsolute = 0;
    static final int PointerMoveRelative = 1;
    static final byte BandwidthTickStage1 = 1;
    static final byte BandwidthTickStage2 = 2;
    static final byte UnbufferedInStream = 1;
    static final byte BufferedInStream = 2;
    static final byte BlankStateDontBlank = 0;
    static final byte BlankStateBlank = 1;
    static final byte MouseSyncNorm = 0;
    static final byte MouseSyncHard = 1;
    static final byte MouseSyncFast = 2;
    static final byte tileWidth = 16;
    static final byte tileHeight = 16;
    static final int SasEventExistingSession = 1;
    static final int SasEventExistingKvmSession = 2;
    static final int SasEventUserLoginFailure = 3;
    static final int SasEventUserSessionOpened = 4;
    static final int SasEventUserSessionClosed = 5;
    static final int SasEventKvmSessionOpened = 6;
    static final int SasEventKvmSessionClosed = 7;
    static final int SasEventKvmExclusiveOn = 8;
    static final int SasEventKvmExclusiveOff = 9;
    static final int SasEventInput = 10;
    static final int SasEventKvmSwitch = 11;
    static final int SasEventResetSessions = 12;
    static final int SasErrorNoInput = 1;
    static final int SasErrorMissedInputEvent = 2;
    static final int SasErrorMissedSessionEvent = 3;
    static final int SasErrorMissedOtherEvent = 4;
    static final int SpCommandPlay = 0;
    static final int SpCommandPause = 1;
    static final int SpCommandStop = 2;
    static final int SpCommandSetSpeed = 3;
    static final int SpCommandSeek = 4;
    protected PrintStream logger;
    protected boolean connected;
    protected boolean monitorMode;
    protected Socket sock;
    public InputStream sock_instream;
    public MonitoringDataInputStream min;
    public MonitoringOutputStream mout;
    MonitoringDataInputStream is;
    MonitoringDataInputStream is_rect;
    MonitoringOutputStream os;
    String name;
    VideoSettings vs = new VideoSettings();
    int framebufferWidth;
    int framebufferWidthPadded;
    int framebufferHeight;
    int framebufferHeightPadded;

    RFBproto(RFBProfile profile, PrintStream logger) {
        super(profile, logger, "RFB");
        this.profile = profile;
        this.logger = logger;
        this.connected = false;
    }

    @Override
    public boolean connected() {
        return this.connected;
    }

    @Override
    public void setMonitorMode(boolean val) {
        this.monitorMode = val;
    }

    protected void rfbConnect() throws IOException {
        if (this.profile.sslRequired || !this.profile.noTrialAndError) {
            this.sock = this.connectSSL(this.profile.remoteHost, this.profile.sslPort);
        }
        if (this.sock == null && !this.profile.sslRequired) {
            this.sock = this.connect(this.profile.remoteHost, this.profile.primaryPort);
        }
        if (this.sock == null && !this.profile.sslRequired && this.profile.useProxy) {
            this.sock = this.connectProxy(this.profile.proxyHost, this.profile.proxyPort, this.profile.remoteHost, this.profile.primaryPort);
        }
        if (this.sock == null && !this.profile.sslRequired && !this.profile.noTrialAndError) {
            this.sock = this.connect(this.profile.remoteHost, this.profile.secondaryPort);
        }
        if (this.sock == null) {
            throw new IOException(this.sockerr + " (" + T._("no connect options left") + ")");
        }
        this.os = this.mout = new MonitoringOutputStream(this.sock.getOutputStream());
        this.sock_instream = this.sock.getInputStream();
        this.is = this.min = new MonitoringDataInputStream(new BufferedInputStream(this.sock_instream, 32768));
    }

    protected abstract void runInitialHandshake() throws IOException;

    public void establishConnection() throws IOException {
        this.logger.println(T._("RFB: construct RFB with the followig profile") + ": " + this.profile);
        this.setMonitorMode(this.profile.initialMoniMode);
        this.rfbConnect();
        this.runInitialHandshake();
    }

    public static String getQuitReasonMsg(int qr) {
        switch (qr) {
            case 1: {
                return T._("no permission");
            }
            case 2: {
                return T._("exclusive access active");
            }
            case 3: {
                return T._("manually rejected");
            }
            case 4: {
                return T._("server password disabled");
            }
            case 5: {
                return T._("loopback connection is senseless");
            }
            case 6: {
                return T._("authentication failed");
            }
            case 7: {
                return T._("access to this kvm port denied");
            }
            case 8: {
                return T._("too many clients active simultaneously");
            }
            case 16: {
                return T._("unexpected server error");
            }
            case 17: {
                return T._("bad protocol version");
            }
            case 18: {
                return T._("protocol error");
            }
            case 19: {
                return T._("internal server error");
            }
            case 20: {
                return T._("wrong replay parameters");
            }
        }
        return "";
    }

    public static String getSasErrorMsg(int qr) {
        switch (qr) {
            case 1: {
                return T._("no input events possible");
            }
            case 2: {
                return T._("missed input event");
            }
            case 3: {
                return T._("missed session event");
            }
            case 4: {
                return T._("missed other event");
            }
        }
        return "";
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getSecDesc() {
        return this.secDesc;
    }

    @Override
    public void close() {
        try {
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace(this.logger);
        }
        this.connected = false;
    }

    protected void printBuffer(byte[] buf, int size, int brk) {
        for (int i = 0; i < size; ++i) {
            if (i % brk == 0) {
                System.out.println("");
            }
            System.out.print(Integer.toHexString(buf[i]).toUpperCase() + " ");
        }
        System.out.println("");
    }

    int readCompactLen() throws IOException {
        int portion = this.is.readUnsignedByte();
        int len = portion & 0x7F;
        if ((portion & 0x80) != 0) {
            portion = this.is.readUnsignedByte();
            len |= (portion & 0x7F) << 7;
            if ((portion & 0x80) != 0) {
                portion = this.is.readUnsignedByte();
                len |= (portion & 0xFF) << 14;
            }
        }
        return len;
    }

    abstract void writeUserPropChangeEvent(String var1, String var2) throws IOException;

    abstract void writeVideoSettingsEvent(byte var1, short var2) throws IOException;

    abstract void writeVideoSettingsRequest(byte var1) throws IOException;

    abstract void writeVideoRefresh() throws IOException;

    abstract void writeString(String var1) throws IOException;

    abstract void writeSetPixelFormat(int var1, int var2, boolean var3, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10) throws IOException;

    abstract void writeFullFramebufferUpdateRequest() throws IOException;
}

