/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import nn.pp.rc.FixedLabel;
import nn.pp.rc.ImageButton;
import nn.pp.rc.ImageLoader;
import nn.pp.rc.T;
import nn.pp.sara.ReplayPanel;

public class ButtonsPanel
extends Panel
implements ActionListener {
    private static final int PRESS_PLAY_BUTTON = 0;
    private static final int PRESS_PAUSE_BUTTON = 1;
    private static final int PRESS_STOP_BUTTON = 2;
    private URL codeBase;
    private ReplayPanel replay;
    private Dimension btnDim;
    private ImageButton playButton;
    private ImageButton pauseButton;
    private ImageButton stopButton;
    private Image playImage;
    private Image pauseImage;
    private Image stopImage;
    private FixedLabel stateLabel;

    public ButtonsPanel(URL codeBase, ReplayPanel replay) {
        this.codeBase = codeBase;
        this.replay = replay;
        this.addLayout();
    }

    private void addLayout() {
        this.setLayout(new BorderLayout());
        Panel p = new Panel();
        p.setLayout(new FlowLayout(0));
        this.btnDim = new Dimension(33, 32);
        ImageLoader imgloader = new ImageLoader(this.codeBase);
        this.playImage = imgloader.loadImage("nn/pp/sara/icon_play.gif");
        this.pauseImage = imgloader.loadImage("nn/pp/sara/icon_pau.gif");
        this.stopImage = imgloader.loadImage("nn/pp/sara/icon_sto.gif");
        this.playButton = new ImageButton("  " + T._("Play"), this.playImage, this.btnDim, 0);
        this.pauseButton = new ImageButton("  " + T._("Pause"), this.pauseImage, this.btnDim, 0);
        this.stopButton = new ImageButton("  " + T._("Stop"), this.stopImage, this.btnDim, 0);
        this.playButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        p.add(this.playButton);
        p.add(this.pauseButton);
        p.add(this.stopButton);
        this.add((Component)p, "Center");
        this.stateLabel = new FixedLabel("");
        this.add((Component)this.stateLabel, "East");
    }

    @Override
    public void setEnabled(boolean b) {
        this.playButton.setEnabled(b);
        this.pauseButton.setEnabled(b);
        this.stopButton.setEnabled(b);
        this.stateLabel.setEnabled(b);
        super.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.playButton) {
            this.replay.play();
        } else if (src == this.pauseButton) {
            this.replay.pause();
        } else if (src == this.stopButton) {
            this.replay.stop();
        }
    }

    private void setPressedButton(int no) {
        switch (no) {
            case 0: {
                this.playButton.setImageIndex(1);
                this.pauseButton.setImageIndex(0);
                this.stopButton.setImageIndex(0);
                break;
            }
            case 1: {
                this.playButton.setImageIndex(0);
                this.pauseButton.setImageIndex(1);
                this.stopButton.setImageIndex(0);
                break;
            }
            case 2: {
                this.playButton.setImageIndex(0);
                this.pauseButton.setImageIndex(0);
                this.stopButton.setImageIndex(1);
            }
        }
    }

    void play() {
        this.setPressedButton(0);
        this.stateLabel.setText(T._("Playing"));
    }

    void pause() {
        this.setPressedButton(1);
        this.stateLabel.setText(T._("Paused"));
    }

    void stop() {
        this.setPressedButton(2);
        this.stateLabel.setText(T._("Stopped"));
    }
}

