/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import nn.pp.rc.SasEvent;
import nn.pp.sara.EventLogPanel;
import nn.pp.sara.FramePanel;
import nn.pp.sara.KeyboardPanel;
import nn.pp.sara.MousePanel;
import nn.pp.sara.SasForensicPanel;
import nn.pp.sara.SecurityPanel;
import nn.pp.sara.SessionsPanel;
import nn.pp.sara.UserSession;

public class InfoPanel
extends FramePanel {
    MousePanel mousePanel;
    KeyboardPanel keyboardPanel;
    SessionsPanel sessionsPanel;
    SecurityPanel securityPanel;
    EventLogPanel eventLogPanel;
    SimpleDateFormat dateFormatShort;
    SimpleDateFormat dateFormatLong;
    boolean localOnly;
    boolean noKbd;
    Hashtable sessionHash;
    Panel visualPanel;
    Panel panelPart1;
    Panel panelPart2;

    public InfoPanel(URL codeBase, Locale locale, String defkbd, SasForensicPanel parentPanel, boolean localOnly, boolean noKbd) {
        super(codeBase, parentPanel);
        this.localOnly = localOnly;
        this.noKbd = noKbd;
        this.dateFormatShort = new SimpleDateFormat("HH:mm:ss.SSS");
        this.dateFormatLong = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.sessionHash = new Hashtable();
        if (!noKbd) {
            this.keyboardPanel = new KeyboardPanel(this, locale, defkbd);
        }
        this.mousePanel = new MousePanel(this);
        if (!localOnly) {
            this.sessionsPanel = new SessionsPanel(this);
            this.securityPanel = new SecurityPanel(this);
        }
        this.eventLogPanel = new EventLogPanel(this);
        this.addLayout();
    }

    @Override
    protected String getFrameName() {
        return "Forensic Console";
    }

    @Override
    protected void addVisualPanels(boolean inFrame) {
        if (inFrame) {
            this.visualPanel.remove(this.panelPart1);
            this.visualPanel.remove(this.panelPart2);
            if (!this.localOnly) {
                this.visualPanel.setLayout(new GridLayout(2, 2));
                if (this.sessionsPanel != null) {
                    this.visualPanel.add(this.sessionsPanel);
                }
                if (this.securityPanel != null) {
                    this.visualPanel.add(this.securityPanel);
                }
            } else if (this.keyboardPanel != null) {
                this.visualPanel.setLayout(new GridLayout(1, 2));
            } else {
                this.visualPanel.setLayout(new GridLayout(1, 1));
            }
            if (this.keyboardPanel != null) {
                this.visualPanel.add(this.keyboardPanel);
            }
            if (this.mousePanel != null) {
                this.visualPanel.add(this.mousePanel);
            }
        } else {
            if (this.sessionsPanel != null) {
                this.visualPanel.remove(this.sessionsPanel);
            }
            if (this.securityPanel != null) {
                this.visualPanel.remove(this.securityPanel);
            }
            if (this.keyboardPanel != null) {
                this.visualPanel.remove(this.keyboardPanel);
            }
            if (this.mousePanel != null) {
                this.visualPanel.remove(this.mousePanel);
            }
            this.visualPanel.setLayout(new BorderLayout());
            if (!this.localOnly) {
                if (this.sessionsPanel != null) {
                    this.panelPart1.add((Component)this.sessionsPanel, "West");
                }
                if (this.securityPanel != null) {
                    this.panelPart1.add((Component)this.securityPanel, "Center");
                }
                this.visualPanel.add((Component)this.panelPart1, "West");
            }
            if (this.keyboardPanel != null) {
                this.panelPart2.add((Component)this.keyboardPanel, "Center");
            }
            if (this.mousePanel != null) {
                this.panelPart2.add((Component)this.mousePanel, "East");
            }
            this.visualPanel.add((Component)this.panelPart2, "East");
        }
    }

    private void addLayout() {
        this.eventLogPanel.addLayout();
        if (this.mousePanel != null) {
            this.mousePanel.addLayout();
        }
        if (this.keyboardPanel != null) {
            this.keyboardPanel.addLayout();
        }
        if (this.sessionsPanel != null) {
            this.sessionsPanel.addLayout();
        }
        if (this.securityPanel != null) {
            this.securityPanel.addLayout();
        }
        this.mainPanel = new Panel(new BorderLayout());
        Panel textClearPanel = new Panel();
        textClearPanel.setLayout(new BorderLayout());
        Panel frameButtonPanel = this.getFrameButtonPanel();
        textClearPanel.add((Component)frameButtonPanel, "West");
        textClearPanel.add((Component)this.eventLogPanel, "Center");
        this.mainPanel.add((Component)textClearPanel, "Center");
        this.visualPanel = new Panel();
        this.panelPart1 = new Panel(new BorderLayout());
        this.panelPart2 = new Panel(new BorderLayout());
        this.addVisualPanels(this.inFrame);
        Label dummyLabel = new Label();
        Panel visualDummyPanel = new Panel();
        visualDummyPanel.setLayout(new BorderLayout());
        visualDummyPanel.add((Component)this.visualPanel, "West");
        visualDummyPanel.add((Component)dummyLabel, "Center");
        this.mainPanel.add((Component)visualDummyPanel, "South");
        this.setLayout(new BorderLayout());
        this.showInitial();
    }

    @Override
    public void setEnabled(boolean b) {
        this.eventLogPanel.setEnabled(b);
        super.setEnabled(b);
    }

    synchronized void putSession(Long key, UserSession newEntry) {
        UserSession e = (UserSession)this.sessionHash.get(key);
        if (e != null) {
            System.out.println("Already found session 0x" + Long.toHexString(key) + ": " + e.toString());
            this.sessionHash.remove(key);
        }
        this.sessionHash.put(key, newEntry);
    }

    synchronized UserSession getSession(Long key) {
        UserSession e = (UserSession)this.sessionHash.get(key);
        if (e == null) {
            e = new UserSession("(unknown)", "(unknown)", new Date(), false);
            this.putSession(key, e);
        }
        return e;
    }

    synchronized void removeSession(Long key) {
        this.sessionHash.remove(key);
    }

    synchronized void removeAllSessions() {
        this.sessionHash.clear();
    }

    synchronized Vector getSessions() {
        Vector<String> vec = new Vector<String>();
        Enumeration e = this.sessionHash.elements();
        while (e.hasMoreElements()) {
            UserSession entry = (UserSession)e.nextElement();
            vec.add(entry.toString());
        }
        return vec;
    }

    void newEventText(String s) {
        this.eventLogPanel.newEvent(s);
    }

    void newEvent(SasEvent evt, String name, String text, boolean showUser) {
        String s = this.getEventTime(evt, true) + " - " + name;
        if (showUser && !this.localOnly) {
            s = evt.session == 0L ? s + " - local user" : s + " - User: " + this.getEventUser(evt) + ", IP: " + this.getEventIp(evt);
        }
        if (text != null) {
            s = s + " - " + text;
        }
        this.eventLogPanel.newEvent(s);
    }

    void newEvent(SasEvent evt, String name, String text) {
        this.newEvent(evt, name, text, true);
    }

    void newEvent(SasEvent evt, String name, boolean showUser) {
        this.newEvent(evt, name, null, showUser);
    }

    void newEvent(SasEvent evt, String name) {
        this.newEvent(evt, name, null, true);
    }

    public void newKbdMapping(Locale locale) {
        if (this.keyboardPanel != null) {
            this.keyboardPanel.newKbdMapping(locale);
        }
    }

    public void newKbdLayout(String layout) {
        if (this.keyboardPanel != null) {
            this.keyboardPanel.newKbdLayout(layout);
        }
    }

    String getEventUser(SasEvent evt) {
        if (evt.session == 0L) {
            return "(local)";
        }
        UserSession s = this.getSession(new Long(evt.session));
        return s.user;
    }

    String getEventIp(SasEvent evt) {
        if (evt.session == 0L) {
            return "(local)";
        }
        UserSession s = this.getSession(new Long(evt.session));
        return s.ip;
    }

    synchronized String getEventTime(Date time, boolean full2) {
        SimpleDateFormat dateFormat = full2 ? this.dateFormatLong : this.dateFormatShort;
        return dateFormat.format(time).toString();
    }

    String getEventTime(SasEvent evt, boolean full2) {
        return this.getEventTime(evt.time, full2);
    }

    private void handleExistingSession(SasEvent evt) {
        if (this.sessionsPanel == null) {
            return;
        }
        this.sessionsPanel.handleSasEvent(evt);
        this.newEventText("Session - User: " + this.getEventUser(evt) + ", IP: " + this.getEventIp(evt) + ", Login: " + this.getEventTime(evt.exSession.loginTime, true));
    }

    private void handleExistingKvmSession(SasEvent evt) {
        if (this.sessionsPanel == null) {
            return;
        }
        this.sessionsPanel.handleSasEvent(evt);
        this.newEventText("KVM Session - User: " + this.getEventUser(evt) + ", IP: " + this.getEventIp(evt) + ", Login: " + this.getEventTime(evt.exKvmSession.loginTime, true));
    }

    private void handleSessionEvent(SasEvent evt) {
        if (this.sessionsPanel != null) {
            this.sessionsPanel.handleSasEvent(evt);
        }
    }

    private void handleInput(SasEvent evt) {
        if (evt.inputEvent.type == 4) {
            if (this.keyboardPanel != null) {
                this.keyboardPanel.handleSasEvent(evt);
            }
        } else if (this.mousePanel != null) {
            this.mousePanel.handleSasEvent(evt);
        }
    }

    private void handleUserLoginFailure(SasEvent evt) {
        if (this.securityPanel != null) {
            this.securityPanel.handleSasEvent(evt);
        }
    }

    private void handleKvmSwitchEvent(SasEvent evt) {
        this.newEvent(evt, "KVM Switch", "channel: " + evt.kvmSwitchEvent.channel + " unit: " + evt.kvmSwitchEvent.unit + " port: " + evt.kvmSwitchEvent.port);
    }

    public void handleSasEvent(SasEvent evt) {
        switch (evt.type) {
            case 1: {
                if (evt.exSession == null) break;
                this.handleExistingSession(evt);
                break;
            }
            case 2: {
                if (evt.exKvmSession == null) break;
                this.handleExistingKvmSession(evt);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                this.handleSessionEvent(evt);
                break;
            }
            case 10: {
                if (evt.inputEvent == null) break;
                this.handleInput(evt);
                break;
            }
            case 3: {
                this.handleUserLoginFailure(evt);
                break;
            }
            case 11: {
                this.handleKvmSwitchEvent(evt);
            }
        }
    }
}

