/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.DirtyRegionContainer;
import java.util.Deque;
import java.util.LinkedList;

public final class DirtyRegionPool {
    private static final int POOL_SIZE_MIN = 4;
    private static final int EXPIRATION_TIME = 3000;
    private static final int COUNT_BETWEEN_EXPIRATION_CHECK = 90;
    private final int containerSize;
    private int clearCounter = 90;
    private final Deque<DirtyRegionContainer> fixed;
    private final Deque<PoolItem> unlocked;
    private final Deque<PoolItem> locked;

    public DirtyRegionPool(int containerSize) {
        this.containerSize = containerSize;
        this.fixed = new LinkedList<DirtyRegionContainer>();
        this.unlocked = new LinkedList<PoolItem>();
        this.locked = new LinkedList<PoolItem>();
        for (int i = 0; i < 4; ++i) {
            this.fixed.add(new DirtyRegionContainer(containerSize));
        }
    }

    public DirtyRegionContainer checkOut() {
        this.clearExpired();
        if (!this.fixed.isEmpty()) {
            return this.fixed.pop();
        }
        if (!this.unlocked.isEmpty()) {
            PoolItem item = this.unlocked.pop();
            this.locked.push(item);
            return item.container;
        }
        DirtyRegionContainer c = new DirtyRegionContainer(this.containerSize);
        this.locked.push(new PoolItem(null, -1L));
        return c;
    }

    public void checkIn(DirtyRegionContainer drc) {
        drc.reset();
        if (this.locked.isEmpty()) {
            this.fixed.push(drc);
        } else {
            PoolItem item = this.locked.pop();
            item.container = drc;
            item.timeStamp = System.currentTimeMillis();
            this.unlocked.push(item);
        }
    }

    private void clearExpired() {
        if (this.unlocked.isEmpty()) {
            return;
        }
        if (this.clearCounter-- == 0) {
            this.clearCounter = 90;
            PoolItem i = this.unlocked.peekLast();
            long now = System.currentTimeMillis();
            while (i != null && i.timeStamp + 3000L < now) {
                this.unlocked.removeLast();
                i = this.unlocked.peekLast();
            }
        }
    }

    private class PoolItem {
        DirtyRegionContainer container;
        long timeStamp;

        public PoolItem(DirtyRegionContainer container, long timeStamp) {
            this.container = container;
            this.timeStamp = timeStamp;
        }
    }
}

