/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.text.TextRun;
import com.sun.prism.Graphics;
import com.sun.prism.paint.Color;

public class NGText
extends NGShape {
    static final BaseTransform IDENT = BaseTransform.IDENTITY_TRANSFORM;
    private GlyphList[] runs;
    private float layoutX;
    private float layoutY;
    private PGFont font;
    private int fontSmoothingType;
    private boolean underline;
    private boolean strikethrough;
    private Object selectionPaint;
    private int selectionStart;
    private int selectionEnd;
    private static double EPSILON = 0.01;
    private FontStrike fontStrike = null;
    private FontStrike identityStrike = null;
    private double[] strikeMat = new double[4];
    private boolean drawingEffect = false;
    private static int FILL = 2;
    private static int SHAPE_FILL = 4;
    private static int TEXT = 8;
    private static int DECORATION = 16;

    public void setGlyphs(Object[] glyphs) {
        this.runs = (GlyphList[])glyphs;
        this.geometryChanged();
    }

    public void setLayoutLocation(float x, float y) {
        this.layoutX = x;
        this.layoutY = y;
        this.geometryChanged();
    }

    public void setFont(Object font) {
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = (PGFont)font;
        this.fontStrike = null;
        this.identityStrike = null;
        this.geometryChanged();
    }

    public void setFontSmoothingType(int fontSmoothingType) {
        this.fontSmoothingType = fontSmoothingType;
        this.geometryChanged();
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
        this.geometryChanged();
    }

    public void setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
        this.geometryChanged();
    }

    public void setSelection(int start, int end, Object color) {
        this.selectionPaint = color;
        this.selectionStart = start;
        this.selectionEnd = end;
        this.geometryChanged();
    }

    @Override
    protected BaseBounds computePadding(BaseBounds region) {
        float pad = this.fontSmoothingType == 1 ? 2.0f : 1.0f;
        return region.deriveWithNewBounds(region.getMinX() - pad, region.getMinY() - pad, region.getMinZ(), region.getMaxX() + pad, region.getMaxY() + pad, region.getMaxZ());
    }

    private FontStrike getStrike(BaseTransform xform) {
        int smoothingType = this.fontSmoothingType;
        if (this.getMode() == NGShape.Mode.STROKE_FILL) {
            smoothingType = 0;
        }
        if (xform.isIdentity()) {
            if (this.identityStrike == null || smoothingType != this.identityStrike.getAAMode()) {
                this.identityStrike = this.font.getStrike(IDENT, smoothingType);
            }
            return this.identityStrike;
        }
        if (this.fontStrike == null || this.fontStrike.getSize() != this.font.getSize() || xform.getMxy() == 0.0 && this.strikeMat[1] != 0.0 || xform.getMyx() == 0.0 && this.strikeMat[2] != 0.0 || Math.abs(this.strikeMat[0] - xform.getMxx()) > EPSILON || Math.abs(this.strikeMat[1] - xform.getMxy()) > EPSILON || Math.abs(this.strikeMat[2] - xform.getMyx()) > EPSILON || Math.abs(this.strikeMat[3] - xform.getMyy()) > EPSILON || smoothingType != this.fontStrike.getAAMode()) {
            this.fontStrike = this.font.getStrike(xform, smoothingType);
            this.strikeMat[0] = xform.getMxx();
            this.strikeMat[1] = xform.getMxy();
            this.strikeMat[2] = xform.getMyx();
            this.strikeMat[3] = xform.getMyy();
        }
        return this.fontStrike;
    }

    @Override
    public Shape getShape() {
        if (this.runs == null) {
            return new Path2D();
        }
        FontStrike strike = this.getStrike(IDENT);
        Path2D outline = new Path2D();
        for (int i = 0; i < this.runs.length; ++i) {
            RoundRectangle2D rect;
            GlyphList run = this.runs[i];
            Point2D pt = run.getLocation();
            float x = pt.x - this.layoutX;
            float y = pt.y - this.layoutY;
            BaseTransform t = BaseTransform.getTranslateInstance(x, y);
            outline.append(strike.getOutline(run, t), false);
            Metrics metrics = null;
            if (this.underline) {
                metrics = strike.getMetrics();
                rect = new RoundRectangle2D();
                rect.x = x;
                rect.y = y + metrics.getUnderLineOffset();
                rect.width = run.getWidth();
                rect.height = metrics.getUnderLineThickness();
                outline.append(rect, false);
            }
            if (!this.strikethrough) continue;
            if (metrics == null) {
                metrics = strike.getMetrics();
            }
            rect = new RoundRectangle2D();
            rect.x = x;
            rect.y = y + metrics.getStrikethroughOffset();
            rect.width = run.getWidth();
            rect.height = metrics.getStrikethroughThickness();
            outline.append(rect, false);
        }
        return outline;
    }

    @Override
    protected void renderEffect(Graphics g) {
        if (!g.getTransformNoClone().isTranslateOrIdentity()) {
            this.drawingEffect = true;
        }
        try {
            super.renderEffect(g);
        }
        finally {
            this.drawingEffect = false;
        }
    }

    @Override
    protected void renderContent2D(Graphics g, boolean printing) {
        int op;
        if (this.mode == NGShape.Mode.EMPTY) {
            return;
        }
        if (this.runs == null || this.runs.length == 0) {
            return;
        }
        BaseTransform tx = g.getTransformNoClone();
        FontStrike strike = this.getStrike(tx);
        if (strike.getAAMode() == 1 || this.fillPaint != null && this.fillPaint.isProportional() || this.drawPaint != null && this.drawPaint.isProportional()) {
            BaseBounds bds = this.getContentBounds(new RectBounds(), IDENT);
            g.setNodeBounds((RectBounds)bds);
        }
        Color selectionColor = null;
        if (this.selectionStart != this.selectionEnd && this.selectionPaint instanceof Color) {
            selectionColor = (Color)this.selectionPaint;
        }
        BaseBounds clipBds = null;
        if (this.getClipNode() != null) {
            clipBds = this.getClippedBounds(new RectBounds(), IDENT);
        }
        if (this.mode != NGShape.Mode.STROKE) {
            g.setPaint(this.fillPaint);
            op = TEXT;
            this.renderText(g, strike, clipBds, selectionColor, op |= strike.drawAsShapes() || this.drawingEffect ? SHAPE_FILL : FILL);
            if (this.underline || this.strikethrough) {
                op = DECORATION | SHAPE_FILL;
                this.renderText(g, strike, clipBds, selectionColor, op);
            }
        }
        if (this.mode != NGShape.Mode.FILL) {
            g.setPaint(this.drawPaint);
            g.setStroke(this.drawStroke);
            op = TEXT;
            if (this.underline || this.strikethrough) {
                op |= DECORATION;
            }
            this.renderText(g, strike, clipBds, selectionColor, op);
        }
        g.setNodeBounds(null);
    }

    private void renderText(Graphics g, FontStrike strike, BaseBounds clipBds, Color selectionColor, int op) {
        for (int i = 0; i < this.runs.length; ++i) {
            float myt;
            float thickness;
            float offset;
            TextRun run = (TextRun)this.runs[i];
            RectBounds lineBounds = run.getLineBounds();
            Point2D pt = run.getLocation();
            float x = pt.x - this.layoutX;
            float y = pt.y - this.layoutY;
            if (clipBds != null) {
                if (y > clipBds.getMaxY()) break;
                if (y + lineBounds.getHeight() < clipBds.getMinY() || x > clipBds.getMaxX() || x + run.getWidth() < clipBds.getMinX()) continue;
            }
            y -= lineBounds.getMinY();
            if ((op & TEXT) != 0 && run.getGlyphCount() > 0) {
                if ((op & FILL) != 0) {
                    int start = run.getStart();
                    g.drawString(run, strike, x, y, selectionColor, this.selectionStart - start, this.selectionEnd - start);
                } else {
                    BaseTransform t = BaseTransform.getTranslateInstance(x, y);
                    if ((op & SHAPE_FILL) != 0) {
                        g.fill(strike.getOutline(run, t));
                    } else {
                        g.draw(strike.getOutline(run, t));
                    }
                }
            }
            if ((op & DECORATION) == 0) continue;
            Metrics metrics = strike.getMetrics();
            if (this.underline) {
                offset = y + metrics.getUnderLineOffset();
                thickness = metrics.getUnderLineThickness();
                if ((op & SHAPE_FILL) != 0) {
                    if (thickness <= 1.0f && g.getTransformNoClone().isTranslateOrIdentity()) {
                        myt = (float)g.getTransformNoClone().getMyt();
                        offset = (float)Math.round(offset + myt) - myt;
                    }
                    g.fillRect(x, offset, run.getWidth(), thickness);
                } else {
                    g.drawRect(x, offset, run.getWidth(), thickness);
                }
            }
            if (!this.strikethrough) continue;
            offset = y + metrics.getStrikethroughOffset();
            thickness = metrics.getStrikethroughThickness();
            if ((op & SHAPE_FILL) != 0) {
                if (thickness <= 1.0f && g.getTransformNoClone().isTranslateOrIdentity()) {
                    myt = (float)g.getTransformNoClone().getMyt();
                    offset = (float)Math.round(offset + myt) - myt;
                }
                g.fillRect(x, offset, run.getWidth(), thickness);
                continue;
            }
            g.drawRect(x, offset, run.getWidth(), thickness);
        }
    }
}

