/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.ResourceFactory;
import com.sun.prism.d3d.D3DDriverInformation;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.impl.PrismSettings;
import java.security.AccessController;
import java.util.List;

public final class D3DPipeline
extends GraphicsPipeline {
    private static final boolean d3dEnabled;
    private static Thread creator;
    private static D3DPipeline theInstance;
    private static D3DResourceFactory[] factories;
    D3DResourceFactory _default;
    private int maxSamples = -1;

    public static D3DPipeline getInstance() {
        return theInstance;
    }

    private static boolean isDriverWarning(String warningMessage) {
        return warningMessage.contains("driver version");
    }

    private static void printDriverWarning(D3DDriverInformation di) {
        if (di != null && di.warningMessage != null && (PrismSettings.verbose || D3DPipeline.isDriverWarning(di.warningMessage))) {
            System.out.println("Device \"" + di.deviceDescription + "\" (" + di.deviceName + ") initialization failed : ");
            System.out.println(di.warningMessage);
        }
    }

    private static void printDriverWarning(int adapter) {
        D3DPipeline.printDriverWarning(D3DPipeline.nGetDriverInformation(adapter, new D3DDriverInformation()));
    }

    private static void printDriverInformation(int adapter) {
        D3DDriverInformation di = D3DPipeline.nGetDriverInformation(adapter, new D3DDriverInformation());
        if (di != null) {
            System.out.println("OS Information:");
            System.out.println("\t" + di.getOsVersion() + " build " + di.osBuildNumber);
            System.out.println("D3D Driver Information:");
            System.out.println("\t" + di.deviceDescription);
            System.out.println("\t" + di.deviceName);
            System.out.println("\tDriver " + di.driverName + ", version " + di.getDriverVersion());
            System.out.println("\tPixel Shader version " + di.psVersionMajor + "." + di.psVersionMinor);
            System.out.println("\tDevice : " + di.getDeviceID());
            System.out.println("\tMax Multisamples supported: " + di.maxSamples);
            if (di.warningMessage != null) {
                System.out.println("\t *** " + di.warningMessage);
            }
        }
    }

    private static void printDriverWarnings() {
        D3DDriverInformation di;
        int adapter = 0;
        while ((di = D3DPipeline.nGetDriverInformation(adapter, new D3DDriverInformation())) != null) {
            D3DPipeline.printDriverWarning(di);
            ++adapter;
        }
    }

    private D3DPipeline() {
    }

    @Override
    public boolean init() {
        return d3dEnabled;
    }

    private static native boolean nInit(Class var0);

    private static native String nGetErrorMessage();

    private static native void nDispose();

    private static native int nGetAdapterOrdinal(long var0);

    private static native int nGetAdapterCount();

    private static native D3DDriverInformation nGetDriverInformation(int var0, D3DDriverInformation var1);

    private static native int nGetMaxSampleSupport(int var0);

    @Override
    public void dispose() {
        if (creator != Thread.currentThread()) {
            throw new IllegalStateException("This operation is not permitted on the current thread [" + Thread.currentThread().getName() + "]");
        }
        D3DPipeline.notifyAllResourcesReleased();
        if (null != this.fontFactory) {
            this.fontFactory.dispose();
        }
        D3DPipeline.nDispose();
        for (int i = 0; i != factories.length; ++i) {
            D3DPipeline.factories[i] = null;
        }
        super.dispose();
    }

    private static D3DResourceFactory createResourceFactory(int adapterOrdinal, Screen screen) {
        long pContext = D3DResourceFactory.nGetContext(adapterOrdinal);
        return pContext != 0L ? new D3DResourceFactory(pContext, screen) : null;
    }

    private static D3DResourceFactory getD3DResourceFactory(int adapterOrdinal, Screen screen) {
        D3DResourceFactory factory = factories[adapterOrdinal];
        if (factory == null && screen != null) {
            D3DPipeline.factories[adapterOrdinal] = factory = D3DPipeline.createResourceFactory(adapterOrdinal, screen);
        }
        return factory;
    }

    private static void notifyAllResourcesReleased() {
        for (D3DResourceFactory rf : factories) {
            if (rf == null) continue;
            rf.notifyReleased();
        }
    }

    private static Screen getScreenForAdapter(List<Screen> screens, int adapterOrdinal) {
        for (Screen screen : screens) {
            if (screen.getAdapterOrdinal() != adapterOrdinal) continue;
            return screen;
        }
        return Screen.getMainScreen();
    }

    @Override
    public int getAdapterOrdinal(Screen screen) {
        return D3DPipeline.nGetAdapterOrdinal(screen.getNativeScreen());
    }

    private static D3DResourceFactory findDefaultResourceFactory(List<Screen> screens) {
        int n = D3DPipeline.nGetAdapterCount();
        for (int adapter = 0; adapter != n; ++adapter) {
            D3DResourceFactory rf = D3DPipeline.getD3DResourceFactory(adapter, D3DPipeline.getScreenForAdapter(screens, adapter));
            if (rf != null) {
                if (PrismSettings.verbose) {
                    D3DPipeline.printDriverInformation(adapter);
                }
                return rf;
            }
            if (PrismSettings.disableBadDriverWarning) continue;
            D3DPipeline.printDriverWarning(adapter);
        }
        return null;
    }

    @Override
    public ResourceFactory getDefaultResourceFactory(List<Screen> screens) {
        if (this._default == null) {
            this._default = D3DPipeline.findDefaultResourceFactory(screens);
        }
        return this._default;
    }

    @Override
    public ResourceFactory getResourceFactory(Screen screen) {
        return D3DPipeline.getD3DResourceFactory(screen.getAdapterOrdinal(), screen);
    }

    @Override
    public boolean is3DSupported() {
        return true;
    }

    int getMaxSamples() {
        if (this.maxSamples < 0) {
            this.isMSAASupported();
        }
        return this.maxSamples;
    }

    @Override
    public boolean isMSAASupported() {
        if (this.maxSamples < 0) {
            this.maxSamples = D3DPipeline.nGetMaxSampleSupport(0);
        }
        return this.maxSamples > 0;
    }

    @Override
    public boolean isVsyncSupported() {
        return true;
    }

    @Override
    public boolean supportsShaderType(GraphicsPipeline.ShaderType type) {
        switch (type) {
            case HLSL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsShaderModel(GraphicsPipeline.ShaderModel model) {
        switch (model) {
            case SM3: {
                return true;
            }
        }
        return false;
    }

    static {
        boolean printD3DError;
        d3dEnabled = AccessController.doPrivileged(() -> {
            if (PrismSettings.verbose) {
                System.out.println("Loading D3D native library ...");
            }
            NativeLibLoader.loadLibrary("prism_d3d");
            if (PrismSettings.verbose) {
                System.out.println("\tsucceeded.");
            }
            return D3DPipeline.nInit(PrismSettings.class);
        });
        if (PrismSettings.verbose) {
            System.out.println("Direct3D initialization " + (d3dEnabled ? "succeeded" : "failed"));
        }
        boolean bl = printD3DError = PrismSettings.verbose || !PrismSettings.disableBadDriverWarning;
        if (!d3dEnabled && printD3DError) {
            if (PrismSettings.verbose) {
                System.out.println(D3DPipeline.nGetErrorMessage());
            }
            D3DPipeline.printDriverWarnings();
        }
        creator = Thread.currentThread();
        if (d3dEnabled) {
            theInstance = new D3DPipeline();
            factories = new D3DResourceFactory[D3DPipeline.nGetAdapterCount()];
        }
    }
}

