/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.PixelFormat;
import com.sun.prism.RectShadowGraphics;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;

public abstract class BaseGraphics
implements RectShadowGraphics {
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f);
    private static final Paint DEFAULT_PAINT = Color.WHITE;
    protected static final RoundRectangle2D scratchRRect = new RoundRectangle2D();
    protected static final Ellipse2D scratchEllipse = new Ellipse2D();
    protected static final Line2D scratchLine = new Line2D();
    protected static final BaseTransform IDENT = BaseTransform.IDENTITY_TRANSFORM;
    private final Affine3D transform3D = new Affine3D();
    private NGCamera camera = NGCamera.INSTANCE;
    private RectBounds devClipRect;
    private RectBounds finalClipRect;
    protected RectBounds nodeBounds = null;
    private Rectangle clipRect;
    private int clipRectIndex;
    private boolean hasPreCullingBits = false;
    private float extraAlpha = 1.0f;
    private CompositeMode compMode;
    private boolean antialiasedShape = true;
    private boolean depthBuffer = false;
    private boolean depthTest = false;
    protected Paint paint = DEFAULT_PAINT;
    protected BasicStroke stroke = DEFAULT_STROKE;
    protected boolean isSimpleTranslate = true;
    protected float transX;
    protected float transY;
    private final BaseContext context;
    private final RenderTarget renderTarget;
    private boolean state3D = false;
    private float pixelScale = 1.0f;
    private NodePath renderRoot;

    protected BaseGraphics(BaseContext context, RenderTarget target) {
        this.context = context;
        this.renderTarget = target;
        this.devClipRect = new RectBounds(0.0f, 0.0f, target.getContentWidth(), target.getContentHeight());
        this.finalClipRect = new RectBounds(this.devClipRect);
        this.compMode = CompositeMode.SRC_OVER;
        if (context != null) {
            context.setRenderTarget(this);
        }
    }

    protected NGCamera getCamera() {
        return this.camera;
    }

    @Override
    public RenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    @Override
    public void setState3D(boolean flag) {
        this.state3D = flag;
    }

    @Override
    public boolean isState3D() {
        return this.state3D;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.context.getAssociatedScreen();
    }

    @Override
    public ResourceFactory getResourceFactory() {
        return this.context.getResourceFactory();
    }

    @Override
    public BaseTransform getTransformNoClone() {
        return this.transform3D;
    }

    @Override
    public void setTransform(BaseTransform transform) {
        if (transform == null) {
            this.transform3D.setToIdentity();
        } else {
            this.transform3D.setTransform(transform);
        }
        this.validateTransformAndPaint();
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.transform3D.setTransform(m00, m10, m01, m11, m02, m12);
        this.validateTransformAndPaint();
    }

    @Override
    public void setTransform3D(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        this.transform3D.setTransform(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
        this.validateTransformAndPaint();
    }

    @Override
    public void transform(BaseTransform transform) {
        this.transform3D.concatenate(transform);
        this.validateTransformAndPaint();
    }

    @Override
    public void translate(float tx, float ty) {
        if (tx != 0.0f || ty != 0.0f) {
            this.transform3D.translate(tx, ty);
            this.validateTransformAndPaint();
        }
    }

    @Override
    public void translate(float tx, float ty, float tz) {
        if (tx != 0.0f || ty != 0.0f || tz != 0.0f) {
            this.transform3D.translate(tx, ty, tz);
            this.validateTransformAndPaint();
        }
    }

    @Override
    public void scale(float sx, float sy) {
        if (sx != 1.0f || sy != 1.0f) {
            this.transform3D.scale(sx, sy);
            this.validateTransformAndPaint();
        }
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        if (sx != 1.0f || sy != 1.0f || sz != 1.0f) {
            this.transform3D.scale(sx, sy, sz);
            this.validateTransformAndPaint();
        }
    }

    @Override
    public void setClipRectIndex(int index) {
        this.clipRectIndex = index;
    }

    @Override
    public int getClipRectIndex() {
        return this.clipRectIndex;
    }

    @Override
    public void setHasPreCullingBits(boolean hasBits) {
        this.hasPreCullingBits = hasBits;
    }

    @Override
    public boolean hasPreCullingBits() {
        return this.hasPreCullingBits;
    }

    @Override
    public final void setRenderRoot(NodePath root) {
        this.renderRoot = root;
    }

    @Override
    public final NodePath getRenderRoot() {
        return this.renderRoot;
    }

    private void validateTransformAndPaint() {
        if (this.transform3D.isTranslateOrIdentity() && this.paint.getType() == Paint.Type.COLOR) {
            this.isSimpleTranslate = true;
            this.transX = (float)this.transform3D.getMxt();
            this.transY = (float)this.transform3D.getMyt();
        } else {
            this.isSimpleTranslate = false;
            this.transX = 0.0f;
            this.transY = 0.0f;
        }
    }

    @Override
    public NGCamera getCameraNoClone() {
        return this.camera;
    }

    @Override
    public void setDepthTest(boolean depthTest) {
        this.depthTest = depthTest;
    }

    @Override
    public boolean isDepthTest() {
        return this.depthTest;
    }

    @Override
    public void setDepthBuffer(boolean depthBuffer) {
        this.depthBuffer = depthBuffer;
    }

    @Override
    public boolean isDepthBuffer() {
        return this.depthBuffer;
    }

    @Override
    public boolean isAlphaTestShader() {
        return PrismSettings.forceAlphaTestShader || this.isDepthTest() && this.isDepthBuffer();
    }

    @Override
    public void setAntialiasedShape(boolean aa) {
        this.antialiasedShape = aa;
    }

    @Override
    public boolean isAntialiasedShape() {
        return this.antialiasedShape;
    }

    @Override
    public void setPixelScaleFactor(float pixelScale) {
        this.pixelScale = pixelScale;
    }

    @Override
    public float getPixelScaleFactor() {
        return this.pixelScale;
    }

    @Override
    public void setCamera(NGCamera camera) {
        this.camera = camera;
    }

    @Override
    public Rectangle getClipRect() {
        return this.clipRect != null ? new Rectangle(this.clipRect) : null;
    }

    @Override
    public Rectangle getClipRectNoClone() {
        return this.clipRect;
    }

    @Override
    public RectBounds getFinalClipNoClone() {
        return this.finalClipRect;
    }

    @Override
    public void setClipRect(Rectangle clipRect) {
        this.finalClipRect.setBounds(this.devClipRect);
        if (clipRect == null) {
            this.clipRect = null;
        } else {
            this.clipRect = new Rectangle(clipRect);
            this.finalClipRect.intersectWith(clipRect);
        }
    }

    @Override
    public float getExtraAlpha() {
        return this.extraAlpha;
    }

    @Override
    public void setExtraAlpha(float extraAlpha) {
        this.extraAlpha = extraAlpha;
    }

    @Override
    public CompositeMode getCompositeMode() {
        return this.compMode;
    }

    @Override
    public void setCompositeMode(CompositeMode compMode) {
        this.compMode = compMode;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        this.validateTransformAndPaint();
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void clear() {
        this.clear(Color.TRANSPARENT);
    }

    protected abstract void renderShape(Shape var1, BasicStroke var2, float var3, float var4, float var5, float var6);

    @Override
    public void fill(Shape shape) {
        float bx = 0.0f;
        float by = 0.0f;
        float bw = 0.0f;
        float bh = 0.0f;
        if (this.paint.isProportional()) {
            if (this.nodeBounds != null) {
                bx = this.nodeBounds.getMinX();
                by = this.nodeBounds.getMinY();
                bw = this.nodeBounds.getWidth();
                bh = this.nodeBounds.getHeight();
            } else {
                float[] bbox = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
                Shape.accumulate(bbox, shape, BaseTransform.IDENTITY_TRANSFORM);
                bx = bbox[0];
                by = bbox[1];
                bw = bbox[2] - bx;
                bh = bbox[3] - by;
            }
        }
        this.renderShape(shape, null, bx, by, bw, bh);
    }

    @Override
    public void draw(Shape shape) {
        float bx = 0.0f;
        float by = 0.0f;
        float bw = 0.0f;
        float bh = 0.0f;
        if (this.paint.isProportional()) {
            if (this.nodeBounds != null) {
                bx = this.nodeBounds.getMinX();
                by = this.nodeBounds.getMinY();
                bw = this.nodeBounds.getWidth();
                bh = this.nodeBounds.getHeight();
            } else {
                float[] bbox = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
                Shape.accumulate(bbox, shape, BaseTransform.IDENTITY_TRANSFORM);
                bx = bbox[0];
                by = bbox[1];
                bw = bbox[2] - bx;
                bh = bbox[3] - by;
            }
        }
        this.renderShape(shape, this.stroke, bx, by, bw, bh);
    }

    @Override
    public void drawTexture(Texture tex, float x, float y, float w, float h) {
        this.drawTexture(tex, x, y, x + w, y + h, 0.0f, 0.0f, w, h);
    }

    @Override
    public void drawTexture(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        BaseTransform xform = this.isSimpleTranslate ? IDENT : this.getTransformNoClone();
        PixelFormat format = tex.getPixelFormat();
        if (format == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, xform, tex, dx1, dy1, dx2 - dx1, dy2 - dy1);
        } else {
            this.context.validateTextureOp(this, xform, tex, format);
        }
        if (this.isSimpleTranslate) {
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
        }
        float pw = tex.getPhysicalWidth();
        float ph = tex.getPhysicalHeight();
        float cx1 = tex.getContentX();
        float cy1 = tex.getContentY();
        float tx1 = (cx1 + sx1) / pw;
        float ty1 = (cy1 + sy1) / ph;
        float tx2 = (cx1 + sx2) / pw;
        float ty2 = (cy1 + sy2) / ph;
        VertexBuffer vb = this.context.getVertexBuffer();
        if (this.context.isSuperShaderEnabled()) {
            vb.addSuperQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2, false);
        } else {
            vb.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2);
        }
    }

    @Override
    public void drawTexture3SliceH(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dh1, float dh2, float sh1, float sh2) {
        BaseTransform xform = this.isSimpleTranslate ? IDENT : this.getTransformNoClone();
        PixelFormat format = tex.getPixelFormat();
        if (format == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, xform, tex, dx1, dy1, dx2 - dx1, dy2 - dy1);
        } else {
            this.context.validateTextureOp(this, xform, tex, format);
        }
        if (this.isSimpleTranslate) {
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
            dh1 += this.transX;
            dh2 += this.transX;
        }
        float pw = tex.getPhysicalWidth();
        float ph = tex.getPhysicalHeight();
        float cx1 = tex.getContentX();
        float cy1 = tex.getContentY();
        float tx1 = (cx1 + sx1) / pw;
        float ty1 = (cy1 + sy1) / ph;
        float tx2 = (cx1 + sx2) / pw;
        float ty2 = (cy1 + sy2) / ph;
        float th1 = (cx1 + sh1) / pw;
        float th2 = (cx1 + sh2) / pw;
        VertexBuffer vb = this.context.getVertexBuffer();
        if (this.context.isSuperShaderEnabled()) {
            vb.addSuperQuad(dx1, dy1, dh1, dy2, tx1, ty1, th1, ty2, false);
            vb.addSuperQuad(dh1, dy1, dh2, dy2, th1, ty1, th2, ty2, false);
            vb.addSuperQuad(dh2, dy1, dx2, dy2, th2, ty1, tx2, ty2, false);
        } else {
            vb.addQuad(dx1, dy1, dh1, dy2, tx1, ty1, th1, ty2);
            vb.addQuad(dh1, dy1, dh2, dy2, th1, ty1, th2, ty2);
            vb.addQuad(dh2, dy1, dx2, dy2, th2, ty1, tx2, ty2);
        }
    }

    @Override
    public void drawTexture3SliceV(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dv1, float dv2, float sv1, float sv2) {
        BaseTransform xform = this.isSimpleTranslate ? IDENT : this.getTransformNoClone();
        PixelFormat format = tex.getPixelFormat();
        if (format == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, xform, tex, dx1, dy1, dx2 - dx1, dy2 - dy1);
        } else {
            this.context.validateTextureOp(this, xform, tex, format);
        }
        if (this.isSimpleTranslate) {
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
            dv1 += this.transY;
            dv2 += this.transY;
        }
        float pw = tex.getPhysicalWidth();
        float ph = tex.getPhysicalHeight();
        float cx1 = tex.getContentX();
        float cy1 = tex.getContentY();
        float tx1 = (cx1 + sx1) / pw;
        float ty1 = (cy1 + sy1) / ph;
        float tx2 = (cx1 + sx2) / pw;
        float ty2 = (cy1 + sy2) / ph;
        float tv1 = (cy1 + sv1) / ph;
        float tv2 = (cy1 + sv2) / ph;
        VertexBuffer vb = this.context.getVertexBuffer();
        if (this.context.isSuperShaderEnabled()) {
            vb.addSuperQuad(dx1, dy1, dx2, dv1, tx1, ty1, tx2, tv1, false);
            vb.addSuperQuad(dx1, dv1, dx2, dv2, tx1, tv1, tx2, tv2, false);
            vb.addSuperQuad(dx1, dv2, dx2, dy2, tx1, tv2, tx2, ty2, false);
        } else {
            vb.addQuad(dx1, dy1, dx2, dv1, tx1, ty1, tx2, tv1);
            vb.addQuad(dx1, dv1, dx2, dv2, tx1, tv1, tx2, tv2);
            vb.addQuad(dx1, dv2, dx2, dy2, tx1, tv2, tx2, ty2);
        }
    }

    @Override
    public void drawTexture9Slice(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dh1, float dv1, float dh2, float dv2, float sh1, float sv1, float sh2, float sv2) {
        BaseTransform xform = this.isSimpleTranslate ? IDENT : this.getTransformNoClone();
        PixelFormat format = tex.getPixelFormat();
        if (format == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, xform, tex, dx1, dy1, dx2 - dx1, dy2 - dy1);
        } else {
            this.context.validateTextureOp(this, xform, tex, format);
        }
        if (this.isSimpleTranslate) {
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
            dh1 += this.transX;
            dv1 += this.transY;
            dh2 += this.transX;
            dv2 += this.transY;
        }
        float pw = tex.getPhysicalWidth();
        float ph = tex.getPhysicalHeight();
        float cx1 = tex.getContentX();
        float cy1 = tex.getContentY();
        float tx1 = (cx1 + sx1) / pw;
        float ty1 = (cy1 + sy1) / ph;
        float tx2 = (cx1 + sx2) / pw;
        float ty2 = (cy1 + sy2) / ph;
        float th1 = (cx1 + sh1) / pw;
        float tv1 = (cy1 + sv1) / ph;
        float th2 = (cx1 + sh2) / pw;
        float tv2 = (cy1 + sv2) / ph;
        VertexBuffer vb = this.context.getVertexBuffer();
        if (this.context.isSuperShaderEnabled()) {
            vb.addSuperQuad(dx1, dy1, dh1, dv1, tx1, ty1, th1, tv1, false);
            vb.addSuperQuad(dh1, dy1, dh2, dv1, th1, ty1, th2, tv1, false);
            vb.addSuperQuad(dh2, dy1, dx2, dv1, th2, ty1, tx2, tv1, false);
            vb.addSuperQuad(dx1, dv1, dh1, dv2, tx1, tv1, th1, tv2, false);
            vb.addSuperQuad(dh1, dv1, dh2, dv2, th1, tv1, th2, tv2, false);
            vb.addSuperQuad(dh2, dv1, dx2, dv2, th2, tv1, tx2, tv2, false);
            vb.addSuperQuad(dx1, dv2, dh1, dy2, tx1, tv2, th1, ty2, false);
            vb.addSuperQuad(dh1, dv2, dh2, dy2, th1, tv2, th2, ty2, false);
            vb.addSuperQuad(dh2, dv2, dx2, dy2, th2, tv2, tx2, ty2, false);
        } else {
            vb.addQuad(dx1, dy1, dh1, dv1, tx1, ty1, th1, tv1);
            vb.addQuad(dh1, dy1, dh2, dv1, th1, ty1, th2, tv1);
            vb.addQuad(dh2, dy1, dx2, dv1, th2, ty1, tx2, tv1);
            vb.addQuad(dx1, dv1, dh1, dv2, tx1, tv1, th1, tv2);
            vb.addQuad(dh1, dv1, dh2, dv2, th1, tv1, th2, tv2);
            vb.addQuad(dh2, dv1, dx2, dv2, th2, tv1, tx2, tv2);
            vb.addQuad(dx1, dv2, dh1, dy2, tx1, tv2, th1, ty2);
            vb.addQuad(dh1, dv2, dh2, dy2, th1, tv2, th2, ty2);
            vb.addQuad(dh2, dv2, dx2, dy2, th2, tv2, tx2, ty2);
        }
    }

    @Override
    public void drawTextureVO(Texture tex, float topopacity, float botopacity, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        BaseTransform xform = this.isSimpleTranslate ? IDENT : this.getTransformNoClone();
        PixelFormat format = tex.getPixelFormat();
        if (format == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, xform, tex, dx1, dy1, dx2 - dx1, dy2 - dy1);
        } else {
            this.context.validateTextureOp(this, xform, tex, format);
        }
        if (this.isSimpleTranslate) {
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
        }
        float tw = tex.getPhysicalWidth();
        float th = tex.getPhysicalHeight();
        float cx1 = tex.getContentX();
        float cy1 = tex.getContentY();
        float tx1 = (cx1 + sx1) / tw;
        float ty1 = (cy1 + sy1) / th;
        float tx2 = (cx1 + sx2) / tw;
        float ty2 = (cy1 + sy2) / th;
        VertexBuffer vb = this.context.getVertexBuffer();
        if (topopacity == 1.0f && botopacity == 1.0f) {
            vb.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2);
        } else {
            vb.addQuadVO(topopacity *= this.getExtraAlpha(), botopacity *= this.getExtraAlpha(), dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2);
        }
    }

    @Override
    public void drawTextureRaw(Texture tex, float dx1, float dy1, float dx2, float dy2, float tx1, float ty1, float tx2, float ty2) {
        PixelFormat format;
        float bx = dx1;
        float by = dy1;
        float bw = dx2 - dx1;
        float bh = dy2 - dy1;
        BaseTransform xform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            xform = IDENT;
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
        }
        if ((format = tex.getPixelFormat()) == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, xform, tex, bx, by, bw, bh);
        } else {
            this.context.validateTextureOp(this, xform, tex, format);
        }
        VertexBuffer vb = this.context.getVertexBuffer();
        vb.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2);
    }

    @Override
    public void drawMappedTextureRaw(Texture tex, float dx1, float dy1, float dx2, float dy2, float tx11, float ty11, float tx21, float ty21, float tx12, float ty12, float tx22, float ty22) {
        PixelFormat format;
        float bx = dx1;
        float by = dy1;
        float bw = dx2 - dx1;
        float bh = dy2 - dy1;
        BaseTransform xform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            xform = IDENT;
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
        }
        if ((format = tex.getPixelFormat()) == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, xform, tex, bx, by, bw, bh);
        } else {
            this.context.validateTextureOp(this, xform, tex, format);
        }
        VertexBuffer vb = this.context.getVertexBuffer();
        vb.addMappedQuad(dx1, dy1, dx2, dy2, tx11, ty11, tx21, ty21, tx12, ty12, tx22, ty22);
    }
}

