/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import javafx.animation.Interpolator;

public class SplineInterpolator
extends Interpolator {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final boolean isCurveLinear;
    private static final int SAMPLE_SIZE = 16;
    private static final double SAMPLE_INCREMENT = 0.0625;
    private final double[] xSamples = new double[17];

    public SplineInterpolator(double px1, double py1, double px2, double py2) {
        if (px1 < 0.0 || px1 > 1.0 || py1 < 0.0 || py1 > 1.0 || px2 < 0.0 || px2 > 1.0 || py2 < 0.0 || py2 > 1.0) {
            throw new IllegalArgumentException("Control point coordinates must all be in range [0,1]");
        }
        this.x1 = px1;
        this.y1 = py1;
        this.x2 = px2;
        this.y2 = py2;
        boolean bl = this.isCurveLinear = this.x1 == this.y1 && this.x2 == this.y2;
        if (!this.isCurveLinear) {
            for (int i = 0; i < 17; ++i) {
                this.xSamples[i] = this.eval((double)i * 0.0625, this.x1, this.x2);
            }
        }
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.x1) ^ Double.doubleToLongBits(this.x1) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.y1) ^ Double.doubleToLongBits(this.y1) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.x2) ^ Double.doubleToLongBits(this.x2) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.y2) ^ Double.doubleToLongBits(this.y2) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplineInterpolator other = (SplineInterpolator)obj;
        if (Double.doubleToLongBits(this.x1) != Double.doubleToLongBits(other.x1)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y1) != Double.doubleToLongBits(other.y1)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x2) != Double.doubleToLongBits(other.x2)) {
            return false;
        }
        return Double.doubleToLongBits(this.y2) == Double.doubleToLongBits(other.y2);
    }

    @Override
    public double curve(double x) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("x must be in range [0,1]");
        }
        if (this.isCurveLinear || x == 0.0 || x == 1.0) {
            return x;
        }
        return this.eval(this.findTForX(x), this.y1, this.y2);
    }

    private double eval(double t, double p1, double p2) {
        double compT = 1.0 - t;
        return t * (3.0 * compT * (compT * p1 + t * p2) + t * t);
    }

    private double evalDerivative(double t, double p1, double p2) {
        double compT = 1.0 - t;
        return 3.0 * (compT * (compT * p1 + 2.0 * t * (p2 - p1)) + t * t * (1.0 - p2));
    }

    private double getInitialGuessForT(double x) {
        for (int i = 1; i < 17; ++i) {
            if (!(this.xSamples[i] >= x)) continue;
            double xRange = this.xSamples[i] - this.xSamples[i - 1];
            if (xRange == 0.0) {
                return (double)(i - 1) * 0.0625;
            }
            return ((double)(i - 1) + (x - this.xSamples[i - 1]) / xRange) * 0.0625;
        }
        return 1.0;
    }

    private double findTForX(double x) {
        double dXdT;
        double xT;
        double t = this.getInitialGuessForT(x);
        int numIterations = 4;
        for (int i = 0; i < 4 && (xT = this.eval(t, this.x1, this.x2) - x) != 0.0 && (dXdT = this.evalDerivative(t, this.x1, this.x2)) != 0.0; ++i) {
            t -= xT / dXdT;
        }
        return t;
    }

    public String toString() {
        return "SplineInterpolator [x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + "]";
    }
}

