/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGParallelCamera;
import javafx.scene.Camera;

public class ParallelCamera
extends Camera {
    @Override
    Camera copy() {
        ParallelCamera c = new ParallelCamera();
        c.setNearClip(this.getNearClip());
        c.setFarClip(this.getFarClip());
        return c;
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        NGParallelCamera peer = new NGParallelCamera();
        peer.setNearClip((float)this.getNearClip());
        peer.setFarClip((float)this.getFarClip());
        return peer;
    }

    @Override
    final PickRay computePickRay(double x, double y, PickRay pickRay) {
        return PickRay.computeParallelPickRay(x, y, this.getViewHeight(), this.getCameraTransform(), this.getNearClip(), this.getFarClip(), pickRay);
    }

    @Override
    void computeProjectionTransform(GeneralTransform3D proj) {
        double viewHeight;
        double viewWidth = this.getViewWidth();
        double halfDepth = viewWidth > (viewHeight = this.getViewHeight()) ? viewWidth / 2.0 : viewHeight / 2.0;
        proj.ortho(0.0, viewWidth, viewHeight, 0.0, -halfDepth, halfDepth);
    }

    @Override
    void computeViewTransform(Affine3D view) {
        view.setToIdentity();
    }

    @Override
    Vec3d computePosition(Vec3d position) {
        if (position == null) {
            position = new Vec3d();
        }
        double halfViewWidth = this.getViewWidth() / 2.0;
        double halfViewHeight = this.getViewHeight() / 2.0;
        double distanceZ = halfViewHeight / Math.tan(Math.toRadians(15.0));
        position.set(halfViewWidth, halfViewHeight, -distanceZ);
        return position;
    }
}

