/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public abstract class SkinBase<C extends Control>
implements Skin<C> {
    private C control;
    private ObservableList<Node> children;
    private static final EventHandler<MouseEvent> mouseEventConsumer = event -> event.consume();

    protected SkinBase(C control) {
        if (control == null) {
            throw new IllegalArgumentException("Cannot pass null for control");
        }
        this.control = control;
        this.children = ((Control)control).getControlChildren();
        this.consumeMouseEvents(true);
    }

    @Override
    public final C getSkinnable() {
        return this.control;
    }

    @Override
    public final Node getNode() {
        return this.control;
    }

    @Override
    public void dispose() {
        this.control = null;
    }

    public final ObservableList<Node> getChildren() {
        return this.children;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            Node child = (Node)this.children.get(i);
            if (!child.isManaged()) continue;
            this.layoutInArea(child, contentX, contentY, contentWidth, contentHeight, -1.0, HPos.CENTER, VPos.CENTER);
        }
    }

    protected final void consumeMouseEvents(boolean value) {
        if (value) {
            ((Node)this.control).addEventHandler(MouseEvent.ANY, mouseEventConsumer);
        } else {
            ((Node)this.control).removeEventHandler(MouseEvent.ANY, mouseEventConsumer);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double minX = 0.0;
        double maxX = 0.0;
        boolean firstManagedChild = true;
        for (int i = 0; i < this.children.size(); ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isManaged()) continue;
            double x = node.getLayoutBounds().getMinX() + node.getLayoutX();
            if (!firstManagedChild) {
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x + node.minWidth(-1.0));
                continue;
            }
            minX = x;
            maxX = x + node.minWidth(-1.0);
            firstManagedChild = false;
        }
        double minWidth = maxX - minX;
        return leftInset + minWidth + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double minY = 0.0;
        double maxY = 0.0;
        boolean firstManagedChild = true;
        for (int i = 0; i < this.children.size(); ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isManaged()) continue;
            double y = node.getLayoutBounds().getMinY() + node.getLayoutY();
            if (!firstManagedChild) {
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y + node.minHeight(-1.0));
                continue;
            }
            minY = y;
            maxY = y + node.minHeight(-1.0);
            firstManagedChild = false;
        }
        double minHeight = maxY - minY;
        return topInset + minHeight + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double minX = 0.0;
        double maxX = 0.0;
        boolean firstManagedChild = true;
        for (int i = 0; i < this.children.size(); ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isManaged()) continue;
            double x = node.getLayoutBounds().getMinX() + node.getLayoutX();
            if (!firstManagedChild) {
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x + node.prefWidth(-1.0));
                continue;
            }
            minX = x;
            maxX = x + node.prefWidth(-1.0);
            firstManagedChild = false;
        }
        return maxX - minX;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double minY = 0.0;
        double maxY = 0.0;
        boolean firstManagedChild = true;
        for (int i = 0; i < this.children.size(); ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isManaged()) continue;
            double y = node.getLayoutBounds().getMinY() + node.getLayoutY();
            if (!firstManagedChild) {
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y + node.prefHeight(-1.0));
                continue;
            }
            minY = y;
            maxY = y + node.prefHeight(-1.0);
            firstManagedChild = false;
        }
        return maxY - minY;
    }

    protected double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            double offset;
            Node child = (Node)this.children.get(i);
            if (!child.isManaged() || (offset = child.getBaselineOffset()) == Double.NEGATIVE_INFINITY) continue;
            return child.getLayoutBounds().getMinY() + child.getLayoutY() + offset;
        }
        return Double.NEGATIVE_INFINITY;
    }

    protected double snappedTopInset() {
        return ((Region)this.control).snappedTopInset();
    }

    protected double snappedBottomInset() {
        return ((Region)this.control).snappedBottomInset();
    }

    protected double snappedLeftInset() {
        return ((Region)this.control).snappedLeftInset();
    }

    protected double snappedRightInset() {
        return ((Region)this.control).snappedRightInset();
    }

    protected double snapSpace(double value) {
        return ((Region)this.control).isSnapToPixel() ? (double)Math.round(value) : value;
    }

    protected double snapSize(double value) {
        return ((Region)this.control).isSnapToPixel() ? Math.ceil(value) : value;
    }

    protected double snapPosition(double value) {
        return ((Region)this.control).isSnapToPixel() ? (double)Math.round(value) : value;
    }

    protected void positionInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, HPos halignment, VPos valignment) {
        this.positionInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, Insets.EMPTY, halignment, valignment);
    }

    protected void positionInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, HPos halignment, VPos valignment) {
        Region.positionInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, margin, halignment, valignment, ((Region)this.control).isSnapToPixel());
    }

    protected void layoutInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, HPos halignment, VPos valignment) {
        this.layoutInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, Insets.EMPTY, true, true, halignment, valignment);
    }

    protected void layoutInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, HPos halignment, VPos valignment) {
        this.layoutInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, margin, true, true, halignment, valignment);
    }

    protected void layoutInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, boolean fillWidth, boolean fillHeight, HPos halignment, VPos valignment) {
        Region.layoutInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, margin, fillWidth, fillHeight, halignment, valignment, ((Region)this.control).isSnapToPixel());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return SkinBase.getClassCssMetaData();
    }

    public final void pseudoClassStateChanged(PseudoClass pseudoClass, boolean active) {
        Skinnable ctl = this.getSkinnable();
        if (ctl != null) {
            ((Node)((Object)ctl)).pseudoClassStateChanged(pseudoClass, active);
        }
    }

    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        return null;
    }

    protected void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES = Collections.unmodifiableList(Control.getClassCssMetaData());

        private StyleableProperties() {
        }
    }
}

