/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import java.util.HashMap;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Sphere;
import javafx.scene.shape.TriangleMesh;

final class PredefinedMeshManager {
    private static final PredefinedMeshManager INSTANCE = new PredefinedMeshManager();
    private static final int INITAL_CAPACITY = 17;
    private static final float LOAD_FACTOR = 0.75f;
    private HashMap<Integer, TriangleMesh> boxCache = null;
    private HashMap<Integer, TriangleMesh> sphereCache = null;
    private HashMap<Integer, TriangleMesh> cylinderCache = null;

    private PredefinedMeshManager() {
    }

    static PredefinedMeshManager getInstance() {
        return INSTANCE;
    }

    synchronized TriangleMesh getBoxMesh(float w, float h, float d, int key) {
        TriangleMesh mesh;
        if (this.boxCache == null) {
            this.boxCache = BoxCacheLoader.INSTANCE;
        }
        if ((mesh = this.boxCache.get(key)) == null) {
            mesh = Box.createMesh(w, h, d);
            this.boxCache.put(key, mesh);
        } else {
            mesh.incRef();
        }
        return mesh;
    }

    synchronized TriangleMesh getSphereMesh(float r, int div, int key) {
        TriangleMesh mesh;
        if (this.sphereCache == null) {
            this.sphereCache = SphereCacheLoader.INSTANCE;
        }
        if ((mesh = this.sphereCache.get(key)) == null) {
            mesh = Sphere.createMesh(div, r);
            this.sphereCache.put(key, mesh);
        } else {
            mesh.incRef();
        }
        return mesh;
    }

    synchronized TriangleMesh getCylinderMesh(float h, float r, int div, int key) {
        TriangleMesh mesh;
        if (this.cylinderCache == null) {
            this.cylinderCache = CylinderCacheLoader.INSTANCE;
        }
        if ((mesh = this.cylinderCache.get(key)) == null) {
            mesh = Cylinder.createMesh(div, h, r);
            this.cylinderCache.put(key, mesh);
        } else {
            mesh.incRef();
        }
        return mesh;
    }

    synchronized void invalidateBoxMesh(int key) {
        TriangleMesh mesh;
        if (this.boxCache != null && (mesh = this.boxCache.get(key)) != null) {
            mesh.decRef();
            int count = mesh.getRefCount();
            if (count == 0) {
                this.boxCache.remove(key);
            }
        }
    }

    synchronized void invalidateSphereMesh(int key) {
        TriangleMesh mesh;
        if (this.sphereCache != null && (mesh = this.sphereCache.get(key)) != null) {
            mesh.decRef();
            int count = mesh.getRefCount();
            if (count == 0) {
                this.sphereCache.remove(key);
            }
        }
    }

    synchronized void invalidateCylinderMesh(int key) {
        TriangleMesh mesh;
        if (this.cylinderCache != null && (mesh = this.cylinderCache.get(key)) != null) {
            mesh.decRef();
            int count = mesh.getRefCount();
            if (count == 0) {
                this.cylinderCache.remove(key);
            }
        }
    }

    synchronized void dispose() {
        if (this.boxCache != null) {
            this.boxCache.clear();
        }
        if (this.sphereCache != null) {
            this.sphereCache.clear();
        }
        if (this.cylinderCache != null) {
            this.cylinderCache.clear();
        }
    }

    synchronized void printStats() {
        if (this.boxCache != null) {
            System.out.println("BoxCache size:  " + this.boxCache.size());
        }
        if (this.sphereCache != null) {
            System.out.println("SphereCache size:    " + this.sphereCache.size());
        }
        if (this.cylinderCache != null) {
            System.out.println("CylinderCache size:    " + this.cylinderCache.size());
        }
    }

    private static final class CylinderCacheLoader {
        private static final HashMap<Integer, TriangleMesh> INSTANCE = new HashMap(17, 0.75f);

        private CylinderCacheLoader() {
        }
    }

    private static final class SphereCacheLoader {
        private static final HashMap<Integer, TriangleMesh> INSTANCE = new HashMap(17, 0.75f);

        private SphereCacheLoader() {
        }
    }

    private static final class BoxCacheLoader {
        private static final HashMap<Integer, TriangleMesh> INSTANCE = new HashMap(17, 0.75f);

        private BoxCacheLoader() {
        }
    }
}

