/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class JViewer {
    public static void main(String[] args) {
        if (args.length < 11) {
            JViewer.printUsage();
            return;
        }
        int port = 7578;
        int hid_port = 5678;
        byte[] ip = JViewer.getServerIP(args[0]);
        if (ip == null) {
            JViewer.printUsage();
            return;
        }
        try {
            port = Integer.parseInt(args[1]);
            hid_port = Integer.parseInt(args[8]);
        }
        catch (NumberFormatException e) {
            JViewer.printUsage();
            return;
        }
        int SecureChannel = 0;
        int VMSecureChannel = 0;
        int UserPrivileges = 0;
        int kvm_enabled = 0;
        try {
            SecureChannel = Integer.parseInt(args[3]);
            VMSecureChannel = Integer.parseInt(args[4]);
            UserPrivileges = Integer.parseInt(args[7]);
            kvm_enabled = Integer.parseInt(args[9]);
        }
        catch (NumberFormatException e) {
            System.out.println(LocaleStrings.GetString("1_1_JVIEWER"));
            JViewer.printUsage();
            return;
        }
        if (SecureChannel != 0 && SecureChannel != 1 || VMSecureChannel != 0 && VMSecureChannel != 1) {
            JViewer.printUsage();
            return;
        }
        boolean UseSSL = SecureChannel == 1;
        boolean VMUseSSL = VMSecureChannel == 1;
        int cdserver_port = 0;
        try {
            cdserver_port = Integer.parseInt(args[5]);
        }
        catch (NumberFormatException e) {
            JViewer.printUsage();
            return;
        }
        int fdserver_port = 0;
        try {
            fdserver_port = Integer.parseInt(args[6]);
        }
        catch (NumberFormatException e) {
            JViewer.printUsage();
            return;
        }
        System.out.println("VKVM Connecting to " + args[0] + ":" + port + (UseSSL ? " (SSL)" : " (Non-SSL)"));
        System.out.println("HID to " + args[0] + ":" + hid_port);
        System.out.println("VMedia Connecting to CD:" + cdserver_port + " FD:" + fdserver_port + (VMUseSSL ? " (SSL)" : " (Non-SSL)"));
        System.out.println("UserPrivileges " + UserPrivileges);
        JViewerApp app = new JViewerApp();
        app.setPanelMode(false);
        app.getParams().SetUserPriv(UserPrivileges);
        app.getParams().SetKVMEnabled(kvm_enabled);
        app.createUI();
        LocaleStrings.SetLanguageID(args[10]);
        app.OnConnectToServer(ip, port, hid_port, args[2], UseSSL, VMUseSSL, cdserver_port, fdserver_port, UserPrivileges);
    }

    public static void printUsage() {
        Debug.out.println("Invalid arguments, please try again");
        Debug.out.println("Usage: java -jar JViewer.jar <ip address> <port number> <token> <ssl for vdeo> <ssl for vmedia> <cdserver port> <fdserver port> <user privileges> <hid_port> <is kvm enabled> <language>");
        Debug.out.println("<ssl for video> 1 for secure connection and 0 for non-secure ");
        Debug.out.println("<ssl for vmedia> 1 for secure connection and 0 for non-secure ");
        Debug.out.println("<user privileges> ");
        Debug.out.println("                  0x00000020 - VKVM permissions only");
        Debug.out.println("                  0x00000040 - VMedia permissions only");
        Debug.out.println("                  0x00000060 - VKVM & VMedia permissions");
        Debug.out.println("<language> ");
        Debug.out.println("                  EN - English");
        Debug.out.println("                  ES - Spanish");
        Debug.out.println("                  FR - French");
        Debug.out.println("                  DE - Dutch");
        Debug.out.println("                  ZH - Chinese");
        Debug.out.println("                  JA - Japanese");
    }

    private static byte[] getServerIP(String ipStr) {
        boolean invalidIP = false;
        try {
            InetAddress hostAddress = InetAddress.getByName(ipStr);
            ipStr = hostAddress.getHostAddress();
            Debug.out.println("Resolving to IPAddress " + ipStr);
        }
        catch (UnknownHostException hostAddress) {
            // empty catch block
        }
        if (ipStr.trim().length() <= 0) {
            return null;
        }
        String[] ipDgtStr = ipStr.split("\\.");
        if (ipDgtStr.length != 4) {
            return null;
        }
        byte[] ipDgt = new byte[4];
        for (int i = 0; i < 4; ++i) {
            try {
                ipDgt[i] = (byte)Short.parseShort(ipDgtStr[i]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (ipDgt[i] <= 255) continue;
            return null;
        }
        return ipDgt;
    }
}

