/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class IPMIOEMIpv6Command
extends IPMICommand {
    public IPMIOEMIpv6Command(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getIPv6NetworkCommand(byte parameter) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, 0, parameter};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setIPv6NetworkCommand(byte state, byte autoconfig, byte action, byte[] address) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5 + address.length];
        data[0] = 9;
        data[1] = 1;
        data[2] = state;
        data[3] = autoconfig;
        data[4] = action;
        System.arraycopy(address, 0, data, 5, address.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIPv6DNSServerCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, 0, 1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setIPv6DNSServerCommand(byte[] address) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[20];
        data[0] = 10;
        data[1] = 1;
        data[2] = 1;
        data[3] = 0;
        System.arraycopy(address, 0, data, 4, 16);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearIPv6DNSServerCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, 1, 1, 1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void API____________() {
    }

    public boolean isIPV6ModeStateful() throws IPMIException {
        IPMIMessage resMessage = this.getIPv6NetworkCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] != 0;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6NetworkCommand failed");
    }

    public boolean isAutoConfig() throws IPMIException {
        IPMIMessage resMessage = this.getIPv6NetworkCommand((byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] != 0;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6NetworkCommand failed");
    }

    public boolean setIPV6Network(boolean stateful, boolean autoconfig) {
        byte[] address;
        byte autoconfigByte;
        byte stateByte = !stateful ? (byte)0 : 1;
        IPMIMessage resMessage = this.setIPv6NetworkCommand(stateByte, autoconfigByte = autoconfig ? (byte)1 : 0, (byte)0, address = new byte[17]);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public byte[] getIPV6DNS() throws IPMIException {
        IPMIMessage resMessage = this.getIPv6DNSServerCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data.length == 0) {
                    return null;
                }
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6DNSCommand failed");
    }

    public boolean setIPV6DNS(String address) throws IPMIException {
        String s = address.replaceAll(":", "");
        byte[] IP = ByteUtility.hexToBytes(s);
        IPMIMessage resMessage = this.setIPv6DNSServerCommand(IP);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setIPv6DNSCommand failed");
    }

    public boolean clearIPV6DNS() throws IPMIException {
        IPMIMessage resMessage = this.clearIPv6DNSServerCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setIPv6DNSCommand failed");
    }

    public byte[] getDuid() throws IPMIException {
        IPMIMessage resMessage = this.getIPv6NetworkCommand((byte)3);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6NetworkCommand failed");
    }
}

