/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.smbios.TypeStruct;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BaseboardInfo
extends TypeStruct {
    byte[] manufacturer;
    byte[] product;
    byte[] version;
    byte[] serialNumber;
    byte[] assetTag;
    byte[] featureFlags;
    byte[] locationInChassis;
    byte[] chassisHandle;
    byte[] boardType;
    byte[] containedObjectHandlesNumber;
    byte[] containedObjectHandles;

    public BaseboardInfo(byte[] dataByte) {
        super(dataByte);
        this.manufacturer = this.getTypeLength(this.BYTE);
        this.product = this.getTypeLength(this.BYTE);
        this.version = this.getTypeLength(this.BYTE);
        this.serialNumber = this.getTypeLength(this.BYTE);
        this.assetTag = this.getTypeLength(this.BYTE);
        this.featureFlags = this.getTypeLength(this.BYTE);
        this.locationInChassis = this.getTypeLength(this.BYTE);
        this.chassisHandle = this.getTypeLength(this.WORD);
        ArrayUtils.reverse((byte[])this.chassisHandle);
        this.boardType = this.getTypeLength(this.BYTE);
        this.containedObjectHandlesNumber = this.getTypeLength(this.BYTE);
        this.containedObjectHandles = this.getTypeLength(this.length - 15);
        this.strFieldCount = 8;
    }

    int getManufacturer() {
        return this.manufacturer[0];
    }

    int getProduct() {
        return this.product[0];
    }

    int getVersion() {
        return this.version[0];
    }

    int getSerialNumber() {
        return this.serialNumber[0];
    }

    int getAssetTag() {
        return this.assetTag[0];
    }

    String getFeatureFlags() {
        StringBuilder sb = new StringBuilder();
        BitSet bitSet = BitSet.valueOf(new byte[]{this.featureFlags[0]});
        if (bitSet.get(0)) {
            sb.append(" The board is a hosting board \n");
        }
        if (bitSet.get(1)) {
            sb.append(" Requires daughter board / auxiliary card \n");
        }
        if (bitSet.get(2)) {
            sb.append(" The board is removable \n");
        }
        if (bitSet.get(3)) {
            sb.append(" The board is replaceable \n");
        }
        if (bitSet.get(4)) {
            sb.append(" The board is hot swappable \n");
        }
        int zeroCount = 0;
        for (int i = 0; i <= 4; ++i) {
            if (!bitSet.get(i)) continue;
            ++zeroCount;
        }
        if (zeroCount == 0) {
            return "Reserved (0x" + ByteUtility.byteToHex(this.featureFlags[0]) + ")";
        }
        return sb.toString();
    }

    int getLocationInChassis() {
        return this.locationInChassis[0];
    }

    String getChassisHandle() {
        return ByteUtility.bytesToHexNoSpace(this.chassisHandle);
    }

    String getBoardType() {
        switch (this.boardType[0]) {
            case 1: {
                return "Unknown";
            }
            case 2: {
                return "Other";
            }
            case 3: {
                return "Server Blade";
            }
            case 4: {
                return "Connectivity Switch";
            }
            case 5: {
                return "System Management Module";
            }
            case 6: {
                return "Processor Module";
            }
            case 7: {
                return "I/O Module";
            }
            case 8: {
                return "Memory Module";
            }
            case 9: {
                return "Daughter board";
            }
            case 10: {
                return "Motherboard";
            }
            case 11: {
                return "Processor/Memory Module";
            }
            case 12: {
                return "Processor/IO Module";
            }
            case 13: {
                return "Interconnect board";
            }
        }
        return null;
    }

    int getContainedObjectHandlesNumber() {
        return this.containedObjectHandlesNumber[0];
    }

    String getContainedObjectHandles() {
        return new String(this.containedObjectHandles);
    }

    public String getBaseboardManufacturer() {
        return this.strField[this.getManufacturer()] != null ? this.strField[this.getManufacturer()] : "N/A";
    }

    public String getBaseboardProduct() {
        return this.strField[this.getProduct()] != null ? this.strField[this.getProduct()] : "N/A";
    }

    public String getBaseboardVersion() {
        return this.strField[this.getVersion()] != null ? this.strField[this.getVersion()] : "N/A";
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Type", (this.type & 0xFF) + " (0x" + this.getType() + ")"));
        fStr.append(String.format(format, "Structure", "Baseboard/Module Information"));
        if (this.debug) {
            fStr.append(String.format(format, "Length", (this.length & 0xFF) + " (0x" + this.getLength() + ")"));
            fStr.append(String.format(format, "Handle", "0x" + this.getHandle()));
        }
        fStr.append(String.format(format, "Manufacturer", this.strField[this.getManufacturer()] != null ? this.strField[this.getManufacturer()] : "N/A"));
        fStr.append(String.format(format, "Product", this.strField[this.getProduct()] != null ? this.strField[this.getProduct()] : "N/A"));
        fStr.append(String.format(format, "Version", this.strField[this.getVersion()] != null ? this.strField[this.getVersion()] : "N/A"));
        fStr.append(String.format(format, "Serial Number", this.strField[this.getSerialNumber()] != null ? this.strField[this.getSerialNumber()] : "N/A"));
        fStr.append(String.format(format, "AssetTag", this.strField[this.getAssetTag()] != null ? this.strField[this.getAssetTag()] : "N/A"));
        if (this.debug) {
            fStr.append(String.format(format, "Location In Chassis", this.strField[this.getLocationInChassis()] != null ? this.strField[this.getLocationInChassis()] : "N/A"));
            fStr.append(String.format(format, "Chassis Handle", "0x" + this.getChassisHandle()));
        }
        fStr.append(String.format(format, "Board Type", this.getBoardType()));
        if (this.debug) {
            fStr.append(String.format(format, "Contained Obj Handles Number", this.getContainedObjectHandlesNumber()));
            fStr.append(String.format(format, "Contained Obj Handles", StringUtils.isNotBlank((CharSequence)this.getContainedObjectHandles()) ? this.getContainedObjectHandles() : "(None)"));
            fStr.append(String.format("---------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(" Feature Flags: \n", new Object[0]));
            fStr.append(String.format("---------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(this.getFeatureFlags(), new Object[0]));
            fStr.append(String.format("\n", new Object[0]));
        }
        return fStr.toString();
    }
}

