/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;
import com.supermicro.ipmi.text.NMPolicyDto;
import com.supermicro.ipmi.text.NMPolicyFinder;

public class NM20AddPolicyCommand
extends NM20AbstractCommand {
    private byte id;
    private byte did;
    private byte ptt;
    private byte aggC;
    private byte a;
    private int l;
    private int t;
    private int tl;
    private int p;
    private int ca;

    @Override
    public void runNM20Command() throws Exception {
        if (this.parameters == null || this.parameters.length < 9) {
            MOut.G(this).println("addPolicy <dID> <pID> <ptt> <agg> <a> <l> <t> <tl> <p> [<ca>]");
            MOut.G(this).println("dID: Domain ID");
            MOut.G(this).println("  0 \u00a1V Entire platform");
            MOut.G(this).println("  1 \u00a1V CPU subsystem");
            MOut.G(this).println("  2 \u00a1V Memory subsystem");
            MOut.G(this).println("  3 \u00a1V HW protection");
            MOut.G(this).println("  4 \u00a1V High Power I/O subsystem");
            MOut.G(this).println("pID: Policy ID");
            MOut.G(this).println("ptt: Policy Trigger Type");
            MOut.G(this).println("  0 \u00a1V No Policy Trigger");
            MOut.G(this).println("  1 \u00a1V Inlet Temperature Limit Policy Trigger in [Celsius]");
            MOut.G(this).println("  2 \u00a1V Missing Power Reading Timeout in 1/10th of second");
            MOut.G(this).println("  3 \u00a1V Time After Host Reset Trigger in 1/10th of second");
            MOut.G(this).println("  4 \u00a1V Boot time policy");
            MOut.G(this).println("  6 \u00a1V MGPIO Policy Trigger");
            MOut.G(this).println("agg: Aggressive CPU Power Correction");
            MOut.G(this).println("  0 \u00a1V Automatic mode (default).");
            MOut.G(this).println("  1 \u00a1V Force non-aggressive mode");
            MOut.G(this).println("  2 \u00a1V Force aggressive mode");
            MOut.G(this).println("a: Policy Exception Actions");
            MOut.G(this).println("  1 - send alert");
            MOut.G(this).println("  2 - shutdown system");
            MOut.G(this).println("  3 - send alert & shutdown system");
            MOut.G(this).println("l: Policy Target Limit");
            MOut.G(this).println("t: Correction Time Limit (ms)");
            MOut.G(this).println("tl: Policy Trigger Limit");
            MOut.G(this).println("p: Statistics Reporting Period in seconds");
            MOut.G(this).println("ca: Policy ID conflict action");
            MOut.G(this).println("  0 - no action (default)");
            MOut.G(this).println("  1 - overwrite");
            this.statusCode = 0;
            return;
        }
        this.t = 60000;
        this.p = 1;
        this.ca = 0;
        try {
            this.did = Byte.parseByte(this.parameters[0]);
            this.id = (byte)Integer.parseInt(this.parameters[1]);
            this.ptt = Byte.parseByte(this.parameters[2]);
            this.aggC = Byte.parseByte(this.parameters[3]);
            this.a = Byte.parseByte(this.parameters[4]);
            this.l = Integer.parseInt(this.parameters[5]);
            this.t = Integer.parseInt(this.parameters[6]);
            this.tl = Integer.parseInt(this.parameters[7]);
            this.p = Integer.parseInt(this.parameters[8]);
            if (this.parameters.length == 10) {
                this.ca = Integer.parseInt(this.parameters[9]);
                if (this.ca != 0 && this.ca != 1) {
                    MOut.G(this).println("Invalid value of <ca>");
                    this.statusCode = 147;
                    return;
                }
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        NMPolicyFinder pf = new NMPolicyFinder(this.ipmiNM20Command, this.id);
        if (pf.hasExist()) {
            System.out.println("Policy ID is conflict!\n");
            this.displayCompareTable(pf.policy);
            System.out.println("Policy ID conflict action: " + (this.ca == 1 ? "Overwrite" : "No action"));
            if (this.ca == 0) {
                System.out.println("If the policy need to be overwritten, please set the <ca> to 1.");
                this.statusCode = 0;
                return;
            }
        }
        IPMINM20Command.NodeManagerPolicySetting policySetting = this.ipmiNM20Command.createNodeManagerPolicySetting();
        policySetting.domainID = (byte)(this.did | 0x10);
        policySetting.policyID = this.id;
        policySetting.policyConfig = (byte)(this.aggC << 5 & 0x60 | 0x10 | this.ptt & 0xF);
        policySetting.PolicyException = this.a;
        ByteUtility.intTo2Bytes(policySetting.powerLimit, 0, this.l);
        ByteUtility.intTo4Bytes(policySetting.correctionTimeLimit, 0, this.t);
        ByteUtility.intTo2Bytes(policySetting.policyTriggerLimit, 0, this.tl);
        ByteUtility.intTo2Bytes(policySetting.statisticsReportingPeriod, 0, this.p);
        try {
            this.ipmiNM20Command.setNodeManagerPolicy(policySetting);
            this.ipmiNM20Command.enableDisableNodeManagerPolicyControl((byte)5, this.did, this.id);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }

    public void displayCompareTable(NMPolicyDto pd) {
        StringBuilder sb = new StringBuilder();
        String format = "%-32s|%8s|%6s\n";
        sb.append(String.format(format, "Item", "Current", "New"));
        sb.append(String.format(format, "--------------------------------", "--------", "------"));
        sb.append(String.format(format, "Domain ID", pd.domainId, this.did));
        sb.append(String.format(format, "Policy Trigger Type", pd.triggerTypeId, this.ptt));
        sb.append(String.format(format, "Aggressive CPU Power Correction", pd.aggMode, this.aggC));
        sb.append(String.format(format, "Policy Exception Actions", pd.expAction, this.a));
        sb.append(String.format(format, "Policy Target Limit", pd.getTargetLimit(), this.l));
        sb.append(String.format(format, "Correction Time Limit", pd.corrTime, this.t));
        sb.append(String.format(format, "Policy Trigger Limit", pd.triggerLimit, this.tl));
        sb.append(String.format(format, "Statistics Reporting Period", pd.statPeriod, this.p));
        System.out.println(sb.toString());
    }
}

